/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.PlaceLabelsAction;
import com.paterva.maltego.ui.graph.actions.ShowLabels;
import com.paterva.maltego.ui.graph.view2d.LinkEdgeRealizer;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openide.util.NbPreferences;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.ribbon.JFlowRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.internal.ui.ribbon.JFlowBandControlPanel;
import y.base.Edge;
import y.base.Graph;
import y.view.EdgeRealizer;
import y.view.Graph2D;

public class LinksRibbonBand
extends JFlowRibbonBand
implements ItemListener {
    private static final String PREF_PROPS_FOR_APPEARANCE = "propertiesCanChangeLinkAppearance";
    private JCheckBox _checkBoxManual = null;
    private JCheckBox _checkBoxTransform = null;
    private JCheckBox _checkBoxAll = null;
    private JCheckBox _checkBoxUseProperties = null;

    public LinksRibbonBand() {
        super("Links", null);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel backgoundPanel = new JPanel();
        backgoundPanel.setBackground(new Color(198, 206, 213));
        backgoundPanel.setOpaque(false);
        backgoundPanel.setLayout(new BoxLayout(backgoundPanel, 1));
        panel.add(backgoundPanel);
        ShowLabels showLabels = ShowLabels.instance();
        this._checkBoxAll = new JCheckBox("Show All Link Labels", showLabels.isShowLabelsForAllLinks());
        this._checkBoxAll.setFont(new JCheckBox().getFont().deriveFont(0));
        this._checkBoxAll.setAlignmentX(0.0f);
        this._checkBoxAll.setOpaque(false);
        this._checkBoxAll.addItemListener(this);
        this._checkBoxAll.setForeground(UIManager.getColor("Button.foreground"));
        this._checkBoxAll.setVisible(false);
        backgoundPanel.add(this._checkBoxAll);
        JPanel innerPanel = new JPanel();
        innerPanel.setOpaque(false);
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        backgoundPanel.add(innerPanel);
        this._checkBoxManual = new JCheckBox("Show Custom Link Labels", showLabels.isShowLabelsForManualLinks());
        this._checkBoxManual.setFont(new JCheckBox().getFont().deriveFont(0));
        this._checkBoxManual.setToolTipText("Show custom link labels");
        this._checkBoxManual.setOpaque(false);
        this._checkBoxManual.addItemListener(this);
        this._checkBoxManual.setForeground(UIManager.getColor("Button.foreground"));
        this._checkBoxManual.setAlignmentX(0.0f);
        this._checkBoxTransform = new JCheckBox("Show Transform Link Labels", showLabels.isShowLabelsForTransformLinks());
        this._checkBoxTransform.setFont(new JCheckBox().getFont().deriveFont(0));
        this._checkBoxTransform.setToolTipText("Show transform link labels");
        this._checkBoxTransform.setOpaque(false);
        this._checkBoxTransform.addItemListener(this);
        this._checkBoxTransform.setForeground(UIManager.getColor("Button.foreground"));
        this._checkBoxTransform.setAlignmentX(0.0f);
        this._checkBoxUseProperties = new JCheckBox("Properties Affect Appearance", this.getPropsUsedForAppearance());
        this._checkBoxUseProperties.setFont(new JCheckBox().getFont().deriveFont(0));
        this._checkBoxUseProperties.setToolTipText("Let the weight and/or other properties of a link influence its appearance");
        this._checkBoxUseProperties.setOpaque(false);
        this._checkBoxUseProperties.addItemListener(this);
        this._checkBoxUseProperties.setForeground(UIManager.getColor("Button.foreground"));
        this._checkBoxUseProperties.setAlignmentX(0.0f);
        innerPanel.add(this._checkBoxManual);
        innerPanel.add(this._checkBoxTransform);
        innerPanel.add(this._checkBoxUseProperties);
        JRibbonComponent component = new JRibbonComponent((JComponent)panel);
        this.addFlowComponent((JComponent)component);
        ArrayList<CoreRibbonResizePolicies.FlowThreeRows> policyList = new ArrayList<CoreRibbonResizePolicies.FlowThreeRows>();
        policyList.add(new CoreRibbonResizePolicies.FlowThreeRows((JFlowBandControlPanel)this.getControlPanel()));
        this.setResizePolicies(policyList);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean newValue;
        boolean oldValue;
        Object item = e.getItem();
        ShowLabels showLabels = ShowLabels.instance();
        if (item == this._checkBoxManual) {
            showLabels.setShowLabelsForManualLinks(this._checkBoxManual.isSelected());
            this._checkBoxAll.setSelected(showLabels.isShowLabelsForAllLinks());
            this.updateLinks();
        } else if (item == this._checkBoxTransform) {
            showLabels.setShowLabelsForTransformLinks(this._checkBoxTransform.isSelected());
            this._checkBoxAll.setSelected(showLabels.isShowLabelsForAllLinks());
            this.updateLinks();
        } else if (item == this._checkBoxAll) {
            showLabels.setShowLabelsForAllLinks(this._checkBoxAll.isSelected());
            this._checkBoxManual.setSelected(showLabels.isShowLabelsForManualLinks());
            this._checkBoxTransform.setSelected(showLabels.isShowLabelsForTransformLinks());
            this.updateLinks();
        } else if (item == this._checkBoxUseProperties && (oldValue = this.getPropsUsedForAppearance()) != (newValue = this._checkBoxUseProperties.isSelected())) {
            this.getPreferences().putBoolean(PREF_PROPS_FOR_APPEARANCE, this._checkBoxUseProperties.isSelected());
            this.updateLinks();
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(LinksRibbonBand.class);
    }

    private boolean getPropsUsedForAppearance() {
        return this.getPreferences().getBoolean(PREF_PROPS_FOR_APPEARANCE, true);
    }

    private void updateLinks() {
        Set<TopComponent> topComponents = GraphEditorRegistry.getDefault().getOpen();
        for (TopComponent topComponent : topComponents) {
            Graph2D graph;
            GraphView graphView;
            GraphViewCookie cookie;
            if (topComponent == null || (cookie = (GraphViewCookie)topComponent.getLookup().lookup(GraphViewCookie.class)) == null || (graphView = cookie.getGraphView()) == null || !((graph = graphView.getViewGraph()) instanceof Graph2D)) continue;
            Graph2D graph2D = graph;
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)graph2D);
            Map links = GraphStoreHelper.getLinks((Graph)graph);
            for (Map.Entry entry : links.entrySet()) {
                EdgeRealizer realizer;
                LinkID id = (LinkID)entry.getKey();
                MaltegoLink link = (MaltegoLink)entry.getValue();
                Edge edge = wrapper.edge(id);
                if (edge == null || !((realizer = graph2D.getRealizer(edge)) instanceof LinkEdgeRealizer)) continue;
                LinkEdgeRealizer linkEdgeRealizer = (LinkEdgeRealizer)realizer;
                linkEdgeRealizer.update(link);
            }
            PlaceLabelsAction action = (PlaceLabelsAction)SystemAction.get(PlaceLabelsAction.class);
            action.actionPerformed(null);
        }
    }
}

