/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public abstract class CookieAction<T>
extends SystemAction
implements PropertyChangeListener {
    private final CookieLookupListener _cookieLookupListener = new CookieLookupListener();
    private TopComponent.Registry _topComponents;
    private Class<T> _cookieClass;
    private Lookup.Result<T> _lookupResult;

    public CookieAction(Class<T> cookieClass) {
        this(TopComponent.getRegistry(), cookieClass);
    }

    public CookieAction(TopComponent.Registry topComponents, Class<T> cookieClass) {
        this._topComponents = topComponents;
        this._cookieClass = cookieClass;
        this._topComponents.addPropertyChangeListener((PropertyChangeListener)this);
        this.checkEnabled(this._topComponents.getActivated());
    }

    protected abstract void performAction(T var1);

    private void checkEnabled(TopComponent active) {
        this.setEnabled(this.getCookie(active) != null);
    }

    private T getCookie(TopComponent active) {
        if (active != null) {
            return (T)active.getLookup().lookup(this._cookieClass);
        }
        return null;
    }

    protected T getCookie() {
        return this.getCookie(this._topComponents.getActivated());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("activated".equals(evt.getPropertyName())) {
            TopComponent newTC = (TopComponent)evt.getNewValue();
            if (this._lookupResult != null) {
                this._lookupResult.removeLookupListener((LookupListener)this._cookieLookupListener);
                this._lookupResult = null;
            }
            if (newTC != null) {
                this._lookupResult = newTC.getLookup().lookupResult(this._cookieClass);
                this._lookupResult.addLookupListener((LookupListener)this._cookieLookupListener);
            }
            this.checkEnabled(newTC);
        }
    }

    public void actionPerformed(ActionEvent e) {
        TopComponent active = this._topComponents.getActivated();
        T cookie = this.getCookie(active);
        if (cookie != null) {
            this.performAction(cookie);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private class CookieLookupListener
    implements LookupListener {
        private CookieLookupListener() {
        }

        public void resultChanged(LookupEvent ev) {
            CookieAction.this.checkEnabled(CookieAction.this._topComponents.getActivated());
        }
    }
}

