/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.CookieAction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import java.util.Set;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import y.base.Graph;
import y.view.Graph2D;

public class ClearAllAction
extends CookieAction<GraphViewCookie> {
    public ClearAllAction() {
        super(GraphViewCookie.class);
    }

    public String getName() {
        return "Clear Graph";
    }

    @Override
    protected void performAction(GraphViewCookie cookie) {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)"Clear entire graph contents?", "Clear contents?");
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.YES_OPTION && cookie != null) {
            GraphView graphView = cookie.getGraphView();
            Graph2D viewGraph = graphView.getViewGraph();
            Set entityIDs = GraphStoreHelper.getEntityIDs((Graph)viewGraph);
            GraphID graphID = GraphViewManager.getDefault().getGraphID(viewGraph);
            SimilarStrings description = new SimilarStrings("%sClear all", "", "Revert ");
            GraphTransactionHelper.doDeleteEntities(description, graphID, entityIDs);
        }
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/ClearAll.png";
    }
}

