/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.ui.graph.BookmarkUtils;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.openide.windows.TopComponent;
import y.view.Graph2D;

public class BookmarkAction
extends AbstractAction {
    @Override
    public void actionPerformed(final ActionEvent e) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int bookmark = Integer.MAX_VALUE;
                String actionCommand = e.getActionCommand();
                if (actionCommand != null) {
                    Graph2D graph;
                    try {
                        actionCommand = actionCommand.replaceAll("[^\\d]", "");
                        bookmark = Integer.parseInt(actionCommand);
                        --bookmark;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (bookmark >= -1 && bookmark < BookmarkFactory.getDefault().getBookmarkCount() && (graph = BookmarkAction.this.getTopGraph()) != null) {
                        GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph);
                        if (!BookmarkAction.doesTextComponentHaveFocus()) {
                            BookmarkUtils.setBookmarkForSelection(graphID, bookmark);
                        }
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static boolean doesTextComponentHaveFocus() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focusOwner != null && focusOwner instanceof JTextComponent;
    }

    private Graph2D getTopGraph() {
        Graph2D graph;
        GraphViewCookie cookie;
        TopComponent tc = GraphEditorRegistry.getDefault().getTopmost();
        Graph2D graph2D = null;
        if (tc != null && (cookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class)) != null && (graph = cookie.getGraphView().getViewGraph()) instanceof Graph2D) {
            graph2D = graph;
        }
        return graph2D;
    }
}

