/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.actions.TopGraphSelectionContextAction;
import java.util.HashSet;
import y.algo.ShortestPaths;
import y.base.DataMap;
import y.base.DataProvider;
import y.base.EdgeList;
import y.base.Graph;
import y.base.Node;
import y.base.NodeList;
import y.base.NodeMap;
import y.util.Maps;
import y.view.Graph2D;

public class AddInbetweenAction
extends TopGraphSelectionContextAction {
    public String getName() {
        return "Add Path";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/AddInbetween.png";
    }

    @Override
    protected void actionPerformed(GraphView graphView) {
        Graph2D graph = graphView.getViewGraph();
        GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph);
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
        HashSet<EntityID> toSelect = new HashSet<EntityID>();
        graph.firePreEvent();
        Node[] nodes = new NodeList(graph.selectedNodes()).toNodeArray();
        Maps.HighPerformanceBoolMap map = new Maps.HighPerformanceBoolMap((DataMap)graph.createNodeMap(), false);
        for (int i = 0; i < nodes.length - 1; ++i) {
            Node yNode1 = nodes[i];
            map.resetAll(false);
            for (int j = i + 1; j < nodes.length; ++j) {
                Node yNode2 = nodes[j];
                map.setBool((Object)yNode2, true);
            }
            NodeList newNodes = new NodeList();
            ShortestPaths.findShortestUniformPaths((Graph)graph, (Node)yNode1, (DataProvider)map, (boolean)false, (int)1000, (EdgeList)new EdgeList(), (NodeList)newNodes);
            for (Node newNode : newNodes) {
                EntityID entityID = wrapper.entityID(newNode);
                toSelect.add(entityID);
            }
        }
        selection.addSelectedViewEntities(toSelect);
        graph.disposeNodeMap((NodeMap)map);
        graph.firePostEvent();
    }
}

