/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.DataProviders;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.GraphView;
import y.base.DataProvider;
import y.base.Graph;

public abstract class GraphViewRegistry {
    private static final String GRAPH_VIEW_KEY = "maltego.GraphView";

    public static synchronized GraphView get(GraphID graphID) {
        Graph graph = MaltegoGraphManager.getWrapper((GraphID)graphID).getGraph();
        return GraphViewRegistry.get(graph);
    }

    public static synchronized GraphView get(Graph viewGraph) {
        DataProviders.Singleton dataProvider = (DataProviders.Singleton)viewGraph.getDataProvider((Object)GRAPH_VIEW_KEY);
        GraphView graphView = dataProvider != null ? (GraphView)dataProvider.get() : null;
        return graphView;
    }

    public static synchronized void set(Graph viewGraph, GraphView graphView) {
        DataProviders.Singleton dataProvider = new DataProviders.Singleton((Object)graphView);
        viewGraph.addDataProvider((Object)GRAPH_VIEW_KEY, (DataProvider)dataProvider);
    }
}

