/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.ui.graph.GraphTypeProvider;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openide.util.Lookup;
import y.base.Graph;

public class GraphType {
    public static final String NORMAL = "normal";
    public static final String TEMPORARY = "temporary";
    private static final Collection<GraphTypeProvider> _providers = new ArrayList<GraphTypeProvider>(Lookup.getDefault().lookupAll(GraphTypeProvider.class));
    private static final Map<GraphDataObject, String> _cachedTypes = new HashMap<GraphDataObject, String>();

    public static synchronized String getType(GraphDataObject gdo) {
        String type = _cachedTypes.get(gdo);
        if (type == null) {
            type = NORMAL;
            for (GraphTypeProvider provider : _providers) {
                String providerType = provider.getType(gdo);
                if (providerType == null) continue;
                type = providerType;
                break;
            }
            _cachedTypes.put(gdo, type);
        }
        return type;
    }

    public static synchronized String getType(Graph graph) {
        GraphDataObject gdo = GraphDataUtils.getGraphDataObject(graph);
        String type = gdo != null ? GraphType.getType(gdo) : TEMPORARY;
        return type;
    }

    public static synchronized void clearCache() {
        _cachedTypes.clear();
    }

    static {
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("graphClosed".equals(evt.getPropertyName())) {
                    GraphID graphID = (GraphID)evt.getNewValue();
                    Iterator itr = _cachedTypes.keySet().iterator();
                    while (itr.hasNext()) {
                        GraphDataObject gdo = (GraphDataObject)itr.next();
                        if (!graphID.equals((Object)gdo.getGraphID())) continue;
                        itr.remove();
                        break;
                    }
                }
            }
        });
    }
}

