/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.util.Exceptions;
import y.algo.ShortestPaths;
import y.base.EdgeCursor;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeList;

public class GraphStructureUtils {
    public static Set<LinkID> getLinksBetween(GraphID graphID, Collection<EntityID> entities) {
        Set links = Collections.emptySet();
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            links = structureReader.getLinksBetween(entities);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return links;
    }

    public static Set<EntityID> getAttachedEntities(GraphID graphID, Set<LinkID> links) {
        Set<EntityID> entities = Collections.emptySet();
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            Map entitiesMap = structureReader.getEntities(links);
            entities = GraphStructureUtils.onlyEntities(entitiesMap);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return entities;
    }

    public static NodeList getShortestPaths(Graph graph, Node node1, Node node2) {
        HashSet<Node> nodes = new HashSet<Node>();
        EdgeMap edgeMap = graph.createEdgeMap();
        ShortestPaths.findShortestUniformPaths((Graph)graph, (Node)node1, (Node)node2, (boolean)false, (EdgeMap)edgeMap);
        EdgeCursor ec = graph.edges();
        while (ec.ok()) {
            if (edgeMap.getBool((Object)ec.edge())) {
                nodes.add(ec.edge().source());
                nodes.add(ec.edge().target());
            }
            ec.next();
        }
        graph.disposeEdgeMap(edgeMap);
        return new NodeList(nodes.toArray(new Node[0]));
    }

    private static Set<EntityID> onlyEntities(Map<LinkID, LinkEntityIDs> entitiesMap) {
        HashSet<EntityID> entities = new HashSet<EntityID>();
        for (Map.Entry<LinkID, LinkEntityIDs> entry : entitiesMap.entrySet()) {
            LinkEntityIDs linkEntities = entry.getValue();
            entities.add(linkEntities.getSourceID());
            entities.add(linkEntities.getTargetID());
        }
        return entities;
    }
}

