/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.SelectionProvider;
import com.paterva.maltego.ui.graph.TopGraphViewRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Utilities;
import y.view.Graph2D;

public class GraphSelectionContext
implements SelectionProvider {
    private static final Logger LOG = Logger.getLogger(GraphSelectionContext.class.getName());
    private static GraphSelectionContext _instance;
    private final ChangeSupport _changeSupport = new ChangeSupport((Object)this);
    private final PropertyChangeListener _graphSelectionListener = new GraphSelectionListener();
    private GraphView _topGraphView = null;
    private GraphID _topGraphID = null;
    private GraphSelection _topGraphSelection = null;
    private final TopGraphViewListener _topGraphListeners = new TopGraphViewListener();
    private final GraphCloseListener _graphCloseListener = new GraphCloseListener();

    public static synchronized GraphSelectionContext instance() {
        if (_instance == null) {
            _instance = new GraphSelectionContext();
        }
        return _instance;
    }

    private GraphSelectionContext() {
        TopGraphViewRegistry.getDefault().addPropertyChangeListener(this._topGraphListeners);
        GraphLifeCycleManager.getDefault().addPropertyChangeListener((PropertyChangeListener)this._graphCloseListener);
    }

    public Set<EntityID> getSelectedViewEntities() {
        Set<EntityID> selected = this._topGraphSelection == null ? null : this._topGraphSelection.getSelectedViewEntities();
        return selected != null ? selected : Collections.emptySet();
    }

    @Override
    public Set<EntityID> getSelectedModelEntities() {
        Set<EntityID> selected = this._topGraphSelection == null ? null : this._topGraphSelection.getSelectedModelEntities();
        return selected != null ? selected : Collections.emptySet();
    }

    public Set<LinkID> getSelectedViewLinks() {
        Set<LinkID> selected = this._topGraphSelection == null ? null : this._topGraphSelection.getSelectedViewLinks();
        return selected != null ? selected : Collections.emptySet();
    }

    @Override
    public Set<LinkID> getSelectedModelLinks() {
        Set<LinkID> selected = this._topGraphSelection == null ? null : this._topGraphSelection.getSelectedModelLinks();
        return selected != null ? selected : Collections.emptySet();
    }

    public GraphSelection getTopGraphSelection() {
        return this._topGraphSelection;
    }

    public GraphID getTopGraphID() {
        return this._topGraphID;
    }

    public GraphView getTopGraphView() {
        return this._topGraphView;
    }

    public Graph2D getTopViewGraph() {
        return this._topGraphView == null ? null : this._topGraphView.getViewGraph();
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeSupport.removeChangeListener(listener);
    }

    @Override
    public void addSelectionChangeListener(ChangeListener listener) {
        this.addChangeListener(listener);
    }

    @Override
    public void removeSelectionChangeListener(ChangeListener listener) {
        this.removeChangeListener(listener);
    }

    public void fireChange(boolean fireImmediately) {
        this._changeSupport.fireChange();
    }

    public void onTopGraphChanged(GraphView newGraphView) {
        if (!Utilities.compareObjects((Object)this._topGraphView, (Object)newGraphView)) {
            if (this._topGraphSelection != null) {
                this._topGraphSelection.removePropertyChangeListener(this._graphSelectionListener);
            }
            this._topGraphView = newGraphView;
            Graph2D viewGraph = this._topGraphView == null ? null : this._topGraphView.getViewGraph();
            this._topGraphID = viewGraph == null ? null : GraphViewManager.getDefault().getGraphID(viewGraph);
            GraphSelection graphSelection = this._topGraphSelection = this._topGraphID == null ? null : GraphSelection.forGraph((GraphID)this._topGraphID);
            if (this._topGraphSelection != null) {
                this._topGraphSelection.addPropertyChangeListener(this._graphSelectionListener);
            }
            LOG.fine("top graph changed");
            this.fireChange(true);
        }
    }

    private class GraphCloseListener
    implements PropertyChangeListener {
        private GraphCloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("graphClosing".equals(evt.getPropertyName()) && evt.getNewValue().equals(GraphSelectionContext.this._topGraphID)) {
                GraphSelectionContext.this.onTopGraphChanged(null);
            }
        }
    }

    private class TopGraphViewListener
    implements PropertyChangeListener {
        private TopGraphViewListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "topGraphViewChanged": {
                    GraphView newGraphView = (GraphView)evt.getNewValue();
                    GraphSelectionContext.this.onTopGraphChanged(newGraphView);
                    break;
                }
            }
        }
    }

    private class GraphSelectionListener
    implements PropertyChangeListener {
        private GraphSelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LOG.fine("selection changed");
            GraphSelectionContext.this.fireChange(false);
        }
    }
}

