/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.DefaultPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.packet.MUCUser;
import org.jivesoftware.smackx.workgroup.MetaData;
import org.jivesoftware.smackx.workgroup.QueueUser;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitation;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitationListener;
import org.jivesoftware.smackx.workgroup.agent.Agent;
import org.jivesoftware.smackx.workgroup.agent.AgentRoster;
import org.jivesoftware.smackx.workgroup.agent.Offer;
import org.jivesoftware.smackx.workgroup.agent.OfferListener;
import org.jivesoftware.smackx.workgroup.agent.QueueUsersListener;
import org.jivesoftware.smackx.workgroup.agent.RevokedOffer;
import org.jivesoftware.smackx.workgroup.agent.TranscriptManager;
import org.jivesoftware.smackx.workgroup.agent.TranscriptSearchManager;
import org.jivesoftware.smackx.workgroup.agent.WorkgroupQueue;
import org.jivesoftware.smackx.workgroup.ext.history.AgentChatHistory;
import org.jivesoftware.smackx.workgroup.ext.history.ChatMetadata;
import org.jivesoftware.smackx.workgroup.ext.macros.MacroGroup;
import org.jivesoftware.smackx.workgroup.ext.macros.Macros;
import org.jivesoftware.smackx.workgroup.ext.notes.ChatNotes;
import org.jivesoftware.smackx.workgroup.packet.DepartQueuePacket;
import org.jivesoftware.smackx.workgroup.packet.MonitorPacket;
import org.jivesoftware.smackx.workgroup.packet.OccupantsInfo;
import org.jivesoftware.smackx.workgroup.packet.OfferRequestProvider;
import org.jivesoftware.smackx.workgroup.packet.OfferRevokeProvider;
import org.jivesoftware.smackx.workgroup.packet.QueueDetails;
import org.jivesoftware.smackx.workgroup.packet.QueueOverview;
import org.jivesoftware.smackx.workgroup.packet.RoomInvitation;
import org.jivesoftware.smackx.workgroup.packet.RoomTransfer;
import org.jivesoftware.smackx.workgroup.packet.SessionID;
import org.jivesoftware.smackx.workgroup.packet.Transcript;
import org.jivesoftware.smackx.workgroup.packet.Transcripts;
import org.jivesoftware.smackx.workgroup.settings.GenericSettings;
import org.jivesoftware.smackx.workgroup.settings.SearchSettings;

public class AgentSession {
    private Connection connection;
    private String workgroupJID;
    private boolean online = false;
    private Presence.Mode presenceMode;
    private int maxChats;
    private final Map<String, List<String>> metaData;
    private Map<String, WorkgroupQueue> queues;
    private final List<OfferListener> offerListeners;
    private final List<WorkgroupInvitationListener> invitationListeners;
    private final List<QueueUsersListener> queueUsersListeners;
    private AgentRoster agentRoster = null;
    private TranscriptManager transcriptManager;
    private TranscriptSearchManager transcriptSearchManager;
    private Agent agent;
    private PacketListener packetListener;

    public AgentSession(String workgroupJID, Connection connection) {
        if (!connection.isAuthenticated()) {
            throw new IllegalStateException("Must login to server before creating workgroup.");
        }
        this.workgroupJID = workgroupJID;
        this.connection = connection;
        this.transcriptManager = new TranscriptManager(connection);
        this.transcriptSearchManager = new TranscriptSearchManager(connection);
        this.maxChats = -1;
        this.metaData = new HashMap<String, List<String>>();
        this.queues = new HashMap<String, WorkgroupQueue>();
        this.offerListeners = new ArrayList<OfferListener>();
        this.invitationListeners = new ArrayList<WorkgroupInvitationListener>();
        this.queueUsersListeners = new ArrayList<QueueUsersListener>();
        OrFilter filter = new OrFilter();
        filter.addFilter((PacketFilter)new PacketTypeFilter(OfferRequestProvider.OfferRequestPacket.class));
        filter.addFilter((PacketFilter)new PacketTypeFilter(OfferRevokeProvider.OfferRevokePacket.class));
        filter.addFilter((PacketFilter)new PacketTypeFilter(Presence.class));
        filter.addFilter((PacketFilter)new PacketTypeFilter(Message.class));
        this.packetListener = new PacketListener(){

            public void processPacket(Packet packet) {
                try {
                    AgentSession.this.handlePacket(packet);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        connection.addPacketListener(this.packetListener, (PacketFilter)filter);
        this.agent = new Agent(connection, workgroupJID);
    }

    public void close() {
        this.connection.removePacketListener(this.packetListener);
    }

    public AgentRoster getAgentRoster() {
        if (this.agentRoster == null) {
            this.agentRoster = new AgentRoster(this.connection, this.workgroupJID);
        }
        for (int elapsed = 0; !this.agentRoster.rosterInitialized && elapsed <= 2000; elapsed += 500) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.agentRoster;
    }

    public Presence.Mode getPresenceMode() {
        return this.presenceMode;
    }

    public int getMaxChats() {
        return this.maxChats;
    }

    public boolean isOnline() {
        return this.online;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaData(String key, String val) throws XMPPException {
        Map<String, List<String>> map = this.metaData;
        synchronized (map) {
            List<String> oldVals = this.metaData.get(key);
            if (oldVals == null || !oldVals.get(0).equals(val)) {
                oldVals.set(0, val);
                this.setStatus(this.presenceMode, this.maxChats);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetaData(String key) throws XMPPException {
        Map<String, List<String>> map = this.metaData;
        synchronized (map) {
            List<String> oldVal = this.metaData.remove(key);
            if (oldVal != null) {
                this.setStatus(this.presenceMode, this.maxChats);
            }
        }
    }

    public List<String> getMetaData(String key) {
        return this.metaData.get(key);
    }

    public void setOnline(boolean online) throws XMPPException {
        if (this.online == online) {
            return;
        }
        if (online) {
            Presence presence = new Presence(Presence.Type.available);
            presence.setTo(this.workgroupJID);
            presence.addExtension((PacketExtension)new DefaultPacketExtension("agent-status", "http://jabber.org/protocol/workgroup"));
            PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), new FromContainsFilter(this.workgroupJID)}));
            this.connection.sendPacket((Packet)presence);
            presence = (Presence)collector.nextResult(5000L);
            collector.cancel();
            if (!presence.isAvailable()) {
                throw new XMPPException("No response from server on status set.");
            }
            if (presence.getError() != null) {
                throw new XMPPException(presence.getError());
            }
            this.online = online;
        } else {
            this.online = online;
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setTo(this.workgroupJID);
            presence.addExtension((PacketExtension)new DefaultPacketExtension("agent-status", "http://jabber.org/protocol/workgroup"));
            this.connection.sendPacket((Packet)presence);
        }
    }

    public void setStatus(Presence.Mode presenceMode, int maxChats) throws XMPPException {
        this.setStatus(presenceMode, maxChats, null);
    }

    public void setStatus(Presence.Mode presenceMode, int maxChats, String status) throws XMPPException {
        if (!this.online) {
            throw new IllegalStateException("Cannot set status when the agent is not online.");
        }
        if (presenceMode == null) {
            presenceMode = Presence.Mode.available;
        }
        this.presenceMode = presenceMode;
        this.maxChats = maxChats;
        Presence presence = new Presence(Presence.Type.available);
        presence.setMode(presenceMode);
        presence.setTo(this.getWorkgroupJID());
        if (status != null) {
            presence.setStatus(status);
        }
        DefaultPacketExtension agentStatus = new DefaultPacketExtension("agent-status", "http://jabber.org/protocol/workgroup");
        agentStatus.setValue("max-chats", "" + maxChats);
        presence.addExtension((PacketExtension)agentStatus);
        presence.addExtension((PacketExtension)new MetaData(this.metaData));
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), new FromContainsFilter(this.workgroupJID)}));
        this.connection.sendPacket((Packet)presence);
        presence = (Presence)collector.nextResult(5000L);
        collector.cancel();
        if (!presence.isAvailable()) {
            throw new XMPPException("No response from server on status set.");
        }
        if (presence.getError() != null) {
            throw new XMPPException(presence.getError());
        }
    }

    public void setStatus(Presence.Mode presenceMode, String status) throws XMPPException {
        if (!this.online) {
            throw new IllegalStateException("Cannot set status when the agent is not online.");
        }
        if (presenceMode == null) {
            presenceMode = Presence.Mode.available;
        }
        this.presenceMode = presenceMode;
        Presence presence = new Presence(Presence.Type.available);
        presence.setMode(presenceMode);
        presence.setTo(this.getWorkgroupJID());
        if (status != null) {
            presence.setStatus(status);
        }
        presence.addExtension((PacketExtension)new MetaData(this.metaData));
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), new FromContainsFilter(this.workgroupJID)}));
        this.connection.sendPacket((Packet)presence);
        presence = (Presence)collector.nextResult(5000L);
        collector.cancel();
        if (!presence.isAvailable()) {
            throw new XMPPException("No response from server on status set.");
        }
        if (presence.getError() != null) {
            throw new XMPPException(presence.getError());
        }
    }

    public void dequeueUser(String userID) throws XMPPException {
        DepartQueuePacket departPacket = new DepartQueuePacket(this.workgroupJID);
        this.connection.sendPacket((Packet)departPacket);
    }

    public Transcripts getTranscripts(String userID) throws XMPPException {
        return this.transcriptManager.getTranscripts(this.workgroupJID, userID);
    }

    public Transcript getTranscript(String sessionID) throws XMPPException {
        return this.transcriptManager.getTranscript(this.workgroupJID, sessionID);
    }

    public Form getTranscriptSearchForm() throws XMPPException {
        return this.transcriptSearchManager.getSearchForm(StringUtils.parseServer((String)this.workgroupJID));
    }

    public ReportedData searchTranscripts(Form completedForm) throws XMPPException {
        return this.transcriptSearchManager.submitSearch(StringUtils.parseServer((String)this.workgroupJID), completedForm);
    }

    public OccupantsInfo getOccupantsInfo(String roomID) throws XMPPException {
        OccupantsInfo request = new OccupantsInfo(roomID);
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket((Packet)request);
        OccupantsInfo response = (OccupantsInfo)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }

    public String getWorkgroupJID() {
        return this.workgroupJID;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public WorkgroupQueue getQueue(String queueName) {
        return this.queues.get(queueName);
    }

    public Iterator<WorkgroupQueue> getQueues() {
        return Collections.unmodifiableMap(new HashMap<String, WorkgroupQueue>(this.queues)).values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueUsersListener(QueueUsersListener listener) {
        List<QueueUsersListener> list = this.queueUsersListeners;
        synchronized (list) {
            if (!this.queueUsersListeners.contains(listener)) {
                this.queueUsersListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueUsersListener(QueueUsersListener listener) {
        List<QueueUsersListener> list = this.queueUsersListeners;
        synchronized (list) {
            this.queueUsersListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOfferListener(OfferListener offerListener) {
        List<OfferListener> list = this.offerListeners;
        synchronized (list) {
            if (!this.offerListeners.contains(offerListener)) {
                this.offerListeners.add(offerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOfferListener(OfferListener offerListener) {
        List<OfferListener> list = this.offerListeners;
        synchronized (list) {
            this.offerListeners.remove(offerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationListener(WorkgroupInvitationListener invitationListener) {
        List<WorkgroupInvitationListener> list = this.invitationListeners;
        synchronized (list) {
            if (!this.invitationListeners.contains(invitationListener)) {
                this.invitationListeners.add(invitationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationListener(WorkgroupInvitationListener invitationListener) {
        List<WorkgroupInvitationListener> list = this.invitationListeners;
        synchronized (list) {
            this.invitationListeners.remove(invitationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOfferRequestEvent(OfferRequestProvider.OfferRequestPacket requestPacket) {
        Offer offer = new Offer(this.connection, this, requestPacket.getUserID(), requestPacket.getUserJID(), this.getWorkgroupJID(), new Date(new Date().getTime() + (long)(requestPacket.getTimeout() * 1000)), requestPacket.getSessionID(), requestPacket.getMetaData(), requestPacket.getContent());
        List<OfferListener> list = this.offerListeners;
        synchronized (list) {
            for (OfferListener listener : this.offerListeners) {
                listener.offerReceived(offer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOfferRevokeEvent(OfferRevokeProvider.OfferRevokePacket orp) {
        RevokedOffer revokedOffer = new RevokedOffer(orp.getUserJID(), orp.getUserID(), this.getWorkgroupJID(), orp.getSessionID(), orp.getReason(), new Date());
        List<OfferListener> list = this.offerListeners;
        synchronized (list) {
            for (OfferListener listener : this.offerListeners) {
                listener.offerRevoked(revokedOffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationEvent(String groupChatJID, String sessionID, String body, String from, Map<String, List<String>> metaData) {
        WorkgroupInvitation invitation = new WorkgroupInvitation(this.connection.getUser(), groupChatJID, this.workgroupJID, sessionID, body, from, metaData);
        List<WorkgroupInvitationListener> list = this.invitationListeners;
        synchronized (list) {
            for (WorkgroupInvitationListener listener : this.invitationListeners) {
                listener.invitationReceived(invitation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueueUsersEvent(WorkgroupQueue queue, WorkgroupQueue.Status status, int averageWaitTime, Date oldestEntry, Set<QueueUser> users) {
        List<QueueUsersListener> list = this.queueUsersListeners;
        synchronized (list) {
            for (QueueUsersListener listener : this.queueUsersListeners) {
                if (status != null) {
                    listener.statusUpdated(queue, status);
                }
                if (averageWaitTime != -1) {
                    listener.averageWaitTimeUpdated(queue, averageWaitTime);
                }
                if (oldestEntry != null) {
                    listener.oldestEntryUpdated(queue, oldestEntry);
                }
                if (users == null) continue;
                listener.usersUpdated(queue, users);
            }
        }
    }

    private void handlePacket(Packet packet) {
        if (packet instanceof OfferRequestProvider.OfferRequestPacket) {
            IQ reply = new IQ(){

                public String getChildElementXML() {
                    return null;
                }
            };
            reply.setPacketID(packet.getPacketID());
            reply.setTo(packet.getFrom());
            reply.setType(IQ.Type.RESULT);
            this.connection.sendPacket((Packet)reply);
            this.fireOfferRequestEvent((OfferRequestProvider.OfferRequestPacket)packet);
        } else if (packet instanceof Presence) {
            QueueOverview queueOverview;
            Presence presence = (Presence)packet;
            String queueName = StringUtils.parseResource((String)presence.getFrom());
            WorkgroupQueue queue = this.queues.get(queueName);
            if (queue == null) {
                queue = new WorkgroupQueue(queueName);
                this.queues.put(queueName, queue);
            }
            if ((queueOverview = (QueueOverview)presence.getExtension(QueueOverview.ELEMENT_NAME, QueueOverview.NAMESPACE)) != null) {
                if (queueOverview.getStatus() == null) {
                    queue.setStatus(WorkgroupQueue.Status.CLOSED);
                } else {
                    queue.setStatus(queueOverview.getStatus());
                }
                queue.setAverageWaitTime(queueOverview.getAverageWaitTime());
                queue.setOldestEntry(queueOverview.getOldestEntry());
                this.fireQueueUsersEvent(queue, queueOverview.getStatus(), queueOverview.getAverageWaitTime(), queueOverview.getOldestEntry(), null);
                return;
            }
            QueueDetails queueDetails = (QueueDetails)packet.getExtension("notify-queue-details", "http://jabber.org/protocol/workgroup");
            if (queueDetails != null) {
                queue.setUsers(queueDetails.getUsers());
                this.fireQueueUsersEvent(queue, null, -1, null, queueDetails.getUsers());
                return;
            }
            DefaultPacketExtension notifyAgents = (DefaultPacketExtension)presence.getExtension("notify-agents", "http://jabber.org/protocol/workgroup");
            if (notifyAgents != null) {
                int currentChats = Integer.parseInt(notifyAgents.getValue("current-chats"));
                int maxChats = Integer.parseInt(notifyAgents.getValue("max-chats"));
                queue.setCurrentChats(currentChats);
                queue.setMaxChats(maxChats);
                return;
            }
        } else if (packet instanceof Message) {
            MUCUser.Invite invite;
            Message message = (Message)packet;
            MUCUser mucUser = (MUCUser)message.getExtension("x", "http://jabber.org/protocol/muc#user");
            MUCUser.Invite invite2 = invite = mucUser != null ? mucUser.getInvite() : null;
            if (invite != null && this.workgroupJID.equals(invite.getFrom())) {
                MetaData metaDataExt;
                String sessionID = null;
                Map<String, List<String>> metaData = null;
                SessionID sessionIDExt = (SessionID)message.getExtension("session", "http://jivesoftware.com/protocol/workgroup");
                if (sessionIDExt != null) {
                    sessionID = sessionIDExt.getSessionID();
                }
                if ((metaDataExt = (MetaData)message.getExtension("metadata", "http://jivesoftware.com/protocol/workgroup")) != null) {
                    metaData = metaDataExt.getMetaData();
                }
                this.fireInvitationEvent(message.getFrom(), sessionID, message.getBody(), message.getFrom(), metaData);
            }
        } else if (packet instanceof OfferRevokeProvider.OfferRevokePacket) {
            IQ reply = new IQ(){

                public String getChildElementXML() {
                    return null;
                }
            };
            reply.setPacketID(packet.getPacketID());
            reply.setType(IQ.Type.RESULT);
            this.connection.sendPacket((Packet)reply);
            this.fireOfferRevokeEvent((OfferRevokeProvider.OfferRevokePacket)packet);
        }
    }

    public void setNote(String sessionID, String note) throws XMPPException {
        note = ChatNotes.replace(note, "\n", "\\n");
        note = StringUtils.escapeForXML((String)note);
        ChatNotes notes = new ChatNotes();
        notes.setType(IQ.Type.SET);
        notes.setTo(this.workgroupJID);
        notes.setSessionID(sessionID);
        notes.setNotes(note);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(notes.getPacketID()));
        this.connection.sendPacket((Packet)notes);
        IQ response = (IQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
    }

    public ChatNotes getNote(String sessionID) throws XMPPException {
        ChatNotes request = new ChatNotes();
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        request.setSessionID(sessionID);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket((Packet)request);
        ChatNotes response = (ChatNotes)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }

    public AgentChatHistory getAgentHistory(String jid, int maxSessions, Date startDate) throws XMPPException {
        AgentChatHistory request = startDate != null ? new AgentChatHistory(jid, maxSessions, startDate) : new AgentChatHistory(jid, maxSessions);
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket((Packet)request);
        AgentChatHistory response = (AgentChatHistory)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }

    public SearchSettings getSearchSettings() throws XMPPException {
        SearchSettings request = new SearchSettings();
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket((Packet)request);
        SearchSettings response = (SearchSettings)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }

    public MacroGroup getMacros(boolean global) throws XMPPException {
        Macros request = new Macros();
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        request.setPersonal(!global);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket((Packet)request);
        Macros response = (Macros)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response.getRootGroup();
    }

    public void saveMacros(MacroGroup group) throws XMPPException {
        Macros request = new Macros();
        request.setType(IQ.Type.SET);
        request.setTo(this.workgroupJID);
        request.setPersonal(true);
        request.setPersonalMacroGroup(group);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket((Packet)request);
        IQ response = (IQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
    }

    public Map<String, List<String>> getChatMetadata(String sessionID) throws XMPPException {
        ChatMetadata request = new ChatMetadata();
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        request.setSessionID(sessionID);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket((Packet)request);
        ChatMetadata response = (ChatMetadata)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response.getMetadata();
    }

    public void sendRoomInvitation(RoomInvitation.Type type, String invitee, String sessionID, String reason) throws XMPPException {
        final RoomInvitation invitation = new RoomInvitation(type, invitee, sessionID, reason);
        IQ iq = new IQ(){

            public String getChildElementXML() {
                return invitation.toXML();
            }
        };
        iq.setType(IQ.Type.SET);
        iq.setTo(this.workgroupJID);
        iq.setFrom(this.connection.getUser());
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(iq.getPacketID()));
        this.connection.sendPacket((Packet)iq);
        IQ response = (IQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
    }

    public void sendRoomTransfer(RoomTransfer.Type type, String invitee, String sessionID, String reason) throws XMPPException {
        final RoomTransfer transfer = new RoomTransfer(type, invitee, sessionID, reason);
        IQ iq = new IQ(){

            public String getChildElementXML() {
                return transfer.toXML();
            }
        };
        iq.setType(IQ.Type.SET);
        iq.setTo(this.workgroupJID);
        iq.setFrom(this.connection.getUser());
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(iq.getPacketID()));
        this.connection.sendPacket((Packet)iq);
        IQ response = (IQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
    }

    public GenericSettings getGenericSettings(Connection con, String query) throws XMPPException {
        GenericSettings setting = new GenericSettings();
        setting.setType(IQ.Type.GET);
        setting.setTo(this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(setting.getPacketID()));
        this.connection.sendPacket((Packet)setting);
        GenericSettings response = (GenericSettings)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }

    public boolean hasMonitorPrivileges(Connection con) throws XMPPException {
        MonitorPacket request = new MonitorPacket();
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket((Packet)request);
        MonitorPacket response = (MonitorPacket)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response.isMonitor();
    }

    public void makeRoomOwner(Connection con, String sessionID) throws XMPPException {
        MonitorPacket request = new MonitorPacket();
        request.setType(IQ.Type.SET);
        request.setTo(this.workgroupJID);
        request.setSessionID(sessionID);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket((Packet)request);
        Packet response = collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
    }
}

