/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.entitycaps.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.Base32Encoder;
import org.jivesoftware.smack.util.StringEncoder;
import org.jivesoftware.smackx.entitycaps.EntityCapsManager;
import org.jivesoftware.smackx.entitycaps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.provider.DiscoverInfoProvider;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SimpleDirectoryPersistentCache
implements EntityCapsPersistentCache {
    private File cacheDir;
    private StringEncoder filenameEncoder;

    public SimpleDirectoryPersistentCache(File cacheDir) {
        this(cacheDir, (StringEncoder)Base32Encoder.getInstance());
    }

    public SimpleDirectoryPersistentCache(File cacheDir, StringEncoder filenameEncoder) {
        if (!cacheDir.exists()) {
            throw new IllegalStateException("Cache directory \"" + cacheDir + "\" does not exist");
        }
        if (!cacheDir.isDirectory()) {
            throw new IllegalStateException("Cache directory \"" + cacheDir + "\" is not a directory");
        }
        this.cacheDir = cacheDir;
        this.filenameEncoder = filenameEncoder;
    }

    @Override
    public void addDiscoverInfoByNodePersistent(String node, DiscoverInfo info) {
        String filename = this.filenameEncoder.encode(node);
        File nodeFile = new File(this.cacheDir, filename);
        try {
            if (nodeFile.createNewFile()) {
                SimpleDirectoryPersistentCache.writeInfoToFile(nodeFile, info);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void replay() throws IOException {
        File[] files;
        for (File f : files = this.cacheDir.listFiles()) {
            String node = this.filenameEncoder.decode(f.getName());
            DiscoverInfo info = SimpleDirectoryPersistentCache.restoreInfoFromFile(f);
            if (info == null) continue;
            EntityCapsManager.addDiscoverInfoByNode(node, info);
        }
    }

    @Override
    public void emptyCache() {
        File[] files;
        for (File f : files = this.cacheDir.listFiles()) {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInfoToFile(File file, DiscoverInfo info) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));
        try {
            dos.writeUTF(info.toXML());
        }
        finally {
            dos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DiscoverInfo restoreInfoFromFile(File file) throws IOException {
        DiscoverInfo iqPacket;
        String to;
        String from;
        String id;
        MXParser parser;
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        String fileContent = null;
        try {
            fileContent = dis.readUTF();
        }
        finally {
            dis.close();
        }
        if (fileContent == null) {
            return null;
        }
        StringReader reader = new StringReader(fileContent);
        try {
            parser = new MXParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)reader);
        }
        catch (XmlPullParserException xppe) {
            xppe.printStackTrace();
            return null;
        }
        DiscoverInfoProvider provider = new DiscoverInfoProvider();
        try {
            parser.next();
            id = parser.getAttributeValue("", "id");
            from = parser.getAttributeValue("", "from");
            to = parser.getAttributeValue("", "to");
            parser.next();
        }
        catch (XmlPullParserException e1) {
            return null;
        }
        try {
            iqPacket = (DiscoverInfo)provider.parseIQ((XmlPullParser)parser);
        }
        catch (Exception e) {
            return null;
        }
        iqPacket.setPacketID(id);
        iqPacket.setFrom(from);
        iqPacket.setTo(to);
        iqPacket.setType(IQ.Type.RESULT);
        return iqPacket;
    }
}

