/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview.list;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.detailview.inspect.InspectorRegistry;
import com.paterva.maltego.detailview.list.EntitySyncButton;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.treelist.parts.entity.EntityTable;
import com.paterva.maltego.ui.graph.SelectionProvider;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.view2d.OutlinePopupAdapterFactory;
import com.paterva.maltego.ui.graph.view2d.PartHoverEntityTable;
import com.paterva.maltego.ui.graph.view2d.ZoomAndFlasher;
import com.paterva.maltego.util.IconSize;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.MouseUtils;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public class EntityListDetailView
extends JPanel
implements SelectionProvider {
    private final EntityTable _table;
    private final ChangeSupport _selectionChangeSupport = new ChangeSupport((Object)this);
    private MouseAdapter _clickEditListener;
    private final Color _bg;
    private final JPanel _topPanel;
    private final JPanel _cornerPanel;
    private final JPanel _filterPanel;

    public EntityListDetailView() {
        this.setLayout(new BorderLayout());
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        this._bg = laf.getColor("detail-view-empty-bg");
        this._table = this.createEntityTable("Detail View Entities", false, "global");
        this._table.setSelectionBackground(laf.getColor("detail-view-list-selection-bg"));
        this._table.setSelectionForeground(laf.getColor("detail-view-list-selection-fg"));
        this._table.setBackground(this._bg);
        this._table.setForeground(laf.getColor("detail-view-list-fg"));
        this._table.setGridColor(laf.getColor("detail-view-list-grid-color"));
        JScrollPane scrollPane = new JScrollPane((Component)this._table);
        scrollPane.getViewport().setBackground(this._bg);
        this.add(scrollPane);
        this._cornerPanel = new JPanel(new BorderLayout());
        this._cornerPanel.setBackground(this._bg);
        this._cornerPanel.setMaximumSize(new Dimension(100, 30));
        this._cornerPanel.setBorder(new EmptyBorder(1, 0, 1, 0));
        this._cornerPanel.add(this.createCornerComponent());
        this._topPanel = new JPanel(new BorderLayout());
        this._topPanel.setBackground(this._bg);
        this._topPanel.add((Component)this._cornerPanel, "West");
        this._topPanel.add(Box.createHorizontalGlue());
        this._filterPanel = this._table.getFilter();
        this._filterPanel.setBackground(this._bg);
        this._filterPanel.setBorder(new EmptyBorder(1, 1, 1, 0));
        this._topPanel.add(this._filterPanel);
        this.add((Component)this._topPanel, "North");
        OutlinePopupAdapterFactory factory = OutlinePopupAdapterFactory.getDefault();
        if (factory != null) {
            MouseUtils.PopupMouseAdapter popupAdapter = factory.create(this._table);
            this._table.addMouseListener((MouseListener)popupAdapter);
        }
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    EntityListDetailView.this._selectionChangeSupport.fireChange();
                }
            }
        });
    }

    protected EntityTable getTable() {
        return this._table;
    }

    protected JPanel getTopPanel() {
        return this._topPanel;
    }

    protected JPanel getCornerPanel() {
        return this._cornerPanel;
    }

    protected JPanel getFilterPanel() {
        return this._filterPanel;
    }

    protected JComponent createCornerComponent() {
        EntitySyncButton entitySyncButton = new EntitySyncButton(this._table);
        entitySyncButton.setBorderPainted(false);
        int iconSize = IconSize.TINY.getSize();
        entitySyncButton.setPreferredSize(new Dimension(4 + iconSize, 8 + iconSize));
        return entitySyncButton;
    }

    protected EntityTable createEntityTable(String name, boolean small, String ... hoverContextIDs) {
        return new PartHoverEntityTable(name, small, hoverContextIDs);
    }

    protected MouseAdapter createClickEditListener() {
        return new ClickEditListener();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._table.addListeners();
        this._clickEditListener = this.createClickEditListener();
        this._table.addMouseListener((MouseListener)this._clickEditListener);
    }

    @Override
    public void removeNotify() {
        this._table.removeMouseListener((MouseListener)this._clickEditListener);
        this._clickEditListener = null;
        this._table.removeListeners();
        super.removeNotify();
    }

    public void setEntities(GraphID topGraphID, Set<EntityID> selectedModelEntities) {
        this._table.getTreelistModel().setModelParts(topGraphID, selectedModelEntities);
        this._selectionChangeSupport.fireChange();
    }

    private int getBookmark(int modelRow) {
        GraphID graphID = this._table.getTreelistModel().getGraphID();
        EntityID entityID = (EntityID)this._table.getTreeModel().getPartID(modelRow);
        MaltegoEntity entity = GraphStoreHelper.getEntity((GraphID)graphID, (EntityID)entityID);
        return entity.getBookmark();
    }

    protected void changeBookmark(int row, int[] affectedRows) {
        int bookmark = this.getBookmark(row);
        Set entityIDs = this._table.getTreeModel().getPartIDs(affectedRows);
        GraphID graphID = this._table.getTreelistModel().getGraphID();
        Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)graphID, (Collection)entityIDs);
        int nextBookmark = BookmarkFactory.getDefault().getNext(bookmark);
        GraphTransactionHelper.doChangeBookmark((GraphID)graphID, (Collection)entities, (int)nextBookmark);
    }

    private boolean getPinned(int modelRow) {
        boolean pinned = false;
        try {
            GraphID graphID = this._table.getTreelistModel().getGraphID();
            EntityID entityID = (EntityID)this._table.getTreeModel().getPartID(modelRow);
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            pinned = structureReader.getPinned(entityID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return pinned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changePin(int row, int[] affectedRows) {
        GraphStore graphStore = null;
        try {
            boolean pinned = this.getPinned(row);
            Set entityIDs = this._table.getTreeModel().getPartIDs(affectedRows);
            GraphID graphID = this._table.getTreelistModel().getGraphID();
            graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.beginUpdate();
            GraphTransactionHelper.doChangePinned((GraphID)graphID, (Collection)entityIDs, (!pinned ? 1 : 0) != 0);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate((Object)true);
            }
        }
    }

    protected int[] getAffectedModelRows(int viewRow) {
        ListSelectionModel selectionModel = this._table.getSelectionModel();
        int[] affectedRows = selectionModel.isSelectedIndex(viewRow) ? this._table.getSelectedRows() : new int[]{viewRow};
        for (int i = 0; i < affectedRows.length; ++i) {
            affectedRows[i] = this._table.convertRowIndexToModel(affectedRows[i]);
        }
        return affectedRows;
    }

    private void zoomToViewNode(int modelRow) {
        try {
            GraphID graphID = this._table.getTreelistModel().getGraphID();
            EntityID entityID = (EntityID)this._table.getTreeModel().getPartID(modelRow);
            ZoomAndFlasher.instance().zoomAndFlash(graphID, entityID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void inspect(int modelRow) {
        GraphID graphID = this._table.getTreelistModel().getGraphID();
        EntityID entityID = (EntityID)this._table.getTreeModel().getPartID(modelRow);
        InspectorRegistry.forGraph(graphID).inspect(entityID);
    }

    public Set<EntityID> getSelectedModelEntities() {
        return this._table.getTreeModel().getSelectedPartIDs();
    }

    public Set<LinkID> getSelectedModelLinks() {
        return Collections.EMPTY_SET;
    }

    public void addSelectionChangeListener(ChangeListener listener) {
        this._selectionChangeSupport.addChangeListener(listener);
    }

    public void removeSelectionChangeListener(ChangeListener listener) {
        this._selectionChangeSupport.removeChangeListener(listener);
    }

    private class ClickEditListener
    extends MouseAdapter {
        private ClickEditListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point point = e.getPoint();
            int viewRow = EntityListDetailView.this._table.rowAtPoint(point);
            int viewColumn = EntityListDetailView.this._table.columnAtPoint(point);
            int modelColumn = EntityListDetailView.this._table.convertColumnIndexToModel(viewColumn);
            if (modelColumn == 0 && e.getClickCount() == 2) {
                int modelRow = EntityListDetailView.this._table.convertRowIndexToModel(viewRow);
                EntityListDetailView.this.zoomToViewNode(modelRow);
            } else if (modelColumn > 0) {
                int modelRow = EntityListDetailView.this._table.convertRowIndexToModel(viewRow);
                switch (--modelColumn) {
                    case 3: {
                        int[] affectedRows = EntityListDetailView.this.getAffectedModelRows(viewRow);
                        EntityListDetailView.this.changeBookmark(modelRow, affectedRows);
                        break;
                    }
                    case 4: {
                        int[] affectedRows = EntityListDetailView.this.getAffectedModelRows(viewRow);
                        EntityListDetailView.this.changePin(modelRow, affectedRows);
                        break;
                    }
                    case 5: {
                        EntityListDetailView.this.zoomToViewNode(modelRow);
                        break;
                    }
                    case 1: {
                        EntityListDetailView.this.inspect(modelRow);
                        break;
                    }
                }
            }
        }
    }
}

