/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.collab.graph.GraphChatRoom;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import com.paterva.maltego.util.output.MessageLinkAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.openide.util.actions.SystemAction;
import y.view.Graph2D;

public class SelectEntitiesListener
extends MessageLinkAdapter {
    private final GraphChatRoom _graphChatRoom;
    private final Collection<EntityID> _entityIDs;

    public SelectEntitiesListener(GraphChatRoom graphChatRoom, Collection<EntityID> entityIDs) {
        this._graphChatRoom = graphChatRoom;
        this._entityIDs = entityIDs;
    }

    public Collection<EntityID> getEntityIDs() {
        return Collections.unmodifiableCollection(this._entityIDs);
    }

    public void linkAction() {
        GraphID graphID = this._graphChatRoom.getGraphID();
        Graph2D viewGraph = GraphViewManager.getDefault().getViewGraph(graphID);
        if (viewGraph != null) {
            HashSet existingEntityIDs = new HashSet(GraphStoreHelper.getEntityIDs((GraphID)graphID));
            existingEntityIDs.retainAll(this._entityIDs);
            GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
            selection.setSelectedModelEntities(existingEntityIDs);
            ((ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class)).zoomToSelection(viewGraph);
        }
    }

    public String getTranslatorID() {
        return "esel";
    }
}

