/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.session.PayloadHelper;
import com.paterva.maltego.util.NormalException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

abstract class SignalMessage {
    private static String SIGNAL_ELEMENT = "signal";
    private static String ATTR_TYPE = "type";
    private static String ATTR_ACTION = "action";
    private final String _action;
    private final Type _type;
    private String _body;
    private static final Map<String, Class<? extends SignalMessage>> _registry = new HashMap<String, Class<? extends SignalMessage>>();

    public static void register(String action, Class<? extends SignalMessage> clazz) {
        if (_registry.containsKey(action)) {
            throw new IllegalArgumentException(String.format("Action '%s' is already registered", action));
        }
        _registry.put(action, clazz);
    }

    public String getAction() {
        return this._action;
    }

    public Type getType() {
        return this._type;
    }

    protected SignalMessage(Type type, String action) {
        this(type, action, "");
    }

    protected SignalMessage(Type type, String action, String body) {
        this._type = type;
        this._action = action;
        this._body = body;
    }

    public static SignalMessage createErrorResponse(String action, int code, String message) {
        return new Error(action, code, message);
    }

    protected Map<String, String> getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ATTR_TYPE, this.getType().toString());
        map.put(ATTR_ACTION, this.getAction().toString());
        return map;
    }

    public String toXml() throws CollaborationException {
        return PayloadHelper.createPayload(SIGNAL_ELEMENT, this.getAttributes(), this.getBody(), false);
    }

    protected String getBody() throws CollaborationException {
        return this._body;
    }

    public static SignalMessage parse(String xml) throws CollaborationException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        String body = PayloadHelper.getBody(SIGNAL_ELEMENT, xml, attributes, false);
        String action = (String)attributes.get(ATTR_ACTION);
        Type type = Type.parse((String)attributes.get(ATTR_TYPE));
        switch (type) {
            case Error: {
                return new Error(action, body);
            }
            case Request: 
            case Response: {
                Class<? extends SignalMessage> clazz = _registry.get(action);
                if (clazz == null) {
                    return null;
                }
                return SignalMessage.parse(clazz, type, action, attributes, body);
            }
        }
        throw new CollaborationException("Unknown signal type: " + (Object)((Object)type), false);
    }

    private static SignalMessage parse(Class<? extends SignalMessage> clazz, Type type, String action, Map<String, String> attributes, String body) {
        try {
            Method method = clazz.getDeclaredMethod("parse", Type.class, String.class, String.class);
            method.setAccessible(true);
            if (method != null) {
                return (SignalMessage)method.invoke(null, new Object[]{type, action, body});
            }
        }
        catch (NoSuchMethodException ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
        return null;
    }

    public static class Error
    extends SignalMessage {
        private int _code = -1;
        private String _message;

        private Error(String action, int code, String message) {
            super(Type.Error, action);
            this._code = code;
            this._message = message;
        }

        private Error(String action, String body) throws CollaborationException {
            super(Type.Error, action, body);
            HashMap<String, String> map = new HashMap<String, String>();
            this._message = PayloadHelper.getBody("error", body, map, true);
            String scode = (String)map.get("code");
            if (scode == null) {
                throw new CollaborationException("Error code is required", true);
            }
            this._code = Integer.parseInt(scode);
        }

        @Override
        protected String getBody() throws CollaborationException {
            if (this._code >= 0) {
                return PayloadHelper.createPayload("error", Collections.singletonMap("code", Integer.toString(this._code)), this._message, true);
            }
            return super.getBody();
        }

        public int getCode() {
            return this._code;
        }

        public String getMessage() {
            return this._message;
        }
    }

    public static enum Type {
        Request("request"),
        Response("response"),
        Error("error");

        private String _name;

        private Type(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public static Type parse(String name) throws CollaborationException {
            if ("request".equals(name)) {
                return Request;
            }
            if ("response".equals(name)) {
                return Response;
            }
            if ("error".equals(name)) {
                return Error;
            }
            throw new CollaborationException("Unknown type: " + name, false);
        }
    }
}

