/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.reporting.pdf;

import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontSelector;
import com.lowagie.text.pdf.PdfPCell;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.util.List;
import java.util.Set;

public abstract class iTextStyle {
    public Set<String> availableFonts;
    public List<BaseFont> baseFontList;

    public abstract Color getBackColor(boolean var1);

    public abstract String getFontType(boolean var1);

    public abstract float getFontSize(boolean var1);

    public abstract int getFontStyle(boolean var1);

    public abstract Color getFontColor(boolean var1);

    public abstract int getPadding(boolean var1);

    public abstract int getBorder(boolean var1);

    public FontSelector getFontSelector(boolean header) {
        FontSelector fs = new FontSelector();
        Font preferredFont = FontFactory.getFont(this.getFontType(header), this.getFontSize(header), this.getFontStyle(header), this.getFontColor(header));
        fs.addFont(preferredFont);
        for (BaseFont baseFont : this.baseFontList) {
            Font font = new Font(baseFont, this.getFontSize(header), this.getFontStyle(header), this.getFontColor(header));
            String familyname = font.getFamilyname();
            if (StringUtilities.isNullOrEmpty((String)familyname)) continue;
            fs.addFont(font);
        }
        return fs;
    }

    public FontSelector getFontSelector(String fontType, float fontSize, int fontStyle, Color color) {
        FontSelector fs = new FontSelector();
        Font preferredFont = FontFactory.getFont(fontType, fontSize, fontStyle, color);
        fs.addFont(preferredFont);
        for (BaseFont baseFont : this.baseFontList) {
            Font font = new Font(baseFont, fontSize, fontStyle, color);
            String familyname = font.getFamilyname();
            if (StringUtilities.isNullOrEmpty((String)familyname)) continue;
            fs.addFont(font);
        }
        return fs;
    }

    public PdfPCell getCell(Object item, boolean header) {
        PdfPCell cell;
        if (item instanceof Image) {
            cell = new PdfPCell((Image)item);
        } else if (item instanceof Paragraph) {
            cell = new PdfPCell((Paragraph)item);
        } else if (item instanceof Element) {
            cell = new PdfPCell();
            cell.addElement((Element)item);
        } else {
            FontSelector fs = this.getFontSelector(header);
            cell = new PdfPCell(new Paragraph(fs.process(item.toString())));
        }
        cell.setBackgroundColor(this.getBackColor(header));
        cell.setPaddingBottom(this.getPadding(header));
        cell.setBorder(this.getBorder(header));
        return cell;
    }
}

