/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.reporting.pdf;

import com.paterva.maltego.reporting.pdf.PdfReportGenerator;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.ui.graph.util.GraphUtils;
import com.paterva.maltego.util.ui.components.ImageBoundsRadioButtons;
import com.paterva.maltego.util.ui.filechooser.FileChooserUtil;
import com.paterva.maltego.util.ui.filechooser.SaveValidationFileChooser;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import y.view.Graph2DView;

public class ReportAction
extends TopGraphAction {
    private static final String PREF_SAVED_DIR = "exportAsPdfDir";
    private static final String PREF_SAVED_IMAGE_BOUNDS_GRAPH = "exportAsPdfImageBoundsGraph";
    private static final String PREF_SAVED_USER_PROPS = "exportAsPdfUserProps";

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return "Generate Report";
    }

    protected String iconResource() {
        return "com/paterva/maltego/reporting/resources/ReportExport.png";
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionPerformed(TopComponent tc) {
        String pdfExt = "pdf";
        SaveValidationFileChooser fileChooser = new SaveValidationFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        Preferences prefs = NbPreferences.forModule(ReportAction.class);
        FileChooserUtil.setDirectoryAndFile((Preferences)prefs, (String)PREF_SAVED_DIR, (JFileChooser)fileChooser, (String)GraphUtils.getTopGraphName((TopComponent)tc, (String)"GraphPDF"));
        fileChooser.addChoosableFileFilter((FileFilter)new FileNameExtensionFilter("PDF document (*.pdf)", "pdf"));
        boolean initWholeGraph = prefs.getBoolean(PREF_SAVED_IMAGE_BOUNDS_GRAPH, true);
        ImageBoundsRadioButtons imageBoundsRadios = new ImageBoundsRadioButtons(initWholeGraph);
        JCheckBox userPropCheckbox = new JCheckBox();
        userPropCheckbox.setEnabled(true);
        boolean initUserProps = prefs.getBoolean(PREF_SAVED_USER_PROPS, false);
        userPropCheckbox.setSelected(initUserProps);
        FileChooserUtil.addAdditionalFieldsToChooser((JFileChooser)fileChooser, (String[])new String[]{"Image bounds:", "Include User Properties:"}, (JComponent[])new JComponent[]{imageBoundsRadios, userPropCheckbox});
        int result = fileChooser.showSaveDialog((Component)WindowManager.getDefault().getMainWindow());
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            file = FileChooserUtil.addExtenstionIfMissing((File)file, (String)"pdf");
            JComponent viewControl = this.getTopGraphViewCookie().getGraphView().getViewControl();
            if (viewControl instanceof Graph2DView) {
                TopComponent activeTC = TopComponent.getRegistry().getActivated();
                Cursor oldCursor = activeTC.getCursor();
                try {
                    activeTC.setCursor(Cursor.getPredefinedCursor(3));
                    boolean wholeGraph = imageBoundsRadios.isWholeGraph();
                    boolean userProps = userPropCheckbox.isSelected();
                    PdfReportGenerator report = new PdfReportGenerator(false, false);
                    if (report.generateReport(file, (Graph2DView)viewControl, userProps, wholeGraph)) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"Report generated successfully.", 1);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                    String currentDirectory = fileChooser.getCurrentDirectory().getAbsolutePath();
                    prefs.put(PREF_SAVED_DIR, currentDirectory);
                    prefs.putBoolean(PREF_SAVED_IMAGE_BOUNDS_GRAPH, wholeGraph);
                    prefs.putBoolean(PREF_SAVED_USER_PROPS, userProps);
                }
                finally {
                    activeTC.setCursor(oldCursor);
                }
            }
        }
    }
}

