/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard.free;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.registry.Level1EntityRegistry;
import com.paterva.maltego.entity.registry.Level2EntityRegistry;
import com.paterva.maltego.licensing.EulaAcceptHandler;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.LicensingException;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.serialize.J;
import com.paterva.maltego.licensing.ui.wizard.LicenseWizard;
import com.paterva.maltego.licensing.ui.wizard.free.CaseFileEntitiesFailurePanel;
import com.paterva.maltego.licensing.ui.wizard.free.CaseFileEntitiesSuccessPanel;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;

public class CaseFileEntitiesController
extends PassFailProgressController<Void, CaseFileEntitiesSuccessPanel, CaseFileEntitiesFailurePanel> {
    public CaseFileEntitiesController() {
        this.setName("Install Entities");
        this.setDescription("Installing additional entities that may be useful when manually creating graphs.");
        this.setImage(LicenseWizard.getDescriptionImage());
    }

    protected Void doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws LicensingException {
        boolean revertModified = true;
        EntityRegistry currentRegistry = EntityRegistry.getDefault();
        handle.setDisplayName("Adding entities...");
        this.copyEntities(currentRegistry, (EntityRegistry)new Level1EntityRegistry(), revertModified);
        this.copyEntities(currentRegistry, (EntityRegistry)new Level2EntityRegistry(), revertModified);
        return null;
    }

    protected void storeSettings(WizardDescriptor settings) {
    }

    protected CaseFileEntitiesSuccessPanel createPassComponent() {
        return new CaseFileEntitiesSuccessPanel();
    }

    protected CaseFileEntitiesFailurePanel createFailComponent() {
        return new CaseFileEntitiesFailurePanel();
    }

    protected void pass(WizardDescriptor descriptor, CaseFileEntitiesSuccessPanel component, Void license) {
        LicenseManager licMan = LicenseManager.A();
        A licenseMode = licMan.A(false);
        licMan.C(true);
        licMan.B(false);
        descriptor.putProperty("licensing.online", (Object)false);
        licMan.A(licenseMode);
        J eula = (J)descriptor.getProperty("licensing.eula");
        EulaAcceptHandler.eulaAccepted((J)eula);
    }

    protected void fail(CaseFileEntitiesFailurePanel component, Exception e) {
    }

    private void copyEntities(EntityRegistry toRegistry, EntityRegistry fromRegistry, boolean revertModified) {
        for (MaltegoEntitySpec maltegoEntitySpec : fromRegistry.getAll()) {
            boolean exist = toRegistry.contains(maltegoEntitySpec.getTypeName());
            if (!exist) {
                toRegistry.put((TypeSpec)maltegoEntitySpec);
                continue;
            }
            if (!revertModified) continue;
            toRegistry.remove(maltegoEntitySpec.getTypeName());
            toRegistry.put((TypeSpec)maltegoEntitySpec);
        }
    }
}

