/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard;

import com.paterva.maltego.licensing.ui.wizard.DiscoveryControllerProvider;
import com.paterva.maltego.licensing.ui.wizard.LicenseAgreementController;
import com.paterva.maltego.licensing.ui.wizard.LicenseModeController;
import com.paterva.maltego.licensing.ui.wizard.free.CaseFileEntitiesController;
import com.paterva.maltego.licensing.ui.wizard.free.LoginRequestController;
import com.paterva.maltego.licensing.ui.wizard.free.LoginResponseController;
import com.paterva.maltego.licensing.ui.wizard.licensed.LicenseActivationController;
import com.paterva.maltego.licensing.ui.wizard.licensed.LicenseKeyController;
import com.paterva.maltego.licensing.ui.wizard.licensed.RequestLicenseController;
import com.paterva.maltego.licensing.ui.wizard.offline.OfflineLicenseKeyController;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;

public class LicenseWizardIterator<Data>
implements WizardDescriptor.Iterator<Data> {
    private WizardDescriptor wd;
    private WizardDescriptor.Panel panelLicenseMode;
    private WizardDescriptor.Panel panelLicenseAgreement;
    private WizardDescriptor.Panel panelLicenseKey;
    private WizardDescriptor.Panel panelRequestLicense;
    private WizardDescriptor.Panel panelLicenseActivation;
    private WizardDescriptor.Panel panelOfflineActivation;
    private WizardDescriptor.Panel panelCaseFileEntities;
    private WizardDescriptor.Panel panelLoginRequest;
    private WizardDescriptor.Panel panelLoginResponse;
    private WizardDescriptor.Panel panelChooseSeeds;
    private WizardDescriptor.Panel panelInitialUpdate;
    private List<WizardDescriptor.Panel> panelsVisible;
    private int index = 0;

    public void initialize(WizardDescriptor wd) {
        this.wd = wd;
        this.createPanels();
    }

    public WizardDescriptor.Panel[] getPanels() {
        if (this.panelLicenseMode == null) {
            this.panelLicenseMode = new LicenseModeController();
            this.panelLicenseKey = new LicenseKeyController();
            this.panelRequestLicense = new RequestLicenseController();
            this.panelLicenseActivation = new LicenseActivationController();
            this.panelOfflineActivation = new OfflineLicenseKeyController();
            this.panelCaseFileEntities = new CaseFileEntitiesController();
            this.panelLoginRequest = new LoginRequestController();
            this.panelLoginResponse = new LoginResponseController();
            this.panelLicenseAgreement = new LicenseAgreementController();
            DiscoveryControllerProvider provider = DiscoveryControllerProvider.getDefault();
            this.panelChooseSeeds = provider.getChooseSeedsController();
            this.panelInitialUpdate = provider.getInitialUpdateController();
        }
        return new WizardDescriptor.Panel[]{this.panelLicenseMode, this.panelLicenseKey, this.panelRequestLicense, this.panelOfflineActivation, this.panelCaseFileEntities, this.panelLoginRequest, this.panelLoginResponse, this.panelLicenseAgreement, this.panelLicenseActivation, this.panelChooseSeeds, this.panelInitialUpdate};
    }

    private void createPanels() {
        WizardUtilities.updatePanels((WizardDescriptor.Panel[])this.getPanels());
        this.updateVisiblePanels();
    }

    public WizardDescriptor.Panel<Data> current() {
        return this.panelsVisible.isEmpty() ? null : this.panelsVisible.get(this.index);
    }

    public String name() {
        return "Licensing";
    }

    public boolean hasNext() {
        return this.current() == this.panelLicenseMode || this.index < this.panelsVisible.size() - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
        this.updateVisiblePanels();
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
        this.updateVisiblePanels();
    }

    private void updateVisiblePanels() {
        this.panelsVisible = new ArrayList<WizardDescriptor.Panel>();
        boolean noSelection = Boolean.TRUE.equals(this.wd.getProperty("licensing.no-selection"));
        boolean loginOnly = Boolean.TRUE.equals(this.wd.getProperty("licensing.login.only"));
        boolean offlineActivation = Boolean.TRUE.equals(this.wd.getProperty("licensing.activation.offline"));
        boolean licensed = Boolean.TRUE.equals(this.wd.getProperty("licensing.licensed"));
        boolean freeOnline = Boolean.TRUE.equals(this.wd.getProperty("licensing.online"));
        boolean installHubItem = Boolean.TRUE.equals(this.wd.getProperty("licensing.install-hub-item"));
        if (loginOnly) {
            this.panelsVisible.add(this.panelLicenseAgreement);
            this.panelsVisible.add(this.panelLoginRequest);
            this.panelsVisible.add(this.panelLoginResponse);
        } else {
            if (offlineActivation) {
                this.panelsVisible.add(this.panelLicenseKey);
                this.panelsVisible.add(this.panelOfflineActivation);
                this.panelsVisible.add(this.panelLicenseAgreement);
                this.panelsVisible.add(this.panelLicenseActivation);
            } else if (licensed) {
                if (!noSelection) {
                    this.panelsVisible.add(this.panelLicenseKey);
                    this.panelsVisible.add(this.panelRequestLicense);
                    this.panelsVisible.add(this.panelLicenseAgreement);
                    this.panelsVisible.add(this.panelLicenseActivation);
                }
            } else if (freeOnline) {
                this.panelsVisible.add(this.panelLicenseAgreement);
                this.panelsVisible.add(this.panelLoginRequest);
                this.panelsVisible.add(this.panelLoginResponse);
            } else {
                this.panelsVisible.add(this.panelLicenseAgreement);
                this.panelsVisible.add(this.panelCaseFileEntities);
            }
            if ((offlineActivation || licensed || freeOnline) && installHubItem) {
                if (!freeOnline) {
                    this.panelsVisible.add(this.panelChooseSeeds);
                }
                this.panelsVisible.add(this.panelInitialUpdate);
            }
        }
        this.updateContentPane();
    }

    private void updateContentPane() {
        String[] steps = this.getContentData();
        for (int i = 0; i < this.panelsVisible.size(); ++i) {
            WizardDescriptor.Panel panel = this.panelsVisible.get(i);
            Component c = panel.getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public String[] getContentData() {
        ArrayList<String> steps = new ArrayList<String>();
        for (int i = 0; i < this.panelsVisible.size(); ++i) {
            WizardDescriptor.Panel panel = this.panelsVisible.get(i);
            steps.add(panel.getComponent().getName());
            if (i < this.index || panel != this.panelLicenseMode) continue;
            steps.add("...");
            break;
        }
        return steps.toArray(new String[steps.size()]);
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }
}

