/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard;

import com.paterva.maltego.licensing.serialize.C;
import com.paterva.maltego.licensing.serialize.J;
import com.paterva.maltego.licensing.ui.eula.EulaDownloader;
import com.paterva.maltego.licensing.ui.eula.EulaPanelFactory;
import com.paterva.maltego.licensing.ui.wizard.LicenseAgreementPanel;
import com.paterva.maltego.licensing.ui.wizard.LicenseWizard;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.util.Optional;
import javax.swing.JPanel;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;

public class LicenseAgreementController
extends ValidatingController<LicenseAgreementPanel> {
    public LicenseAgreementController() {
        this.setName("License Agreement");
        this.setDescription("Please read and accept the following License Agreement.");
        this.setImage(LicenseWizard.getDescriptionImage());
    }

    protected LicenseAgreementPanel createComponent() {
        return new LicenseAgreementPanel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSettings(WizardDescriptor settings) {
        try {
            WindowUtil.showWaitCursor();
            C licenseBlob = (C)settings.getProperty("licensing.blob");
            J eula = null;
            if (licenseBlob != null) {
                eula = (J)settings.getProperty("licensing.eula");
            } else {
                EulaDownloader downloader = new EulaDownloader();
                Optional<J> eulaOpt = downloader.downloadLatest();
                if (eulaOpt.isPresent()) {
                    eula = eulaOpt.get();
                    settings.putProperty("licensing.eula", (Object)eula);
                }
            }
            JPanel eulaPanel = new EulaPanelFactory().create(eula);
            LicenseAgreementPanel component = (LicenseAgreementPanel)((Object)this.component());
            component.setAccept(false);
            component.setLicenseKey((String)settings.getProperty("licensing.key"));
            component.setAgreementComponent(eulaPanel);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    protected void storeSettings(WizardDescriptor settings) {
    }

    protected String getFirstError(LicenseAgreementPanel component) {
        boolean accept = component.isAccept();
        return accept ? null : "Please accept the License Agreement to continue";
    }
}

