/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.product;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.LicenseWizardDisplayer;
import com.paterva.maltego.licensing.ui.manager.LicenseManagerController;
import com.paterva.maltego.licensing.ui.product.ProductSelectionPanel;
import com.paterva.maltego.licensing.ui.product.ProductSelectionResult;
import com.paterva.maltego.licensing.ui.wizard.LicenseWizard;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class ProductSelectionAction
extends SystemAction {
    private static boolean showing = false;

    public static void perform() {
        ((ProductSelectionAction)SystemAction.get(ProductSelectionAction.class)).actionPerformed(null);
    }

    public static boolean isShowing() {
        return showing;
    }

    public String getName() {
        return "Product Selection";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent ev) {
        boolean done;
        if (showing || LicenseWizard.isShowing() || LicenseManagerController.isShowing()) {
            return;
        }
        do {
            done = true;
            JButton exitOption = new JButton("Exit");
            LicenseManager licMan = LicenseManager.A();
            A licenseMode = licMan.A(false);
            ChangeListener listener = ignored -> exitOption.setText(LicenseManager.A().A(false).D() ? "Exit" : "Close");
            listener.stateChanged(null);
            LicenseManager.A().A(listener);
            try {
                showing = true;
                ProductSelectionPanel panel = new ProductSelectionPanel(exitOption);
                DialogDescriptor descriptor = new DialogDescriptor((Object)panel, this.getName());
                descriptor.setOptions(new Object[]{exitOption});
                DialogDisplayer displayer = DialogDisplayer.getDefault();
                displayer.notify((NotifyDescriptor)descriptor);
                ProductSelectionResult result = panel.getResult();
                if (result == null) {
                    if (!LicenseManager.A().A(false).D()) continue;
                    descriptor = new NotifyDescriptor.Confirmation((Object)"Are you sure you want to exit Maltego?");
                    descriptor.setTitle("Exit");
                    descriptor.setOptions(new Object[]{exitOption, "Cancel"});
                    if (exitOption.equals(displayer.notify((NotifyDescriptor)descriptor))) {
                        LifecycleManager.getDefault().exit();
                        continue;
                    }
                    done = false;
                    continue;
                }
                LicenseWizard.setProductSelectionResult(result);
                showing = false;
                LicenseWizardDisplayer.getDefault().run();
            }
            finally {
                showing = false;
                LicenseManager.A().B(listener);
            }
        } while (!done);
    }
}

