/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.manager;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.manager.FreePanel;
import com.paterva.maltego.licensing.ui.manager.LicensedPanel;
import com.paterva.maltego.licensing.ui.manager.UnknownPanel;
import com.paterva.maltego.licensing.ui.monitor.B;
import com.paterva.maltego.licensing.ui.monitor.C;
import com.paterva.maltego.util.SlownessDetector;
import com.paterva.maltego.util.ui.BusySpinnerPanel;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

public class LicenseManagerPanel
extends JPanel {
    private final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final JButton closeButton;
    private ChangeListener licenseListener;
    private C pollListener;
    private JPanel centerPanel;
    private static final String REFRESH_BUTTON = "refreshButton";
    private static final String REFRESH_SPINNER = "refreshSpinner";
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel refreshPanelContainer = new JPanel(new FlowLayout());
    private final JPanel refreshPanel = new JPanel(this.cardLayout);

    public LicenseManagerPanel(JButton closeButton) {
        this.closeButton = closeButton;
        this.initComponents();
        this.setBackground(this.LAF.getColor("3-main-dark-color"));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        JButton refreshButton = new JButton("Refresh license info from server");
        refreshButton.addActionListener(ignored -> this.refreshClicked());
        this.refreshPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.refreshPanel.add((Component)refreshButton, REFRESH_BUTTON);
        this.refreshPanelContainer.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.refreshPanelContainer.add(this.refreshPanel);
        BusySpinnerPanel spinner = new BusySpinnerPanel(15);
        spinner.setPreferredSize(refreshButton.getPreferredSize());
        spinner.setBackground(this.refreshPanelContainer.getBackground());
        this.refreshPanel.add((Component)spinner, REFRESH_SPINNER);
    }

    public boolean isChangeKey() {
        if (this.centerPanel instanceof LicensedPanel) {
            LicensedPanel licensedPanel = (LicensedPanel)this.centerPanel;
            return licensedPanel.isChangeKey();
        }
        return false;
    }

    public boolean isLogIn() {
        if (this.centerPanel instanceof FreePanel) {
            FreePanel freePanel = (FreePanel)this.centerPanel;
            return freePanel.isLogIn();
        }
        return false;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.licenseListener = ignored -> this.update();
        LicenseManager.A().A(this.licenseListener);
        this.pollListener = new LicensePollListener();
        B.B(this.pollListener);
        this.update();
    }

    @Override
    public void removeNotify() {
        B.A(this.pollListener);
        this.pollListener = null;
        LicenseManager.A().B(this.licenseListener);
        this.licenseListener = null;
        super.removeNotify();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(Math.max(size.width, 600), size.height);
    }

    private void update() {
        if (B.O()) {
            this.showPolling();
        } else {
            this.showLicense(false);
        }
    }

    private void showPolling() {
        this.removeAll();
        Color orange = this.LAF.getColor("3-maltego-orange");
        JLabel titleLabel = new JLabel("Polling server for license changes");
        Font font = titleLabel.getFont();
        titleLabel.setFont(font.deriveFont(1, font.getSize2D() + 2.0f));
        titleLabel.setForeground(orange);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(ignored -> B.C());
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBackground(this.LAF.getColor("7-heading-panel-background"));
        titlePanel.add(titleLabel);
        titlePanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setOpaque(false);
        topPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        topPanel.add(titlePanel);
        JPanel bottomPanel = new JPanel(new FlowLayout());
        bottomPanel.add(cancelButton);
        BusySpinnerPanel spinner = new BusySpinnerPanel();
        spinner.setPreferredSize(new Dimension(208, 208));
        spinner.setBackground(bottomPanel.getBackground());
        this.add((Component)topPanel, "North");
        this.add((Component)spinner, "Center");
        this.add((Component)bottomPanel, "South");
        this.updateWindow();
    }

    private void showLicense(boolean checkOnline) throws IllegalStateException {
        SlownessDetector.setEnabled((boolean)false);
        if (checkOnline) {
            this.cardLayout.show(this.refreshPanel, REFRESH_SPINNER);
            this.updateWindow();
        }
        new Thread(() -> {
            try {
                A licenseMode = LicenseManager.A().A(checkOnline);
                SwingUtilities.invokeLater(() -> {
                    this.removeAll();
                    if (licenseMode.B()) {
                        this.centerPanel = new LicensedPanel(licenseMode, this.closeButton);
                        this.closeButton.setText(licenseMode.M() ? "Close" : "Exit");
                    } else {
                        this.centerPanel = licenseMode.N() ? new FreePanel(licenseMode, this.closeButton) : new UnknownPanel();
                    }
                    this.add((Component)this.centerPanel, "Center");
                    if (licenseMode.B()) {
                        this.cardLayout.show(this.refreshPanel, REFRESH_BUTTON);
                        this.add((Component)this.refreshPanelContainer, "South");
                    }
                    this.updateWindow();
                    SlownessDetector.setEnabled((boolean)true);
                });
            }
            catch (Exception ex) {
                this.cardLayout.show(this.refreshPanel, REFRESH_BUTTON);
                this.updateWindow();
                SlownessDetector.setEnabled((boolean)true);
            }
        }, "Refresh license info from server").start();
    }

    private void updateWindow() {
        SwingUtilities.invokeLater(() -> {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                window.pack();
                window.repaint();
                if (window instanceof JDialog) {
                    JDialog dialog = (JDialog)window;
                    dialog.setResizable(false);
                }
            }
        });
    }

    private void refreshClicked() {
        this.showLicense(true);
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new BorderLayout());
    }

    private class LicensePollListener
    implements C {
        @Override
        public void onPollStart() {
            LicenseManagerPanel.this.showPolling();
        }

        @Override
        public void onPollEnd() {
            LicenseManagerPanel.this.update();
        }
    }
}

