/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.eula;

import com.paterva.maltego.licensing.EulaAcceptHandler;
import com.paterva.maltego.licensing.EulaDisplayer;
import com.paterva.maltego.licensing.serialize.J;
import com.paterva.maltego.licensing.serialize.K;
import com.paterva.maltego.licensing.ui.eula.EulaPanelFactory;
import com.paterva.maltego.util.Args;
import java.awt.Dialog;
import java.net.URL;
import java.util.Optional;
import javax.swing.JPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;

public class DefaultEulaDisplayer
extends EulaDisplayer {
    public void show() {
        try {
            Optional eulaOpt = K.A();
            if (eulaOpt.isPresent()) {
                J eula = (J)eulaOpt.get();
                this.show(eula);
            } else {
                this.showInBrowser();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void show(J eula) {
        Args.notNull((Object)eula, (String)"eula");
        try {
            boolean mustAccept;
            JPanel panel = new EulaPanelFactory().create(eula);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, "End User License Agreement");
            dialogDescriptor.setNoDefaultClose(true);
            String exitOption = "Exit";
            Object[] options = new String[]{"I Accept", exitOption};
            boolean bl = mustAccept = !eula.C();
            if (mustAccept) {
                dialogDescriptor.setOptions(options);
            }
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setSize(760, 600);
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            if (mustAccept) {
                if (dialogDescriptor.getValue() == exitOption) {
                    LifecycleManager.getDefault().exit();
                } else {
                    EulaAcceptHandler.eulaAccepted((J)eula);
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void showInBrowser() {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("https://redirect.paterva.com/maltego/eula/latest"));
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

