/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui;

import com.paterva.maltego.licensing.C;
import com.paterva.maltego.licensing.EulaDisplayer;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.serialize.J;
import com.paterva.maltego.licensing.serialize.K;
import com.paterva.maltego.licensing.ui.CaseFileEntitiesManager;
import com.paterva.maltego.licensing.ui.eula.EulaDownloader;
import com.paterva.maltego.licensing.ui.laf.LicenseLookAndFeelUpdater;
import com.paterva.maltego.licensing.ui.monitor.A;
import com.paterva.maltego.licensing.ui.monitor.B;
import com.paterva.maltego.licensing.ui.monitor.D;
import com.paterva.maltego.licensing.ui.product.ProductSelectionAction;
import com.paterva.maltego.licensing.ui.wizard.FirstRunWizard;
import com.paterva.maltego.util.Version;
import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.openide.modules.ModuleInstall;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());

    public void restored() {
        com.paterva.maltego.licensing.mode.A licenseMode = LicenseManager.A().A(false);
        LicenseLookAndFeelUpdater.init();
        D.D();
        A.D();
        B.I();
        CaseFileEntitiesManager.init();
        LOG.log(Level.INFO, "License mode: {0}", licenseMode);
        Version version = Version.getCurrent();
        System.setProperty("netbeans.buildnumber", version.toString(false, false, true));
        Logger.getLogger(com.paterva.maltego.util.Installer.class.getName()).log(Level.INFO, "Version: {0}", version.toString(true, true, true));
        PropertyChangeListener frameListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ignored1) {
                final JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
                if (frame != null) {
                    WindowManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    PropertyChangeListener titleListener = new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent ignored2) {
                            frame.removePropertyChangeListener("title", this);
                            SwingUtilities.invokeLater(() -> {
                                com.paterva.maltego.licensing.mode.A licenseMode = LicenseManager.A().A(false);
                                LicenseLookAndFeelUpdater.updateTitleBar(licenseMode);
                            });
                        }
                    };
                    frame.addPropertyChangeListener("title", titleListener);
                }
            }
        };
        WindowManager.getDefault().addPropertyChangeListener(frameListener);
        if (licenseMode.D()) {
            UIRunQueue.instance().queue(5, () -> {
                ProductSelectionAction action = (ProductSelectionAction)SystemAction.get(ProductSelectionAction.class);
                action.actionPerformed(new ActionEvent((Object)this, 0, "startup"));
            });
        }
        UIRunQueue.instance().queue(150, () -> FirstRunWizard.checkShow());
        UIRunQueue.instance().queue(25000, this::checkEulaAccepted);
    }

    private void checkEulaAccepted() {
        com.paterva.maltego.licensing.mode.A licMode = LicenseManager.A().A(false);
        C capabilityValidity = licMode.I();
        if (licMode.N() || capabilityValidity != null && capabilityValidity.J().G()) {
            Thread thread = new Thread(() -> {
                EulaDownloader downloader = new EulaDownloader();
                downloader.downloadLatest().ifPresent(eula -> {
                    Optional savedEulaOpt = K.A();
                    if (!(savedEulaOpt.isPresent() && eula.B().equals(((J)savedEulaOpt.get()).B()) && ((J)savedEulaOpt.get()).C())) {
                        eula.A(false);
                        UIRunQueue.instance().queue(35000, () -> {
                            K.A((J)eula);
                            this.checkSavedEulaAccepted();
                        });
                    }
                });
            });
            thread.setName("EULA Download");
            thread.setDaemon(true);
            thread.start();
        } else {
            this.checkSavedEulaAccepted();
        }
    }

    private void checkSavedEulaAccepted() {
        Optional eulaOpt = K.A();
        eulaOpt.ifPresent(eula -> {
            if (!eula.C()) {
                EulaDisplayer.getDefault().show(eula);
            }
        });
    }
}

