/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import com.bulenkov.iconloader.util.GraphicsUtil;
import com.paterva.maltego.util.IconSize;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabControlButton;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

public class OfficeViewTabDisplayerUIOld
extends AbstractViewTabDisplayerUI {
    private static final int MAIN_ICON_PAD = 4;
    private static final int TXT_X_PAD = 4;
    private static final int TXT_Y_PAD = 3;
    private static final int ICON_X_PAD = 2;
    private static final int HIGHLIGHTED_RAISE = 1;
    private static Map<Integer, String[]> buttonIconPaths;
    private static Color inactBgColor;
    private static Color actBgColor;
    public static final String BG1_FOCUSED_COLOR = "window-title-bg-focused";
    public static final String BG1_COLOR = "window-title-bg1";
    public static final String BG1_ATTENTION_COLOR = "window-title-bg-attention";
    private final Dimension prefSize = new Dimension(100, 17);
    private Font font;
    private TabControlButton hidePin;
    protected JPanel buttonsPanel;
    private final Integer previousSelection = null;

    private OfficeViewTabDisplayerUIOld(TabDisplayer displayer) {
        super(displayer);
    }

    public static ComponentUI createUI(JComponent c) {
        return new OfficeViewTabDisplayerUIOld((TabDisplayer)c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        OfficeViewTabDisplayerUIOld.initIcons();
        c.setOpaque(false);
        this.getControlButtons();
    }

    public void uninstallUI(JComponent arg0) {
        super.uninstallUI(arg0);
        if (this.buttonsPanel != null) {
            this.displayer.remove((Component)this.buttonsPanel);
            this.buttonsPanel = null;
        }
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = this.getTxtFontMetrics();
        int height = fm == null ? 17 : fm.getAscent() + 2 * fm.getDescent() + 3;
        Insets insets = c.getInsets();
        this.prefSize.height = height + insets.bottom + insets.top + 2;
        return this.prefSize;
    }

    protected void paintTabContent(Graphics g, int index, String text, int x, int y, int width, int height) {
        Color textColor;
        FontMetrics fm = this.getTxtFontMetrics();
        g.setFont(this.getTxtFont());
        if (!this.isTabInFront(index) && this.isMoreThanOne()) {
            ++y;
            --height;
        }
        Icon icon = this.getDataModel().getTab(index).getIcon();
        boolean hasIcon = false;
        int iconSize = IconSize.TINY.getSize();
        if (icon != null && icon.getIconWidth() <= iconSize && icon.getIconHeight() <= iconSize) {
            hasIcon = true;
        }
        int txtWidth = width;
        int txtPad = 8 + (hasIcon ? icon.getIconWidth() + 4 : 0);
        if (this.isSelected(index)) {
            Component buttons = this.getControlButtons();
            if (null != buttons) {
                Dimension buttonsSize = buttons.getPreferredSize();
                txtWidth = width - (buttonsSize.width + 2 + txtPad);
                buttons.setLocation(x + txtWidth + txtPad, y + (height - buttonsSize.height) / 2);
            }
        } else {
            txtWidth = width - txtPad;
        }
        Font fontTemp = this.getTxtFont();
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        Color color = textColor = this.isDimmed(index) ? laf.getColor("window-title-dimmed-fg") : laf.getColor("window-title-fg");
        if (hasIcon) {
            icon.paintIcon(null, g, x + 4, y + 3);
        }
        int txtLeft = 4 + (hasIcon ? 4 + icon.getIconWidth() : 0);
        if (text != null) {
            HtmlRenderer.renderString((String)text, (Graphics)g, (int)(x + txtLeft), (int)(y + fm.getAscent() + 3), (int)txtWidth, (int)height, (Font)fontTemp, (Color)textColor, (int)1, (boolean)true);
        }
    }

    protected void paintTabBorder(Graphics g, int index, int x, int y, int width, int height) {
    }

    protected void paintTabBackground(Graphics g, int index, int x, int y, int width, int height) {
        boolean selected = this.isSelected(index);
        boolean focused = selected && this.isActive();
        boolean attention = this.isAttention(index);
        boolean isInfront = !this.isMoreThanOne() || this.isTabInFront(index);
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        Color color = focused ? laf.getColor(BG1_FOCUSED_COLOR) : (attention && !isInfront ? laf.getColor(BG1_ATTENTION_COLOR) : laf.getColor(BG1_COLOR));
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(color);
        g2d.fillRect(x, y, width, height);
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GraphicsUtil.setupTextAntialiasing((Graphics)g2d, (JComponent)c);
        TabDataModel dataModel = this.getDataModel();
        TabLayoutModel layoutModel = this.getLayoutModel();
        for (int i = 0; i < dataModel.size(); ++i) {
            boolean dimmed = this.isDimmed(i);
            TabData tabData = dataModel.getTab(i);
            int x = layoutModel.getX(i);
            int y = layoutModel.getY(i);
            int width = layoutModel.getW(i);
            int height = layoutModel.getH(i);
            String text = tabData.getText();
            BufferedImage img = null;
            Graphics2D bg = g2d;
            int origX = x;
            int origY = y;
            if (dimmed) {
                x = 0;
                y = 0;
                img = g2d.getDeviceConfiguration().createCompatibleImage(width, height, 3);
                bg = img.createGraphics();
                bg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                GraphicsUtil.setupTextAntialiasing((Graphics)bg, (JComponent)c);
                bg.setClip(0, 0, width, height);
                float alpha = this.isActive() ? 0.7f : 0.5f;
                bg.setComposite(AlphaComposite.getInstance(3, alpha));
            }
            if (bg.hitClip(x, y, width, height)) {
                this.paintTabBackground(bg, i, x, y, width, height);
                this.paintTabContent(bg, i, text, x, y, width, height);
                this.paintTabBorder(bg, i, x, y, width, height);
            }
            if (!dimmed) continue;
            bg.dispose();
            g2d.drawImage((Image)img, origX, origY, null);
        }
        g2d.dispose();
    }

    protected Font getTxtFont() {
        if (this.font == null) {
            this.font = (Font)UIManager.get("windowTitleFont");
            if (this.font == null) {
                this.font = new JLabel().getFont();
                this.font = this.font.deriveFont((float)this.font.getSize() + 1.0f);
            } else {
                this.font = this.font.deriveFont((float)this.font.getSize() + 1.0f);
            }
        }
        return this.font;
    }

    private boolean isDimmed(int index) {
        return !this.isSelected(index) && !this.isUnderMouse(index);
    }

    private boolean isUnderMouse(int index) {
        return ((OwnController)this.getController()).getMouseIndex() == index;
    }

    private boolean isTabInFront(int index) {
        return this.isSelected(index) && (this.isActive() || this.isMoreThanOne());
    }

    private boolean isMoreThanOne() {
        return this.getDataModel().size() > 1;
    }

    private boolean isLast(int index) {
        return this.getDataModel().size() - 1 == index;
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] iconPaths;
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            iconPaths = new String[]{"org/openide/awt/resources/xp_bigclose_enabled.png", "org/openide/awt/resources/xp_bigclose_pressed.png", iconPaths[0], "org/openide/awt/resources/xp_bigclose_rollover.png"};
            buttonIconPaths.put(1, iconPaths);
            iconPaths = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_slideright_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_slideright_pressed.png", iconPaths[0], "org/netbeans/swing/tabcontrol/resources/xp_slideright_rollover.png"};
            buttonIconPaths.put(6, iconPaths);
            iconPaths = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_slideleft_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_slideleft_pressed.png", iconPaths[0], "org/netbeans/swing/tabcontrol/resources/xp_slideleft_rollover.png"};
            buttonIconPaths.put(5, iconPaths);
            iconPaths = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_slidebottom_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_slidebottom_pressed.png", iconPaths[0], "org/netbeans/swing/tabcontrol/resources/xp_slidebottom_rollover.png"};
            buttonIconPaths.put(7, iconPaths);
            iconPaths = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_pin_pressed.png", iconPaths[0], "org/netbeans/swing/tabcontrol/resources/xp_pin_rollover.png"};
            buttonIconPaths.put(2, iconPaths);
            iconPaths = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_restore_group_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_restore_group_pressed.png", iconPaths[0], "org/netbeans/swing/tabcontrol/resources/xp_restore_group_rollover.png"};
            buttonIconPaths.put(11, iconPaths);
            iconPaths = new String[]{"org/netbeans/swing/tabcontrol/resources/xp_minimize_enabled.png", "org/netbeans/swing/tabcontrol/resources/xp_minimize_pressed.png", iconPaths[0], "org/netbeans/swing/tabcontrol/resources/xp_minimize_rollover.png"};
            buttonIconPaths.put(12, iconPaths);
        }
    }

    protected Component getControlButtons() {
        if (null == this.buttonsPanel) {
            this.buttonsPanel = new JPanel(null);
            this.buttonsPanel.setOpaque(false);
            Border border = this.createBorder();
            Insets insets = border.getBorderInsets(this.buttonsPanel);
            int width = insets.left;
            int height = insets.top;
            if (null != this.displayer.getWinsysInfo()) {
                this.hidePin = TabControlButtonFactory.createSlidePinButton((TabDisplayer)this.displayer);
                this.buttonsPanel.add((Component)this.hidePin);
                Icon icon = this.hidePin.getIcon();
                this.hidePin.setBounds(width, 0, icon.getIconWidth(), icon.getIconHeight());
                width += icon.getIconWidth();
            }
            TabControlButton btnClose = TabControlButtonFactory.createCloseButton((TabDisplayer)this.displayer);
            this.buttonsPanel.add((Component)btnClose);
            Icon icon = btnClose.getIcon();
            if (0 != width) {
                width += 2;
            }
            Dimension preferredSize = btnClose.getPreferredSize();
            btnClose.setBounds(width, 0, icon.getIconWidth(), icon.getIconHeight());
            width += icon.getIconWidth();
            height += this.hidePin.getHeight() > btnClose.getHeight() ? this.hidePin.getHeight() : btnClose.getHeight();
            width += insets.right;
            Rectangle r = this.hidePin.getBounds();
            r.y = (height += insets.bottom) / 2 - r.height / 2;
            this.hidePin.setBounds(r);
            r = btnClose.getBounds();
            r.y = height / 2 - r.height / 2;
            btnClose.setBounds(r);
            Dimension size = new Dimension(width, height);
            this.buttonsPanel.setMinimumSize(size);
            this.buttonsPanel.setSize(size);
            this.buttonsPanel.setPreferredSize(size);
            this.buttonsPanel.setMaximumSize(size);
            try {
                Field bthidePin = AbstractViewTabDisplayerUI.class.getDeclaredField("btnAutoHidePin");
                if (bthidePin != null) {
                    bthidePin.setAccessible(true);
                    bthidePin.set((Object)this, this.hidePin);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.buttonsPanel;
    }

    public Icon getButtonIcon(int buttonId, int buttonState) {
        Icon res = null;
        OfficeViewTabDisplayerUIOld.initIcons();
        String[] paths = buttonIconPaths.get(buttonId);
        if (null != paths && buttonState >= 0 && buttonState < paths.length) {
            res = TabControlButtonFactory.getIcon((String)paths[buttonState]);
        }
        return res;
    }

    public void postTabAction(TabActionEvent e) {
        super.postTabAction(e);
        if ("maximize".equals(e.getActionCommand())) {
            ((OwnController)this.getController()).updateHighlight(-1);
        }
    }

    private Border createBorder() {
        Border empty = BorderFactory.createEmptyBorder(4, 3, 4, 1);
        AbstractBorder outer = new AbstractBorder(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D g2d = (Graphics2D)g;
                Color oldColor = g2d.getColor();
                int startY = y + 2;
                int stopY = y + height - 3;
                g2d.setColor(new Color(145, 153, 164));
                g2d.drawLine(x, startY, x, stopY);
                g2d.setColor(new Color(221, 224, 227));
                g2d.drawLine(x + 1, startY, x + 1, stopY);
                g2d.setColor(oldColor);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 2, 0, 0);
            }

            @Override
            public Insets getBorderInsets(Component c, Insets insets) {
                insets.left = 2;
                insets.top = 0;
                insets.right = 0;
                insets.bottom = 0;
                return insets;
            }
        };
        return BorderFactory.createCompoundBorder(outer, empty);
    }

    static Color getInactBgColor() {
        if (inactBgColor == null && (inactBgColor = (Color)UIManager.get("inactiveCaption")) == null) {
            inactBgColor = new Color(204, 204, 204);
        }
        return inactBgColor;
    }

    static Color getActBgColor() {
        if (actBgColor == null && (actBgColor = (Color)UIManager.get("activeCaption")) == null) {
            actBgColor = new Color(204, 204, 255);
        }
        return actBgColor;
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private int lastIndex;

        private OwnController() {
            super((AbstractViewTabDisplayerUI)OfficeViewTabDisplayerUIOld.this);
            this.lastIndex = -1;
        }

        public int getMouseIndex() {
            return this.lastIndex;
        }

        public boolean inControlButtonsRect(Point p) {
            if (null != OfficeViewTabDisplayerUIOld.this.buttonsPanel) {
                Point p2 = SwingUtilities.convertPoint((Component)OfficeViewTabDisplayerUIOld.this.displayer, p, OfficeViewTabDisplayerUIOld.this.buttonsPanel);
                return OfficeViewTabDisplayerUIOld.this.buttonsPanel.contains(p2);
            }
            return false;
        }

        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            Point pos = e.getPoint();
            if (!e.getSource().equals(OfficeViewTabDisplayerUIOld.this.displayer)) {
                pos = SwingUtilities.convertPoint((Component)e.getSource(), pos, (Component)OfficeViewTabDisplayerUIOld.this.displayer);
            }
            this.updateHighlight(OfficeViewTabDisplayerUIOld.this.getLayoutModel().indexOfPoint(pos.x, pos.y));
        }

        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            if (!this.inControlButtonsRect(e.getPoint())) {
                this.updateHighlight(-1);
            }
        }

        private void updateHighlight(int curIndex) {
            int h;
            int w;
            int y;
            int x;
            if (curIndex == this.lastIndex) {
                return;
            }
            TabLayoutModel tlm = OfficeViewTabDisplayerUIOld.this.getLayoutModel();
            Rectangle repaintRect = null;
            if (curIndex != -1) {
                x = tlm.getX(curIndex);
                y = tlm.getY(curIndex);
                w = tlm.getW(curIndex);
                h = tlm.getH(curIndex);
                repaintRect = new Rectangle(x, y, w, h);
            }
            if (this.lastIndex != -1 && this.lastIndex < OfficeViewTabDisplayerUIOld.this.getDataModel().size()) {
                x = tlm.getX(this.lastIndex);
                y = tlm.getY(this.lastIndex);
                w = tlm.getW(this.lastIndex);
                h = tlm.getH(this.lastIndex);
                repaintRect = repaintRect != null ? repaintRect.union(new Rectangle(x, y, w, h)) : new Rectangle(x, y, w, h);
            }
            if (repaintRect != null) {
                OfficeViewTabDisplayerUIOld.this.getDisplayer().repaint(repaintRect);
            }
            this.lastIndex = curIndex;
        }

        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            this.mouseMoved(e);
        }
    }
}

