/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class OfficePanelUI
extends BasicPanelUI {
    private static final String MAIN_BG_COLOR = "main-bg-color";
    private static final OfficePanelUI DEFAULT = new OfficePanelUI();
    private static final OfficePanelUI SOLID = new OfficePanelUI(Type.SOLID);
    private static Boolean mainBgIsSet = false;
    private Type type = Type.DEFAULT;

    public OfficePanelUI(Type type) {
        this.type = type;
    }

    public OfficePanelUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        OfficePanelUI retVal = DEFAULT;
        String name = c.getClass().getName();
        if ("org.netbeans.core.windows.view.ui.MultiSplitPane".equals(name) || "org.netbeans.core.windows.view.EditorView$EditorAreaComponent".equals(name) || "org.netbeans.core.windows.view.ui.slides.SlideBarContainer$VisualPanel".equals(name)) {
            retVal = SOLID;
        }
        return retVal;
    }

    @Override
    protected void installDefaults(JPanel p) {
        super.installDefaults(p);
        if (this.type == Type.TRANSPARENT) {
            p.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            p.setOpaque(false);
        } else if (this.type == Type.SOLID) {
            p.setBackground(UIManager.getLookAndFeelDefaults().getColor(MAIN_BG_COLOR));
            p.setOpaque(true);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        switch (this.type) {
            case MAIN_BG: {
                g2d.setColor(UIManager.getLookAndFeelDefaults().getColor(MAIN_BG_COLOR));
                g2d.fillRect(0, 0, c.getWidth(), c.getHeight());
                break;
            }
            case TRANSPARENT: {
                break;
            }
            default: {
                Container parent = c.getParent();
                if (parent != null && parent.getClass().getName().startsWith("y.view.Graph2DView")) {
                    if (!c.isOpaque()) break;
                    g2d.setColor(UIManager.getLookAndFeelDefaults().getColor("ScrollBar.darculaMod.TrackBackgroundColor"));
                    g2d.fillRect(0, 0, c.getWidth(), c.getHeight());
                    break;
                }
                if (!c.isOpaque()) break;
                g2d.setColor(c.getBackground());
                g2d.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
        }
        this.paint(g, c);
    }

    private static enum Type {
        MAIN_BG,
        TRANSPARENT,
        SOLID,
        DEFAULT;

    }
}

