/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.components.IconWrapperResizableIcon;
import com.paterva.maltego.util.ui.components.LabelGroupWithBackground;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.TableCellRenderer;
import mslinks.ShellLink;
import mslinks.ShellLinkException;
import org.officelaf.OSFileChooser;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import sun.awt.shell.ShellFolder;
import sun.swing.FilePane;
import sun.swing.SwingUtilities2;

public class OfficeFileChooserUI
extends BasicFileChooserUI {
    private LabelGroupWithBackground lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private FilePane filePane;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private Icon symDirectoryIcon = null;
    private Icon symFileIcon = null;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut5 = new Dimension(5, 1);
    private static final Dimension hstrut11 = new Dimension(11, 1);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 500;
    private static int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 405;
    private static int LIST_PREF_HEIGHT = 135;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int folderNameLabelMnemonic = 0;
    private String folderNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private FileView fileView = new BasicFileView();
    private LabelGroupWithBackground fileNameLabel;
    private final Action approveSelectionActionCustom = new ApproveSelectionActionCustom();
    static final int space = 10;

    private void populateFileNameLabel() {
        if (this.getFileChooser().getFileSelectionMode() == 1) {
            this.fileNameLabel.setText(this.folderNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.folderNameLabelMnemonic);
        } else {
            this.fileNameLabel.setText(this.fileNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        }
    }

    public static ComponentUI createUI(JComponent b) {
        return new OfficeFileChooserUI((JFileChooser)b);
    }

    public OfficeFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
    }

    @Override
    public void installComponents(JFileChooser fc) {
        FileSystemView fsv = fc.getFileSystemView();
        fc.setBorder(new EmptyBorder(12, 12, 11, 11));
        fc.setLayout(new BorderLayout(0, 11));
        this.filePane = new FilePane(new OfficeFileChooserUIAccessor()){

            @Override
            public JPanel createDetailsView() {
                JPanel panel = super.createDetailsView();
                JTable detailsTableObtained = this.findTable(panel);
                if (detailsTableObtained != null) {
                    AlignableTableHeaderRenderer headerRenderer = new AlignableTableHeaderRenderer(detailsTableObtained.getTableHeader().getDefaultRenderer());
                    detailsTableObtained.getTableHeader().setDefaultRenderer(headerRenderer);
                    detailsTableObtained.setShowVerticalLines(true);
                }
                return panel;
            }

            private JTable findTable(Container container) {
                JTable table = null;
                for (Component c : container.getComponents()) {
                    if (c instanceof JTable) {
                        return (JTable)c;
                    }
                    if (!(c instanceof Container) || (table = this.findTable((Container)c)) == null) continue;
                    return table;
                }
                return table;
            }

            class AlignableTableHeaderRenderer
            implements TableCellRenderer {
                TableCellRenderer wrappedRenderer;

                public AlignableTableHeaderRenderer(TableCellRenderer wrappedRenderer) {
                    this.wrappedRenderer = wrappedRenderer;
                }

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = this.wrappedRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    Integer alignment = 0;
                    if (c instanceof JLabel) {
                        ((JLabel)c).setHorizontalAlignment(alignment);
                    }
                    return c;
                }
            }
        };
        fc.addPropertyChangeListener(this.filePane);
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel topButtonPanel = new JPanel();
        topButtonPanel.setLayout(new BoxLayout(topButtonPanel, 2));
        Color color = UIManager.getLookAndFeelDefaults().getColor("Label.darculaMod.panelBackground");
        topButtonPanel.setBackground(color);
        topPanel.add((Component)topButtonPanel, "After");
        fc.add((Component)topPanel, "North");
        this.lookInLabel = new LabelGroupWithBackground(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        topPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 150;
                return d;
            }
        };
        this.directoryComboBox.putClientProperty("AccessibleDescription", this.lookInLabelText);
        this.directoryComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.directoryComboBox.putClientProperty("JComboBox.darculaForwardEnterKeyEvent", Boolean.FALSE);
        this.directoryComboBox.setEditable(true);
        this.lookInLabel.setLabelFor((Component)this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        topPanel.add((Component)this.directoryComboBox, "Center");
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        int iconSize = IconSize.TINY.getSize();
        Dimension buttonDimension = new Dimension(14 + iconSize, 8 + iconSize);
        IconWrapperResizableIcon upFolderIconResizableIcon = new IconWrapperResizableIcon(this.upFolderIcon);
        upFolderIconResizableIcon.setDimension(buttonDimension);
        JCommandButton upFolderButton = new JCommandButton(null, (ResizableIcon)upFolderIconResizableIcon);
        upFolderButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
        upFolderButton.addActionListener((ActionListener)this.getChangeToParentDirectoryAction());
        upFolderButton.setToolTipText(this.upFolderToolTipText);
        upFolderButton.putClientProperty((Object)"AccessibleName", (Object)this.upFolderAccessibleName);
        topButtonPanel.add((Component)upFolderButton);
        File homeDir = fsv.getHomeDirectory();
        String toolTipText = this.homeFolderToolTipText;
        if (fsv.isRoot(homeDir)) {
            toolTipText = this.getFileView(fc).getName(homeDir);
        }
        IconWrapperResizableIcon homeFolderIconResizableIcon = new IconWrapperResizableIcon(this.homeFolderIcon);
        homeFolderIconResizableIcon.setDimension(buttonDimension);
        JCommandButton b = new JCommandButton(null, (ResizableIcon)homeFolderIconResizableIcon);
        b.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
        b.addActionListener((ActionListener)this.getGoHomeAction());
        b.setToolTipText(toolTipText);
        b.putClientProperty((Object)"AccessibleName", (Object)this.homeFolderAccessibleName);
        topButtonPanel.add((Component)b);
        if (!UIManager.getBoolean("FileChooser.readOnly")) {
            IconWrapperResizableIcon newFolderIconResizableIcon = new IconWrapperResizableIcon(this.newFolderIcon);
            newFolderIconResizableIcon.setDimension(buttonDimension);
            b = new JCommandButton(null, (ResizableIcon)newFolderIconResizableIcon);
            b.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
            b.addActionListener((ActionListener)this.filePane.getNewFolderAction());
            b.setToolTipText(this.newFolderToolTipText);
            b.putClientProperty((Object)"AccessibleName", (Object)this.newFolderAccessibleName);
        }
        topButtonPanel.add((Component)b);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        ButtonGroup viewButtonGroup = new ButtonGroup();
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setBackground(color);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.putClientProperty("AccessibleName", this.listViewButtonAccessibleName);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(this.filePane.getViewTypeAction(0));
        topButtonPanel.add(this.listViewButton);
        viewButtonGroup.add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setBackground(color);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.putClientProperty("AccessibleName", this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(this.filePane.getViewTypeAction(1));
        topButtonPanel.add(this.detailsViewButton);
        viewButtonGroup.add(this.detailsViewButton);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        this.filePane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("viewType".equals(e.getPropertyName())) {
                    int viewType = OfficeFileChooserUI.this.filePane.getViewType();
                    switch (viewType) {
                        case 0: {
                            OfficeFileChooserUI.this.listViewButton.setSelected(true);
                            break;
                        }
                        case 1: {
                            OfficeFileChooserUI.this.detailsViewButton.setSelected(true);
                        }
                    }
                }
            }
        });
        JPanel accessoryPanel = this.getAccessoryPanel();
        fc.add((Component)accessoryPanel, "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
            this.getAccessoryPanel().setBackground(Color.green);
        }
        this.filePane.setPreferredSize(LIST_PREF_SIZE);
        LabelGroupWithBackground fillLabel = new LabelGroupWithBackground();
        fillLabel.setOpaque(false);
        fc.add((Component)fillLabel, "West");
        fc.add((Component)this.filePane, "Center");
        JPanel bottomPanel = this.getBottomPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        fc.add((Component)bottomPanel, "South");
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setLayout(new BorderLayout());
        bottomPanel.add(fileNamePanel);
        bottomPanel.add(Box.createRigidArea(vstrut5));
        this.fileNameLabel = new LabelGroupWithBackground();
        this.populateFileNameLabel();
        fileNamePanel.add((Component)this.fileNameLabel, "West");
        this.fileNameTextField = new JTextField(35){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        fileNamePanel.add((Component)this.fileNameTextField, "Center");
        this.fileNameLabel.setLabelFor((Component)this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!OfficeFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    OfficeFileChooserUI.this.filePane.clearSelection();
                }
            }
        });
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFile()));
        }
        JPanel filesOfTypePanel = new JPanel();
        filesOfTypePanel.setLayout(new BorderLayout());
        bottomPanel.add(filesOfTypePanel);
        LabelGroupWithBackground filesOfTypeLabel = new LabelGroupWithBackground(this.filesOfTypeLabelText);
        filesOfTypeLabel.setLayout(null);
        filesOfTypeLabel.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        filesOfTypePanel.add((Component)filesOfTypeLabel, "West");
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox<Object>(this.filterComboBoxModel);
        this.filterComboBox.putClientProperty("AccessibleDescription", this.filesOfTypeLabelText);
        filesOfTypeLabel.setLabelFor((Component)this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        filesOfTypePanel.add((Component)this.filterComboBox, "Center");
        this.getButtonPanel().setLayout(new ButtonAreaLayout());
        this.approveButton = new JButton(this.getApproveButtonText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.getButtonPanel().add(this.approveButton);
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        LabelGroupWithBackground.groupLabels((LabelGroupWithBackground[])new LabelGroupWithBackground[]{this.fileNameLabel, filesOfTypeLabel});
        LabelGroupWithBackground.groupLabels((LabelGroupWithBackground[])new LabelGroupWithBackground[]{this.lookInLabel, fillLabel});
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    @Override
    public Action getApproveSelectionAction() {
        return this.approveSelectionActionCustom;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.lookInLabelMnemonic = this.getMnemonic("FileChooser.lookInLabelMnemonic", l);
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", l);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", l);
        this.fileNameLabelMnemonic = this.getMnemonic("FileChooser.fileNameLabelMnemonic", l);
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", l);
        this.folderNameLabelMnemonic = this.getMnemonic("FileChooser.folderNameLabelMnemonic", l);
        this.folderNameLabelText = UIManager.getString((Object)"FileChooser.folderNameLabelText", l);
        this.filesOfTypeLabelMnemonic = this.getMnemonic("FileChooser.filesOfTypeLabelMnemonic", l);
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", l);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", l);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", l);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", l);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", l);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", l);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", l);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", l);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", l);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", l);
    }

    private Integer getMnemonic(String key, Locale l) {
        return SwingUtilities2.getUIDefaultsInt((Object)key, l);
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        FilePane.addActionsToMap(map, this.filePane.getActions());
        return map;
    }

    protected JPanel createList(JFileChooser fc) {
        return this.filePane.createList();
    }

    protected JPanel createDetailsView(JFileChooser fc) {
        return this.filePane.createDetailsView();
    }

    @Override
    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return super.createListSelectionListener(fc);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        c.removePropertyChangeListener(this.filePane);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        if (this.filePane != null) {
            this.filePane.uninstallUI();
            this.filePane = null;
        }
        super.uninstallUI(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int prefWidth = OfficeFileChooserUI.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefWidth ? prefWidth : d.width, d.height < OfficeFileChooserUI.PREF_SIZE.height ? OfficeFileChooserUI.PREF_SIZE.height : d.height);
        }
        return new Dimension(prefWidth, OfficeFileChooserUI.PREF_SIZE.height);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() || fc.isDirectorySelectionEnabled() && fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystemRoot(file)) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] files) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.fileNameString(files));
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.clearIconCache();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(currentDirectory.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.clearIconCache();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        if (this.fileNameLabel != null) {
            this.populateFileNameLabel();
        }
        this.clearIconCache();
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (chooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    OfficeFileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    OfficeFileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    OfficeFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    OfficeFileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    OfficeFileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    OfficeFileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    OfficeFileChooserUI.this.doApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    OfficeFileChooserUI.this.doDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    OfficeFileChooserUI.this.doApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    OfficeFileChooserUI.this.doControlButtonsChanged(e);
                } else if (s.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JFileChooser cc = (JFileChooser)e.getSource();
                    if (o != e.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                } else if (s == "FileChooser.useShellFolder") {
                    OfficeFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    OfficeFileChooserUI.this.fileNameTextField.selectAll();
                    OfficeFileChooserUI.this.fileNameTextField.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, File f) {
        this.filePane.ensureFileIsVisible(fc, f);
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.filePane.rescanCurrentDirectory();
    }

    @Override
    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    @Override
    protected void setDirectorySelected(boolean directorySelected) {
        super.setDirectorySelected(directorySelected);
        JFileChooser chooser = this.getFileChooser();
        if (directorySelected) {
            if (this.approveButton != null) {
                this.approveButton.setText(this.directoryOpenButtonText);
                this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
            }
        } else if (this.approveButton != null) {
            this.approveButton.setText(this.getApproveButtonText(chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        }
    }

    @Override
    public String getDirectoryName() {
        return null;
    }

    @Override
    public void setDirectoryName(String dirname) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent e) {
        JFileChooser fc = this.getFileChooser();
        File f = fc.getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
        }
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    @Override
    protected void uninstallIcons(JFileChooser fc) {
        super.uninstallIcons(fc);
        this.symDirectoryIcon = null;
        this.symFileIcon = null;
    }

    @Override
    protected void installIcons(JFileChooser fc) {
        super.installIcons(fc);
        this.symDirectoryIcon = UIManager.getIcon("FileView.symDirectoryIcon");
        this.symFileIcon = UIManager.getIcon("FileView.symFileIcon");
    }

    protected class BasicFileView
    extends FileView {
        protected Hashtable<File, Icon> iconCache = new Hashtable();

        public void clearIconCache() {
            this.iconCache = new Hashtable();
        }

        @Override
        public String getName(File f) {
            String fileName = null;
            if (f != null) {
                fileName = OfficeFileChooserUI.this.getFileChooser().getFileSystemView().getSystemDisplayName(f);
            }
            return fileName;
        }

        @Override
        public String getDescription(File f) {
            return f.getName();
        }

        @Override
        public String getTypeDescription(File f) {
            String type = OfficeFileChooserUI.this.getFileChooser().getFileSystemView().getSystemTypeDescription(f);
            if (type == null) {
                type = f.isDirectory() ? UIManager.getString((Object)"FileChooser.directoryDescriptionText", OfficeFileChooserUI.this.getFileChooser().getLocale()) : UIManager.getString((Object)"FileChooser.fileDescriptionText", OfficeFileChooserUI.this.getFileChooser().getLocale());
            }
            return type;
        }

        public Icon getCachedIcon(File f) {
            return this.iconCache.get(f);
        }

        public void cacheIcon(File f, Icon i) {
            if (f == null || i == null) {
                return;
            }
            this.iconCache.put(f, i);
        }

        @Override
        public Icon getIcon(File f) {
            JFileChooser fc;
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            if (Utilities.isMac() && (fc = OSFileChooser.getDefault(true)) != null) {
                icon = fc.getIcon(f);
            }
            boolean useDarculaFileViewIcon = false;
            if (icon == null) {
                icon = OfficeFileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(f);
                if (f != null && !Utilities.isMac() && Utilities.isUnix() && Files.isSymbolicLink(f.toPath())) {
                    icon = this.getLinuxSymlinkIcon(icon, f);
                }
            }
            if (icon == null) {
                icon = OfficeFileChooserUI.this.fileIcon;
                useDarculaFileViewIcon = true;
            }
            if (useDarculaFileViewIcon && f != null) {
                FileSystemView fsv = OfficeFileChooserUI.this.getFileChooser().getFileSystemView();
                if (fsv.isFloppyDrive(f)) {
                    icon = OfficeFileChooserUI.this.floppyDriveIcon;
                } else if (fsv.isDrive(f)) {
                    icon = OfficeFileChooserUI.this.hardDriveIcon;
                } else if (fsv.isComputerNode(f)) {
                    icon = OfficeFileChooserUI.this.computerIcon;
                } else if (f.isDirectory()) {
                    icon = OfficeFileChooserUI.this.directoryIcon;
                }
            }
            this.cacheIcon(f, icon);
            return icon;
        }

        public Boolean isHidden(File f) {
            String name = f.getName();
            if (name != null && name.charAt(0) == '.') {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        private Icon getLinuxSymlinkIcon(Icon inIcon, File f) {
            Icon outIcon = inIcon;
            if (f.isDirectory()) {
                outIcon = OfficeFileChooserUI.this.symDirectoryIcon;
            } else if (f.isFile()) {
                outIcon = OfficeFileChooserUI.this.symFileIcon;
            }
            return outIcon;
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int hGap = 5;
        private int topMargin = 17;

        private ButtonAreaLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component comp) {
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int xOffset;
                int xLocation;
                int numChildren = children.length;
                Dimension[] sizes = new Dimension[numChildren];
                Insets insets = container.getInsets();
                int yLocation = insets.top + this.topMargin;
                int maxWidth = 0;
                for (int counter = 0; counter < numChildren; ++counter) {
                    sizes[counter] = children[counter].getPreferredSize();
                    maxWidth = Math.max(maxWidth, sizes[counter].width);
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    xLocation = container.getSize().width - insets.left - maxWidth;
                    xOffset = this.hGap + maxWidth;
                } else {
                    xLocation = insets.left;
                    xOffset = -(this.hGap + maxWidth);
                }
                for (int counter = numChildren - 1; counter >= 0; --counter) {
                    children[counter].setBounds(xLocation, yLocation, maxWidth, sizes[counter].height);
                    xLocation -= xOffset;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                int height = 0;
                Insets cInsets = c.getInsets();
                int extraHeight = this.topMargin + cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                int maxWidth = 0;
                for (int counter = 0; counter < numChildren; ++counter) {
                    Dimension aSize = children[counter].getPreferredSize();
                    height = Math.max(height, aSize.height);
                    maxWidth = Math.max(maxWidth, aSize.width);
                }
                return new Dimension(extraWidth + numChildren * maxWidth + (numChildren - 1) * this.hGap, extraHeight + height);
            }
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OfficeFileChooserUI.this.directoryComboBox.hidePopup();
            File f = (File)OfficeFileChooserUI.this.directoryComboBox.getSelectedItem();
            if (!OfficeFileChooserUI.this.getFileChooser().getCurrentDirectory().equals(f)) {
                OfficeFileChooserUI.this.getFileChooser().setCurrentDirectory(f);
            }
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel<Object>
    implements ComboBoxModel<Object>,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = OfficeFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                OfficeFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter currentFilter = OfficeFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (FileFilter filter : this.filters) {
                    if (filter != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    OfficeFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return OfficeFileChooserUI.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return OfficeFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel<Object>
    implements ComboBoxModel<Object> {
        Vector<File> directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = OfficeFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = OfficeFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            File canonical;
            if (directory == null) {
                return;
            }
            boolean useShellFolder = FilePane.usesShellFolder(this.chooser);
            this.directories.clear();
            File[] baseFolders = useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(baseFolders));
            try {
                canonical = ShellFolder.getNormalizedFile(directory);
            }
            catch (IOException e) {
                canonical = directory;
            }
            try {
                File sf;
                File f = sf = useShellFolder ? ShellFolder.getShellFolder(canonical) : canonical;
                Vector<File> path = new Vector<File>(10);
                do {
                    path.addElement(f);
                } while ((f = f.getParentFile()) != null);
                int pathCount = path.size();
                for (int i = 0; i < pathCount; ++i) {
                    f = (File)path.get(i);
                    if (!this.directories.contains(f)) continue;
                    int topIndex = this.directories.indexOf(f);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt((File)path.get(j), topIndex + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(sf);
            }
            catch (FileNotFoundException ex) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File dir = this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals(this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        @Override
        public void setSelectedItem(Object newSelectedDirectory) {
            File selected = null;
            if (newSelectedDirectory instanceof String) {
                selected = new File((String)newSelectedDirectory);
            } else if (newSelectedDirectory instanceof File) {
                selected = (File)newSelectedDirectory;
            }
            if (selected != null) {
                File potentialLink = new File(selected.getPath() + ".lnk");
                if (!selected.isDirectory()) {
                    if (potentialLink.isFile()) {
                        try {
                            ShellLink shellLink = new ShellLink(potentialLink);
                            selected = new File(shellLink.resolveTarget());
                        }
                        catch (IOException | SecurityException | ShellLinkException ex) {
                            if (selected.getParentFile() != null && selected.getParentFile().isDirectory()) {
                                selected = selected.getParentFile();
                            }
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    } else {
                        selected = selected.getParentFile() != null && selected.getParentFile().isDirectory() ? selected.getParentFile() : null;
                    }
                }
            }
            if (selected != null) {
                this.selectedDirectory = selected;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(OfficeFileChooserUI.this.getFileChooser().getName(directory));
            this.ii.icon = icon = OfficeFileChooserUI.this.getFileChooser().getIcon(directory);
            this.ii.depth = OfficeFileChooserUI.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        public SingleClickListener(JList list) {
        }
    }

    protected class ApproveSelectionActionCustom
    extends BasicFileChooserUI.ApproveSelectionAction {
        protected ApproveSelectionActionCustom() {
            super(OfficeFileChooserUI.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File dir;
            boolean customAction = true;
            if (OfficeFileChooserUI.this.isDirectorySelected() && (dir = OfficeFileChooserUI.this.getDirectory()) != null) {
                customAction = false;
            }
            if (customAction) {
                String filename = OfficeFileChooserUI.this.getFileName();
                if (filename != null) {
                    int i;
                    for (i = filename.length() - 1; i >= 0 && filename.charAt(i) <= ' '; --i) {
                    }
                    filename = filename.substring(0, i + 1);
                }
                if (filename == null || filename.length() == 0) {
                    JFileChooser chooser = OfficeFileChooserUI.this.getFileChooser();
                    chooser.firePropertyChange("ApproveSelection_Custom", false, true);
                }
            }
            super.actionPerformed(e);
        }
    }

    private class OfficeFileChooserUIAccessor
    implements FilePane.FileChooserUIAccessor {
        private OfficeFileChooserUIAccessor() {
        }

        @Override
        public JFileChooser getFileChooser() {
            return OfficeFileChooserUI.this.getFileChooser();
        }

        @Override
        public BasicDirectoryModel getModel() {
            return OfficeFileChooserUI.this.getModel();
        }

        @Override
        public JPanel createList() {
            return OfficeFileChooserUI.this.createList(this.getFileChooser());
        }

        @Override
        public JPanel createDetailsView() {
            return OfficeFileChooserUI.this.createDetailsView(this.getFileChooser());
        }

        @Override
        public boolean isDirectorySelected() {
            return OfficeFileChooserUI.this.isDirectorySelected();
        }

        @Override
        public File getDirectory() {
            return OfficeFileChooserUI.this.getDirectory();
        }

        @Override
        public Action getChangeToParentDirectoryAction() {
            return OfficeFileChooserUI.this.getChangeToParentDirectoryAction();
        }

        @Override
        public Action getApproveSelectionAction() {
            return OfficeFileChooserUI.this.getApproveSelectionAction();
        }

        @Override
        public Action getNewFolderAction() {
            return OfficeFileChooserUI.this.getNewFolderAction();
        }

        public MouseListener createDoubleClickListener(JList list) {
            return OfficeFileChooserUI.this.createDoubleClickListener(this.getFileChooser(), list);
        }

        @Override
        public ListSelectionListener createListSelectionListener() {
            return OfficeFileChooserUI.this.createListSelectionListener(this.getFileChooser());
        }
    }
}

