/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf;

import com.apple.eawt.Application;
import com.luciad.imageio.webp.WebPImageReaderSpi;
import com.paterva.maltego.util.ui.fonts.FontAAValues;
import com.paterva.maltego.util.ui.laf.MaltegoLAFRefresh;
import com.twelvemonkeys.imageio.plugins.bmp.BMPImageReader;
import com.twelvemonkeys.imageio.plugins.bmp.ICOImageReader;
import com.twelvemonkeys.imageio.plugins.svg.SVGImageReader;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageReader;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.JFrame;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;
import sun.awt.SunToolkit;

public class Installer
extends ModuleInstall {
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());
    static String dtprop = "awt.font.desktophints";
    static Toolkit tk = Toolkit.getDefaultToolkit();
    public static String DESKTOP_HINT_UNAVAILABLE = "Unavailable";

    public void restored() {
        System.setProperty("winsys.stretching_view_tabs", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "false");
        if (Utilities.isMac()) {
            Installer.setupDock();
        }
        this.printDefaultTextAntialiasStatus();
        this.printDesktopTextAntialiasStatus(false);
        this.modifyDesktopTextAntialiasing();
        this.printDesktopTextAntialiasStatus(true);
        this.verifySvgSupport();
        this.verifyWebpSupport();
        this.verifyIcoSupport();
        this.verifyTiffSupport();
        this.verifyTifSupport();
        this.verifyBmpSupport();
        this.verifyJpegSupport();
        this.verifyJpgSupport();
        this.verifyPngSupport();
        this.verifyGifSupport();
        this.installLaf();
    }

    private void verifySvgSupport() {
        LOG.log(Level.INFO, "SVG reader plugin expected: {0}", SVGImageReader.class.toString());
        ImageIO.scanForPlugins();
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("SVG");
        while (readers.hasNext()) {
            LOG.log(Level.INFO, "SVG reader plugin found: {0}", readers.next());
        }
    }

    private void verifyWebpSupport() {
        LOG.log(Level.INFO, "WebP reader plugin expected: {0}", WebPImageReaderSpi.class.toString());
        ImageIO.scanForPlugins();
        Iterator<ImageReader> readers = ImageIO.getImageReadersByMIMEType("image/webp");
        while (readers.hasNext()) {
            LOG.log(Level.INFO, "WebP reader plugin found: {0}", readers.next());
        }
    }

    private void verifyIcoSupport() {
        LOG.log(Level.INFO, "ICO reader plugin expected: {0}", ICOImageReader.class.toString());
        ImageIO.scanForPlugins();
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("ICO");
        while (readers.hasNext()) {
            LOG.log(Level.INFO, "ICO reader plugin found: {0}", readers.next());
        }
    }

    private void verifyTiffSupport() {
        LOG.log(Level.INFO, "TIFF reader plugin expected: {0}", TIFFImageReader.class.toString());
        ImageIO.scanForPlugins();
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("TIFF");
        while (readers.hasNext()) {
            LOG.log(Level.INFO, "TIFF reader plugin found: {0}", readers.next());
        }
    }

    private void verifyTifSupport() {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("TIF");
        ImageIO.scanForPlugins();
        while (readers.hasNext()) {
            LOG.log(Level.INFO, "TIF reader plugin found: {0}", readers.next());
        }
    }

    private void verifyBmpSupport() {
        LOG.log(Level.INFO, "BMP reader plugin expected: {0}", BMPImageReader.class.toString());
        ImageIO.scanForPlugins();
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("BMP");
        while (readers.hasNext()) {
            LOG.log(Level.INFO, "BMP reader plugin found: {0}", readers.next());
        }
    }

    private void verifyJpegSupport() {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JPEG");
        ImageIO.scanForPlugins();
        while (readers.hasNext()) {
            LOG.log(Level.INFO, "JPEG reader plugin found: {0}", readers.next());
        }
    }

    private void verifyJpgSupport() {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JPG");
        ImageIO.scanForPlugins();
        while (readers.hasNext()) {
            LOG.log(Level.INFO, "JPG reader plugin found: {0}", readers.next());
        }
    }

    private void verifyPngSupport() {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("PNG");
        ImageIO.scanForPlugins();
        while (readers.hasNext()) {
            LOG.log(Level.INFO, "PNG reader plugin found: {0}", readers.next());
        }
    }

    private void verifyGifSupport() {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("GIF");
        ImageIO.scanForPlugins();
        while (readers.hasNext()) {
            LOG.log(Level.INFO, "GIF reader plugin found: {0}", readers.next());
        }
    }

    private static void setupDock() {
        Application app = Application.getApplication();
        MenuItem item = new MenuItem("Gather Maltego Window");
        item.addActionListener(e -> {
            JFrame f = (JFrame)WindowManager.getDefault().getMainWindow();
            Installer.gatherMaltegoWindow(-1, f);
            app.requestForeground(true);
        });
        PopupMenu menu = new PopupMenu();
        menu.add(item);
        app.setDockMenu(menu);
    }

    private static void gatherMaltegoWindow(int screen, JFrame frame) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        GraphicsConfiguration config = null;
        if (screen > -1 && screen < gd.length) {
            config = gd[screen].getDefaultConfiguration();
        } else if (gd.length > 0) {
            config = gd[0].getDefaultConfiguration();
        } else {
            throw new RuntimeException("No Screens Found");
        }
        if (config != null) {
            Rectangle bounds = config.getBounds();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(config);
            int x = bounds.x + screenInsets.left;
            int y = bounds.y + screenInsets.top;
            frame.setLocation(x, y);
        }
    }

    private void installLaf() {
        MaltegoLAFRefresh.getDefault().refresh(true);
    }

    private void modifyDesktopTextAntialiasing() {
        Toolkit tkLocal = Toolkit.getDefaultToolkit();
        if (!(tkLocal instanceof SunToolkit)) {
            System.err.println("Not a Sun Toolkit...");
            return;
        }
        try {
            HashMap<Object, Object> hintsMap = (HashMap<Object, Object>)tkLocal.getDesktopProperty("awt.font.desktophints");
            FontAAValues[] aaValues = FontAAValues.getArray();
            String displayName = NbPreferences.forModule(FontAAValues.class).get("fontAntialiasing", aaValues[4].toString());
            RenderingHints newHintsMap = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, ((FontAAValues)FontAAValues.getValue((String)displayName)).getHint());
            newHintsMap.add(new RenderingHints(RenderingHints.KEY_TEXT_LCD_CONTRAST, 100));
            if (hintsMap != null) {
                hintsMap.putAll(newHintsMap);
            } else {
                hintsMap = new HashMap<Object, Object>();
                hintsMap.putAll(newHintsMap);
            }
            Method setDesktopProperty = Toolkit.class.getDeclaredMethod("setDesktopProperty", String.class, Object.class);
            setDesktopProperty.setAccessible(true);
            setDesktopProperty.invoke((Object)tkLocal, "awt.font.desktophints", hintsMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printDefaultTextAntialiasStatus() {
        Object defaultAA = FontAAValues.getValue((Object)RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        LOG.log(Level.INFO, "Default Text Antialias (JRE) = {0}", defaultAA);
    }

    private void printDesktopTextAntialiasStatus(boolean isModified) {
        String statusString = isModified ? "(After" : "(Before";
        statusString = statusString + " modified from preferences)";
        Map hints = (Map)tk.getDesktopProperty(dtprop);
        if (hints != null) {
            Object desktopAA = FontAAValues.getValue(hints.get(RenderingHints.KEY_TEXT_ANTIALIASING));
            LOG.log(Level.INFO, "Desktop Text Antialias (Swing) = {0} {1}", new Object[]{desktopAA, statusString});
        } else {
            LOG.log(Level.INFO, "Desktop Text Antialias (Swing) = {0} {1}", new Object[]{DESKTOP_HINT_UNAVAILABLE, statusString});
        }
    }
}

