/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.serialize;

import com.paterva.graph.store.pandora.PandoraGraphStore;
import com.paterva.graph.store.pandora.data.PandoraGraphDataStore;
import com.paterva.graph.store.pandora.layout.PandoraGraphLayoutStore;
import com.paterva.graph.store.pandora.parts.PandoraPartsStore;
import com.paterva.graph.store.pandora.structure.PandoraGraphStructureStore;
import com.paterva.graph.store.serialize.IndexFileEntryFactory;
import com.paterva.graph.store.serialize.IndexFileUtils;
import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.EntryFactory;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreFactory;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.GraphStoreStats;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.views.collect.CollectionNodeEntry;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.typing.serializer.AttachmentsPathRegistry;
import com.paterva.maltego.ui.graph.imex.GraphStoreSerializer;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.NormalException;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;

public class DefaultGraphStoreSerializer
extends GraphStoreSerializer {
    private static final Logger LOG = Logger.getLogger(DefaultGraphStoreSerializer.class.getName());
    public static final String GRAPH1_NAME = "Graph1";
    public static final String ARCHIVE_PATH_GRAPH = "Graphs/Graph1/";
    private static final String STORE_TYPE_DATA = "Data";
    private static final String STORE_TYPE_STRUCTURE = "Structure";
    private static final String STORE_TYPE_LAYOUT = "Layout";
    private static final String STORE_TYPE_COLLECTION = "Collection";
    private static final String COLLECTION_NODE_PATH = "Graphs/Graph1/Collection";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MaltegoArchiveWriter writer, GraphID graphID) throws GraphStoreException {
        GraphStoreStats.logStats((GraphID)graphID);
        GraphStore store = GraphStoreRegistry.getDefault().forGraphID(graphID);
        if (store instanceof PandoraGraphStore) {
            PandoraGraphStore pandoraStore = (PandoraGraphStore)store;
            try {
                this.checkIntegrity(pandoraStore);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.repairIfInvalid(graphID, store);
                GraphStoreStats.logStats((GraphID)graphID);
            }
            PandoraGraphDataStore dataStore = (PandoraGraphDataStore)pandoraStore.getGraphDataStore();
            PandoraGraphStructureStore structureStore = (PandoraGraphStructureStore)pandoraStore.getGraphStructureStore();
            PandoraGraphLayoutStore layoutStore = (PandoraGraphLayoutStore)pandoraStore.getGraphLayoutStore();
            try {
                this.writeCollectionNodeCache(writer, graphID);
                this.updateAttachmentIDsToPaths(dataStore);
                LOG.info("Closing graph store and writing to file.");
                pandoraStore.close(false);
                this.writeIndexFiles(writer, dataStore, STORE_TYPE_DATA);
                this.writeIndexFiles(writer, structureStore, STORE_TYPE_STRUCTURE);
                this.writeIndexFiles(writer, layoutStore, STORE_TYPE_LAYOUT);
            }
            finally {
                if (!pandoraStore.isOpen()) {
                    LOG.info("Re-opening graph store after save.");
                    pandoraStore.open();
                    this.updateAttachmentPathsToIDs(dataStore);
                    GraphStoreStats.logStats((GraphID)graphID);
                }
            }
        }
    }

    private void writeIndexFiles(MaltegoArchiveWriter writer, PandoraPartsStore partStore, String storeType) throws GraphStoreException {
        String archivePathPrefix = ARCHIVE_PATH_GRAPH + storeType;
        String descriptionPostfix = storeType.toLowerCase() + " index files";
        this.writeIndexFiles(writer, "entity " + descriptionPostfix, partStore.getEntitiesPath(), archivePathPrefix + "Entities");
        this.writeIndexFiles(writer, "link " + descriptionPostfix, partStore.getLinksPath(), archivePathPrefix + "Links");
    }

    private void writeIndexFiles(MaltegoArchiveWriter writer, String displayName, File indexDir, String archiveDir) throws GraphStoreException {
        try {
            this.deleteLockFile(indexDir);
            IndexFileUtils.writeIndexFiles(writer, displayName, indexDir, archiveDir);
        }
        catch (IOException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public GraphStore read(MaltegoArchiveReader reader, GraphID graphID) throws GraphStoreException {
        try {
            GraphStore graphStore = GraphStoreFactory.getDefault().create(graphID, false);
            PandoraGraphDataStore dataStore = (PandoraGraphDataStore)graphStore.getGraphDataStore();
            PandoraGraphStructureStore structureStore = (PandoraGraphStructureStore)graphStore.getGraphStructureStore();
            PandoraGraphLayoutStore layoutStore = (PandoraGraphLayoutStore)graphStore.getGraphLayoutStore();
            this.readIndexFiles(reader, dataStore, STORE_TYPE_DATA);
            this.readIndexFiles(reader, structureStore, STORE_TYPE_STRUCTURE);
            this.readIndexFiles(reader, layoutStore, STORE_TYPE_LAYOUT);
            this.readCollectionNodeCache(reader, graphID);
            graphStore.open();
            this.updateAttachmentPathsToIDs(dataStore);
            GraphStoreStats.logStats((GraphID)graphID);
            this.repairIfInvalid(graphID, graphStore);
            return graphStore;
        }
        catch (IOException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    public GraphStore readData(MaltegoArchiveReader reader, GraphID graphID) throws GraphStoreException {
        try {
            GraphStore graphStore = GraphStoreFactory.getDefault().create(graphID, false);
            PandoraGraphDataStore dataStore = (PandoraGraphDataStore)graphStore.getGraphDataStore();
            this.readIndexFiles(reader, dataStore, STORE_TYPE_DATA);
            graphStore.open();
            return graphStore;
        }
        catch (IOException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    private void readIndexFiles(MaltegoArchiveReader reader, PandoraPartsStore partStore, String storeType) throws GraphStoreException {
        String archivePathPrefix = ARCHIVE_PATH_GRAPH + storeType;
        String descriptionPostfix = storeType.toLowerCase() + " index files";
        this.readParts(reader, "entity " + descriptionPostfix, partStore.getEntitiesPath(), archivePathPrefix + "Entities");
        this.readParts(reader, "link " + descriptionPostfix, partStore.getLinksPath(), archivePathPrefix + "Links");
    }

    private void readParts(MaltegoArchiveReader reader, String description, File indexPath, String archivePath) throws GraphStoreException {
        try {
            DefaultGraphStoreSerializer.makeEmpty(indexPath);
            StatusDisplayer.getDefault().setStatusText("Loading " + description);
            reader.readAll((EntryFactory)new IndexFileEntryFactory(archivePath, indexPath), GRAPH1_NAME);
        }
        catch (IOException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    private static void makeEmpty(File tempDir) {
        FileUtilities.deleteContents((File)tempDir);
        tempDir.mkdirs();
    }

    private void checkIntegrity(PandoraGraphStore pandoraStore) throws GraphStoreException {
        PandoraGraphDataStore dataStore = (PandoraGraphDataStore)pandoraStore.getGraphDataStore();
        PandoraGraphStructureStore structureStore = (PandoraGraphStructureStore)pandoraStore.getGraphStructureStore();
        PandoraGraphLayoutStore layoutStore = (PandoraGraphLayoutStore)pandoraStore.getGraphLayoutStore();
        this.checkIntegrity(dataStore, structureStore, layoutStore);
    }

    private void checkIntegrity(PandoraGraphDataStore dataStore, PandoraGraphStructureStore structureStore, PandoraGraphLayoutStore layoutStore) throws GraphStoreException {
        this.checkIntegrity(dataStore.getDataStoreReader(), structureStore.getStructureReader(), layoutStore.getLayoutReader());
    }

    private void checkIntegrity(GraphDataStoreReader dataStoreReader, GraphStructureReader structureReader, GraphLayoutReader layoutReader) throws GraphStoreException {
        int entityCountData = dataStoreReader.getEntityCount();
        int entityCountStructure = structureReader.getEntityCount();
        int entityCountLayout = layoutReader.getEntityCount();
        if (entityCountData != entityCountStructure || entityCountData != entityCountLayout) {
            StringBuilder sb = new StringBuilder();
            sb.append("data=").append(Integer.toString(entityCountData)).append(";");
            sb.append("structure=").append(Integer.toString(entityCountStructure)).append(";");
            sb.append("layout=").append(Integer.toString(entityCountLayout));
            throw new GraphStoreException("Integrity check: Graph Store entity counts different: " + sb);
        }
        int linkCountData = dataStoreReader.getLinkCount();
        int linkCountStructure = structureReader.getLinkCount();
        int linkCountLayout = layoutReader.getLinkCount();
        if (linkCountData != linkCountStructure || linkCountData != linkCountLayout) {
            StringBuilder sb = new StringBuilder();
            sb.append("data=").append(Integer.toString(linkCountData)).append(";");
            sb.append("structure=").append(Integer.toString(linkCountStructure)).append(";");
            sb.append("layout=").append(Integer.toString(linkCountLayout));
            throw new GraphStoreException("Integrity check: Graph Store link counts different: " + sb);
        }
    }

    private void writeCollectionNodeCache(MaltegoArchiveWriter writer, GraphID graphID) throws GraphStoreException {
        CollectionNodeEntry collectionNodeEntry = new CollectionNodeEntry(graphID, COLLECTION_NODE_PATH);
        try {
            writer.write((Entry)collectionNodeEntry);
        }
        catch (IOException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    private void readCollectionNodeCache(MaltegoArchiveReader reader, GraphID graphID) throws GraphStoreException {
        CollectionNodeEntry collectionNodeEntry = new CollectionNodeEntry(graphID, COLLECTION_NODE_PATH);
        try {
            reader.read((Entry)collectionNodeEntry);
        }
        catch (IOException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }

    private void deleteLockFile(File indexDir) {
        File lockFile = new File(indexDir, "write.lock");
        try {
            if (lockFile.exists()) {
                lockFile.delete();
            }
        }
        catch (Exception ex) {
            NormalException.logStackTrace((Throwable)ex);
        }
    }

    private void updateAttachmentIDsToPaths(PandoraGraphDataStore dataStore) throws GraphStoreException {
        GraphDataStoreWriter dataWriter = dataStore.getDataStoreWriter();
        dataWriter.convertAttachmentIDsToPaths(AttachmentsPathRegistry.getPaths());
    }

    private void updateAttachmentPathsToIDs(PandoraGraphDataStore dataStore) throws GraphStoreException {
        GraphDataStoreWriter dataWriter = dataStore.getDataStoreWriter();
        dataWriter.convertAttachmentPathsToIDs(AttachmentsPathRegistry.getPaths());
    }

    private void repairIfInvalid(GraphID graphID, GraphStore graphStore) throws GraphStoreException {
        GraphDataStoreReader dataStoreReader = graphStore.getGraphDataStore().getDataStoreReader();
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        GraphLayoutReader layoutReader = graphStore.getGraphLayoutStore().getLayoutReader();
        int entityCountData = dataStoreReader.getEntityCount();
        int entityCountStructure = structureReader.getEntityCount();
        int entityCountLayout = layoutReader.getEntityCount();
        if (entityCountData != entityCountStructure || entityCountData != entityCountLayout) {
            Set entityIDsData = dataStoreReader.getEntityIDs();
            Set entityIDsStructure = structureReader.getEntities();
            Set entityIDsLayout = layoutReader.getAllCenters().keySet();
            HashSet allEntities = new HashSet();
            allEntities.addAll(entityIDsData);
            allEntities.addAll(entityIDsStructure);
            allEntities.addAll(entityIDsLayout);
            HashSet commonEntities = new HashSet(allEntities);
            commonEntities.retainAll(entityIDsData);
            commonEntities.retainAll(entityIDsStructure);
            commonEntities.retainAll(entityIDsLayout);
            HashSet missingEntities = allEntities;
            missingEntities.removeAll(commonEntities);
            LOG.log(Level.SEVERE, "Data entity IDs:\n{0}", entityIDsData);
            LOG.log(Level.SEVERE, "Structure entity IDs:\n{0}", entityIDsData);
            LOG.log(Level.SEVERE, "Layout entity IDs:\n{0}", entityIDsData);
            LOG.log(Level.SEVERE, "Removing {0} entities not in all the graph stores.", missingEntities.size());
            GraphStoreWriter.removeEntities((GraphID)graphID, missingEntities);
        }
        int linkCountData = dataStoreReader.getLinkCount();
        int linkCountStructure = structureReader.getLinkCount();
        int linkCountLayout = layoutReader.getLinkCount();
        if (linkCountData != linkCountStructure || linkCountData != linkCountLayout) {
            Set linkIDsData = dataStoreReader.getLinkIDs();
            Set linkIDsStructure = structureReader.getLinks();
            Set linkIDsLayout = layoutReader.getAllPaths().keySet();
            HashSet allLinks = new HashSet();
            allLinks.addAll(linkIDsData);
            allLinks.addAll(linkIDsStructure);
            allLinks.addAll(linkIDsLayout);
            HashSet commonLinks = new HashSet(allLinks);
            commonLinks.retainAll(linkIDsData);
            commonLinks.retainAll(linkIDsStructure);
            commonLinks.retainAll(linkIDsLayout);
            HashSet missingLinks = allLinks;
            missingLinks.removeAll(commonLinks);
            LOG.log(Level.SEVERE, "Removing {0} links not in all the graph stores.", missingLinks.size());
            GraphStoreWriter.removeLinks((GraphID)graphID, missingLinks);
        }
    }
}

