/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora.parts;

import com.paterva.graph.store.pandora.PandoraGraphStoreCache;
import com.paterva.graph.store.pandora.parts.PandoraPartsReader;
import com.paterva.graph.store.pandora.parts.PandoraPartsWriter;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.util.ExceptionUtilities;
import com.pinkmatter.pandora.PandoraConnection;
import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.lucene.PandoraLuceneFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;

public abstract class PandoraPartsStore<Reader extends PandoraPartsReader, Writer extends PandoraPartsWriter> {
    private static final boolean IN_MEMORY = false;
    private final GraphID _id;
    private final File _entitiesPath;
    private final File _linksPath;
    private PandoraConnection _entityConn;
    private PandoraConnection _linkConn;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    public PandoraPartsStore(GraphID id) {
        this._id = id;
        File cacheDir = PandoraGraphStoreCache.get(id);
        this._entitiesPath = new File(cacheDir, this.getEntityStoreName());
        this._linksPath = new File(cacheDir, this.getLinkStoreName());
    }

    protected abstract String getEntityStoreName();

    protected abstract String getLinkStoreName();

    protected abstract Reader getReader();

    protected abstract Writer getWriter();

    public GraphID getGraphID() {
        return this._id;
    }

    public File getEntitiesPath() {
        return this._entitiesPath;
    }

    public File getLinksPath() {
        return this._linksPath;
    }

    public synchronized void open() throws PandoraException {
        PandoraLuceneFactory factory = new PandoraLuceneFactory();
        this._entitiesPath.mkdirs();
        this._linksPath.mkdirs();
        this._entityConn = factory.createFileConnection(this._entitiesPath);
        this._linkConn = factory.createFileConnection(this._linksPath);
        Reader reader = this.getReader();
        ((PandoraPartsReader)reader).setEntityConnection(this._entityConn);
        ((PandoraPartsReader)reader).setLinkConnection(this._linkConn);
        Writer writer = this.getWriter();
        ((PandoraPartsWriter)((Object)writer)).setEntityConnection(this._entityConn);
        ((PandoraPartsWriter)((Object)writer)).setLinkConnection(this._linkConn);
    }

    public synchronized void close() throws PandoraException {
        Reader reader = this.getReader();
        Object writer = this.getWriter();
        ExceptionUtilities.catchAll(() -> writer.commit());
        ExceptionUtilities.catchAll(() -> this._entityConn.close());
        ExceptionUtilities.catchAll(() -> this._linkConn.close());
        this._entityConn = null;
        this._linkConn = null;
        ((PandoraPartsReader)reader).setEntityConnection(null);
        ((PandoraPartsReader)reader).setLinkConnection(null);
        ((PandoraPartsWriter)((Object)writer)).setEntityConnection(null);
        ((PandoraPartsWriter)((Object)writer)).setLinkConnection(null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    protected PropertyChangeSupport getChangeSupport() {
        return this._changeSupport;
    }
}

