/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora;

import com.paterva.graph.store.pandora.PandoraGraphStoreCache;
import com.paterva.graph.store.pandora.data.PandoraGraphDataStore;
import com.paterva.graph.store.pandora.layout.PandoraGraphLayoutStore;
import com.paterva.graph.store.pandora.structure.PandoraGraphStructureStore;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.AbstractGraphStore;
import com.paterva.maltego.graph.store.data.GraphDataStore;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutStore;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.util.ExceptionUtilities;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PandoraGraphStore
extends AbstractGraphStore {
    private static final Logger LOG = Logger.getLogger(PandoraGraphStore.class.getName());
    private final GraphID _id;
    private final PandoraGraphDataStore _dataStore;
    private final PandoraGraphStructureStore _structureStore;
    private final PandoraGraphLayoutStore _layoutStore;

    public PandoraGraphStore(GraphID id) throws Exception {
        super(true);
        this._id = id;
        this._dataStore = new PandoraGraphDataStore(this._id);
        this._structureStore = new PandoraGraphStructureStore(this._id, this._dataStore);
        this._layoutStore = new PandoraGraphLayoutStore(this._id);
        LOG.log(Level.FINE, "Created: {0}", id);
    }

    public boolean isInMemory() {
        return false;
    }

    public void open() throws GraphStoreException {
        try {
            this._dataStore.open();
            this._structureStore.open();
            this._layoutStore.open();
            super.open();
            LOG.log(Level.FINE, "Opened: {0}", this._id);
        }
        catch (Exception ex) {
            throw new GraphStoreException("Error while opening graph store with id " + this._id, (Throwable)ex);
        }
    }

    public void close(boolean clearCache) {
        LOG.log(Level.FINE, "Closing: {0}", this._id);
        ExceptionUtilities.catchAll(() -> super.close(clearCache));
        ExceptionUtilities.catchAll(() -> this._layoutStore.close());
        ExceptionUtilities.catchAll(() -> this._structureStore.close());
        ExceptionUtilities.catchAll(() -> this._dataStore.close());
        ExceptionUtilities.catchAll(() -> {
            if (clearCache) {
                PandoraGraphStoreCache.clear(this._id);
            }
        });
        LOG.log(Level.FINE, "Closed: {0}", this._id);
    }

    public synchronized GraphDataStore getGraphDataStore() {
        return this._dataStore;
    }

    public GraphStructureStore getGraphStructureStore() {
        return this._structureStore;
    }

    public GraphLayoutStore getGraphLayoutStore() {
        return this._layoutStore;
    }
}

