/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.serializers.map.PartMapReader;
import com.paterva.maltego.serializers.map.PartMapWriter;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.actions.ClearAllAction;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.util.SimilarStrings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.util.Exceptions;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import y.base.Graph;
import y.view.Graph2D;

public class PartMapDebugAction
implements ActionListener {
    private boolean _addDefaults = true;

    @Override
    public void actionPerformed(ActionEvent e) {
        GraphID graphID = this.getTopGraphID();
        if (graphID != null) {
            Graph2D graph = GraphViewManager.getDefault().getViewGraph(graphID);
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                PartMapWriter writer = new PartMapWriter();
                Set entities = GraphStoreHelper.getMaltegoEntities((Graph)graph);
                EntityRegistry entityRegistry = EntityRegistry.forGraph((Graph)graph);
                List entityMaps = writer.toMaps((Collection)entities, this._addDefaults);
                System.out.println("entityMaps = " + gson.toJson((Object)entityMaps));
                Set links = GraphStoreHelper.getMaltegoLinks((Graph)graph);
                LinkRegistry linkRegistry = LinkRegistry.forGraph((Graph)graph);
                List linkMaps = writer.toMaps((Collection)links, this._addDefaults);
                System.out.println("linkMaps = " + gson.toJson((Object)linkMaps));
                this._addDefaults = !this._addDefaults;
                Map connectionIDs = null;
                PartMapReader reader = new PartMapReader();
                EntityFactory entityFactory = EntityFactory.forGraphID((GraphID)graphID);
                LinkFactory linkFactory = LinkFactory.forGraphID((GraphID)graphID);
                Set entitiesFromMaps = reader.fromMaps(entityRegistry, entityFactory, (Collection)entityMaps);
                Set linksFromMaps = reader.fromMaps(linkRegistry, linkFactory, (Collection)linkMaps);
                HashMap connections = new HashMap();
                for (MaltegoLink link : linksFromMaps) {
                    connections.put(link, connectionIDs.get(link.getID()));
                }
                this.checkIsCopies(entities, entitiesFromMaps);
                this.checkIsCopies(links, linksFromMaps);
                ((ClearAllAction)SystemAction.get(ClearAllAction.class)).actionPerformed(null);
                GraphTransaction transaction = GraphTransactions.addEntitiesAndLinks((Collection)entitiesFromMaps, connections, (Map)Collections.EMPTY_MAP, (boolean)true, (boolean)true);
                SimilarStrings description = new SimilarStrings("toets");
                GraphTransactorRegistry.getDefault().get(graphID).doTransactions(new GraphTransactionBatch(description, true, new GraphTransaction[]{transaction}));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private <Part extends MaltegoPart> void checkIsCopies(Set<Part> parts, Set<Part> partsFromMaps) throws IllegalStateException {
        for (MaltegoPart part : parts) {
            boolean found = false;
            for (MaltegoPart partFromMap : partsFromMaps) {
                if (!part.getID().equals((Object)partFromMap.getID())) continue;
                found = true;
                if (partFromMap.isCopy(part)) continue;
                throw new IllegalStateException("Parts not equal for id: " + part.getID());
            }
            if (found) continue;
            throw new IllegalStateException("Entity missing with id: " + part.getID());
        }
    }

    private GraphID getTopGraphID() {
        GraphCookie graphCookie;
        TopComponent topmost = GraphEditorRegistry.getDefault().getTopmost();
        if (topmost != null && (graphCookie = (GraphCookie)topmost.getLookup().lookup(GraphCookie.class)) != null) {
            return graphCookie.getGraphID();
        }
        return null;
    }
}

