/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.util.Animator;
import com.bulenkov.iconloader.util.ColorUtil;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class DarculaScrollBarUI
extends BasicScrollBarUI {
    private static final BasicStroke BORDER_STROKE = new BasicStroke();
    private final AdjustmentListener myAdjustmentListener = new AdjustmentListener(){

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            DarculaScrollBarUI.this.resetAnimator();
        }
    };
    private final MouseMotionAdapter myMouseMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            boolean inside = DarculaScrollBarUI.this.isOverThumb(e.getPoint());
            if (inside != DarculaScrollBarUI.this.myMouseIsOverThumb) {
                DarculaScrollBarUI.this.myMouseIsOverThumb = inside;
                DarculaScrollBarUI.this.resetAnimator();
            }
        }
    };
    private final MouseAdapter myMouseListener = new MouseAdapter(){

        @Override
        public void mouseExited(MouseEvent e) {
            if (DarculaScrollBarUI.this.myMouseIsOverThumb) {
                DarculaScrollBarUI.this.myMouseIsOverThumb = false;
                DarculaScrollBarUI.this.resetAnimator();
            }
        }
    };
    private Animator myAnimator;
    private int myAnimationColorShift = 0;
    private boolean myMouseIsOverThumb = false;
    public static final int DELAY_FRAMES = 2;
    public static final int FRAMES_COUNT = 12;

    public static ComponentUI createUI(JComponent c) {
        return new DarculaScrollBarUI();
    }

    public static Color getGradientLightColor() {
        return UIManager.getLookAndFeelDefaults().getColor("ScrollBar.darculaMod.GradientLightColor");
    }

    public static Color getGradientDarkColor() {
        return UIManager.getLookAndFeelDefaults().getColor("ScrollBar.darculaMod.GradientDarkColor");
    }

    public static Color getTrackBackground() {
        return UIManager.getLookAndFeelDefaults().getColor("ScrollBar.darculaMod.TrackBackgroundColor");
    }

    private static int getAnimationColorShift() {
        return UIUtil.isUnderDarcula() ? 20 : 40;
    }

    protected DarculaScrollBarUI() {
    }

    @Override
    public void layoutContainer(Container scrollbarContainer) {
        try {
            super.layoutContainer(scrollbarContainer);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    protected BasicScrollBarUI.ModelListener createModelListener() {
        return new BasicScrollBarUI.ModelListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DarculaScrollBarUI.this.scrollbar != null) {
                    super.stateChanged(e);
                }
            }
        };
    }

    public int getDecrementButtonHeight() {
        return this.decrButton.getHeight();
    }

    public int getIncrementButtonHeight() {
        return this.incrButton.getHeight();
    }

    private void resetAnimator() {
        this.myAnimator.reset();
        if (this.scrollbar != null && this.scrollbar.getValueIsAdjusting() || this.myMouseIsOverThumb) {
            this.myAnimator.suspend();
            this.myAnimationColorShift = DarculaScrollBarUI.getAnimationColorShift();
        } else {
            this.myAnimator.resume();
        }
    }

    public static BasicScrollBarUI createNormal() {
        return new DarculaScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.scrollbar.setFocusable(false);
    }

    @Override
    protected void installDefaults() {
        int incGap = UIManager.getLookAndFeelDefaults().getInt("ScrollBar.incrementButtonGap");
        int decGap = UIManager.getLookAndFeelDefaults().getInt("ScrollBar.decrementButtonGap");
        try {
            UIManager.getLookAndFeelDefaults().put("ScrollBar.incrementButtonGap", (Object)0);
            UIManager.getLookAndFeelDefaults().put("ScrollBar.decrementButtonGap", (Object)0);
            super.installDefaults();
        }
        finally {
            UIManager.getLookAndFeelDefaults().put("ScrollBar.incrementButtonGap", (Object)incGap);
            UIManager.getLookAndFeelDefaults().put("ScrollBar.decrementButtonGap", (Object)decGap);
        }
    }

    @Override
    protected void installListeners() {
        if (this.myAnimator == null || this.myAnimator.isDisposed()) {
            this.myAnimator = this.createAnimator();
        }
        super.installListeners();
        this.scrollbar.addAdjustmentListener(this.myAdjustmentListener);
        this.scrollbar.addMouseListener(this.myMouseListener);
        this.scrollbar.addMouseMotionListener(this.myMouseMotionListener);
    }

    private Animator createAnimator() {
        return new Animator("Adjustment fadeout", 12, 600, false){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                DarculaScrollBarUI.this.myAnimationColorShift = DarculaScrollBarUI.getAnimationColorShift();
                if (frame > 2) {
                    DarculaScrollBarUI.this.myAnimationColorShift = (int)((double)DarculaScrollBarUI.this.myAnimationColorShift * (1.0 - (double)(frame - 2) / (double)(totalFrames - 2)));
                }
                if (DarculaScrollBarUI.this.scrollbar != null) {
                    DarculaScrollBarUI.this.scrollbar.repaint(((DarculaScrollBarUI)DarculaScrollBarUI.this.scrollbar.getUI()).getThumbBounds());
                }
            }
        };
    }

    private boolean isOverThumb(Point p) {
        Rectangle bounds = this.getThumbBounds();
        return bounds != null && bounds.contains(p);
    }

    @Override
    public Rectangle getThumbBounds() {
        return super.getThumbBounds();
    }

    @Override
    protected void uninstallListeners() {
        if (this.scrollTimer != null) {
            super.uninstallListeners();
        }
        this.scrollbar.removeAdjustmentListener(this.myAdjustmentListener);
        this.myAnimator.dispose();
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle bounds) {
        g.setColor(DarculaScrollBarUI.getTrackBackground());
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        int thickness = this.getThickness();
        return this.isVertical() ? new Dimension(thickness, thickness * 2) : new Dimension(thickness * 2, thickness);
    }

    protected int getThickness() {
        int thickness = UIManager.getLookAndFeelDefaults().getInt("ScrollBar.darculaMod.Thickness");
        if (thickness == 0) {
            thickness = 13;
        }
        return thickness;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        int thickness = this.getThickness();
        return new Dimension(thickness, thickness);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        g.translate(thumbBounds.x, thumbBounds.y);
        this.paintMaxiThumb((Graphics2D)g, thumbBounds);
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    private void paintMaxiThumb(Graphics2D g, Rectangle thumbBounds) {
        boolean vertical = this.isVertical();
        int hGap = 0;
        int vGap = 0;
        int w = this.adjustThumbWidth(thumbBounds.width - hGap * 2);
        int h = thumbBounds.height - vGap * 2;
        Color start = this.adjustColor(DarculaScrollBarUI.getGradientLightColor());
        Color end = this.adjustColor(DarculaScrollBarUI.getGradientDarkColor());
        GradientPaint paint = vertical ? new GradientPaint(1.0f, 0.0f, start, w + 1, 0.0f, end) : new GradientPaint(0.0f, 1.0f, start, 0.0f, h + 1, end);
        g.setPaint(paint);
        g.fillRect(hGap, vGap, w, h);
    }

    @Override
    public boolean getSupportsAbsolutePositioning() {
        return true;
    }

    protected int adjustThumbWidth(int width) {
        return width;
    }

    protected Color adjustColor(Color c) {
        if (this.myAnimationColorShift == 0) {
            return c;
        }
        int sign = UIManager.getLookAndFeelDefaults().getBoolean("ScrollBar.darculaMod.HoverLighter") ? 1 : -1;
        return ColorUtil.shift(c, Math.min(1.2, 1.0 + (double)sign * ((double)this.myAnimationColorShift / 100.0)));
    }

    private boolean isVertical() {
        return this.scrollbar.getOrientation() == 1;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new EmptyButton();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new EmptyButton();
    }

    private static class EmptyButton
    extends JButton {
        private EmptyButton() {
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMaximumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getMaximumSize();
        }
    }
}

