/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.descriptor;

import com.paterva.maltego.typing.descriptor.RegistryEvent;
import com.paterva.maltego.typing.descriptor.RegistryListener;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.util.NamedThreadFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;

public abstract class SpecRegistry<T extends TypeSpec> {
    private final Collection<RegistryListener<T>> _listeners = Collections.synchronizedCollection(new LinkedList());
    private final ExecutorService _asyncExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("SpecRegistry Async"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegistryListener(RegistryListener<T> listener) {
        Collection<RegistryListener<T>> collection = this._listeners;
        synchronized (collection) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegistryListener(RegistryListener<T> listener) {
        Collection<RegistryListener<T>> collection = this._listeners;
        synchronized (collection) {
            this._listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTypeAdded(T spec) {
        Collection<RegistryListener<T>> collection = this._listeners;
        synchronized (collection) {
            RegistryEvent<T> evt = new RegistryEvent<T>(this, spec);
            for (RegistryListener<T> l : this._listeners) {
                l.typeAdded(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTypeRemoved(T spec) {
        Collection<RegistryListener<T>> collection = this._listeners;
        synchronized (collection) {
            RegistryEvent<T> evt = new RegistryEvent<T>(this, spec);
            for (RegistryListener<T> l : this._listeners) {
                l.typeRemoved(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTypeUpdated(T spec) {
        Collection<RegistryListener<T>> collection = this._listeners;
        synchronized (collection) {
            RegistryEvent<T> evt = new RegistryEvent<T>(this, spec);
            for (RegistryListener<T> l : this._listeners) {
                l.typeUpdated(evt);
            }
        }
    }

    public abstract void reloadEntities();

    public abstract T get(String var1);

    public void getAsync(String typeName, Consumer<T> consumer) {
        this._asyncExecutor.submit(() -> {
            T spec = this.get(typeName);
            consumer.accept(spec);
        });
    }

    public abstract Collection<T> getAll();

    public abstract void put(T var1);

    public abstract void put(T var1, String var2);

    public abstract void remove(String var1);

    public abstract boolean contains(String var1);

    public abstract String[] allCategories();

    public Collection<T> getAllVisible() {
        Collection<T> all = this.getAll();
        ArrayList<TypeSpec> visible = new ArrayList<TypeSpec>();
        for (TypeSpec t : all) {
            if (!t.isVisible()) continue;
            visible.add(t);
        }
        return visible;
    }

    public static class Memory<T extends TypeSpec>
    extends SpecRegistry<T> {
        private static final String DEFAULT_FOLDER = "Miscellaneous";
        private final HashMap<String, T> _items = new HashMap();
        private final HashMap<String, String> _folders = new HashMap();

        public Memory() {
        }

        public Memory(Collection<T> specs) {
            for (TypeSpec t : specs) {
                this.put(t);
            }
        }

        public Memory(T[] specs) {
            for (T t : specs) {
                this.put(t);
            }
        }

        @Override
        public void reloadEntities() {
        }

        @Override
        public T get(String typeName) {
            return (T)((TypeSpec)this._items.get(typeName));
        }

        @Override
        public Collection<T> getAll() {
            return this._items.values();
        }

        @Override
        public void put(T spec) {
            this.put(spec, ((TypeSpec)spec).getDefaultCategory());
        }

        @Override
        public void put(T spec, String category) {
            if (category == null) {
                category = DEFAULT_FOLDER;
            }
            this._items.put(((TypeSpec)spec).getTypeName(), spec);
            this._folders.put(((TypeSpec)spec).getTypeName(), category);
            this.fireTypeAdded(spec);
        }

        @Override
        public void remove(String typeName) {
            T spec = this.get(typeName);
            if (spec != null) {
                this._items.remove(typeName);
                this.fireTypeRemoved(spec);
            }
        }

        @Override
        public boolean contains(String typeName) {
            return this._items.containsKey(typeName);
        }

        @Override
        public String[] allCategories() {
            return this._folders.values().toArray(new String[this._folders.size()]);
        }
    }
}

