/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.mtgx.imex;

import com.paterva.entity.serializer.MaltegoEntityEntry;
import com.paterva.entity.serializer.MaltegoEntityEntryFactory;
import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.EntryFactory;
import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.archive.mtz.MtzVersion;
import com.paterva.maltego.archive.mtz.MtzVersionEntry;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.customicons.imex.CategorizedIcons;
import com.paterva.maltego.customicons.imex.IconImporter;
import com.paterva.maltego.customicons.imex.IconMetadata;
import com.paterva.maltego.customicons.imex.IconMetadataEntry;
import com.paterva.maltego.customicons.imex.IconRegistryIcon;
import com.paterva.maltego.customicons.imex.IconRegistryIconEntry;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.metadata.GraphMetadata;
import com.paterva.maltego.graph.metadata.GraphMetadataManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.imgfactory.imex.ImageCacheFileEntry;
import com.paterva.maltego.imgfactory.imex.ImageCacheFileEntryFactory;
import com.paterva.maltego.imgfactory.imex.ImageCacheIndexEntry;
import com.paterva.maltego.imgfactory.imex.ImageCacheIndexEntryFactory;
import com.paterva.maltego.imgfactory.serialization.CachedImage;
import com.paterva.maltego.imgfactory.serialization.ImageCacheIndex;
import com.paterva.maltego.imgfactory.serialization.ImageCacheSerializer;
import com.paterva.maltego.imgfactoryapi.GraphIconRegistry;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.ImageCache;
import com.paterva.maltego.imgfactoryapi.MemoryIconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.VirtualIcon;
import com.paterva.maltego.mtgx.imex.FileStoreFileEntry;
import com.paterva.maltego.mtgx.imex.FileStoreID;
import com.paterva.maltego.mtgx.imex.FileStoreReader;
import com.paterva.maltego.mtgx.imex.MaltegoGraphEntry;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.typing.serializer.AttachmentsPathRegistry;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.ui.graph.imex.GraphStoreSerializer;
import com.paterva.maltego.ui.graph.metadata.DefaultGraphMetadataManager;
import com.paterva.maltego.ui.graph.metadata.GraphMetadataEntry;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.IconSize;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.UserCancelException;
import y.base.Graph;
import y.view.Graph2D;

public class MtgxSerializer {
    private static final Logger LOG = Logger.getLogger(MtgxSerializer.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGraph(GraphID graphID, File file, String password, GraphFileType fileType) throws IOException {
        long time = System.currentTimeMillis();
        LOG.log(Level.INFO, "Opening graph {0}", file.getName());
        AttachmentsPathRegistry.lock();
        Map oldPaths = AttachmentsPathRegistry.getPaths();
        try {
            String graphName = "Graph1";
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file);
                if (!zipFile.isValidZipFile()) {
                    throw new IOException("Invalid Maltego graph file.");
                }
                if (zipFile.isEncrypted()) {
                    zipFile.setPassword(password);
                }
            }
            catch (ZipException ex) {
                throw new IOException(ex);
            }
            MaltegoArchiveReader reader = new MaltegoArchiveReader(zipFile);
            MtzVersion version = (MtzVersion)reader.read((Entry)new MtzVersionEntry());
            if (!MtzVersion.isMtzVersionSupported((MtzVersion)version)) {
                String error = "The version of the file (" + MtzVersion.getMtzVersion((MtzVersion)version) + ") is newer than what is supported (" + MtzVersion.getMtzVersion((MtzVersion)MtzVersion.getCurrent()) + "). Please update your Maltego client and try again.";
                throw new IOException(error);
            }
            if (!MtzVersion.isGraphVersionSupported((MtzVersion)version)) {
                String error = "The version of the graph (" + MtzVersion.getGraphVersion((MtzVersion)version) + ") is newer than what is supported (" + MtzVersion.getGraphVersion((MtzVersion)MtzVersion.getCurrent()) + "). Please update your Maltego client and try again.";
                throw new IOException(error);
            }
            HashMap<Integer, String> paths = FileStoreReader.readPaths(reader, graphName);
            AttachmentsPathRegistry.setPaths(paths);
            List indexes = reader.readAll((EntryFactory)new ImageCacheIndexEntryFactory(), graphName);
            List images = reader.readAll((EntryFactory)new ImageCacheFileEntryFactory(), graphName);
            this.updateImageCache(indexes, images);
            IconImporter iconImporter = new IconImporter();
            CategorizedIcons icons = iconImporter.readIcons(reader);
            MemoryIconRegistry localIconRegistry = new MemoryIconRegistry();
            iconImporter.apply((IconRegistry)localIconRegistry, icons, null);
            GraphIconRegistry graphIconRegistry = new GraphIconRegistry(localIconRegistry);
            List specList = reader.readAll((EntryFactory)new MaltegoEntityEntryFactory(), graphName);
            MaltegoEntitySpec[] specs = specList.toArray(new MaltegoEntitySpec[specList.size()]);
            EntityRegistry defaultRegistry = EntityRegistry.getDefault();
            ArrayList<MaltegoEntitySpec> newSpecs = new ArrayList<MaltegoEntitySpec>();
            for (MaltegoEntitySpec spec : specs) {
                if (defaultRegistry.contains(spec.getTypeName())) continue;
                newSpecs.add(spec);
            }
            if (!newSpecs.isEmpty()) {
                SwingUtilities.invokeLater(() -> {
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)"The graph contains unknown entities. Do you want to import them so that you can use them in other graphs as well?", "New Entities", 0);
                    if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                        for (MaltegoEntitySpec spec : newSpecs) {
                            defaultRegistry.put((TypeSpec)spec, spec.getDefaultCategory());
                        }
                    }
                });
            }
            EntityRegistry.Memory localRegistry = new EntityRegistry.Memory(specs);
            EntityRegistry.Proxy proxy = new EntityRegistry.Proxy(new EntityRegistry[]{localRegistry, defaultRegistry});
            proxy.setWriteDelegate((EntityRegistry)localRegistry);
            EntityFactory.Registry factory = new EntityFactory.Registry((EntityRegistry)proxy);
            LinkRegistry.Composite linkRegistry = new LinkRegistry.Composite(new LinkRegistry[]{new LinkRegistry.Memory(), LinkRegistry.getDefault()});
            try {
                FileHeader fileHeader = zipFile.getFileHeader("Graphs/Graph1.graphml");
                fileType = fileHeader != null ? GraphFileType.GRAPHML : GraphFileType.PANDORA;
            }
            catch (ZipException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (GraphFileType.GRAPHML.equals((Object)fileType)) {
                this.readGraph(graphID, reader, graphName, (EntityFactory)factory, (EntityRegistry)proxy, (LinkRegistry)linkRegistry, (IconRegistry)graphIconRegistry);
            } else {
                EntityRegistry.associate((GraphID)graphID, (EntityRegistry)proxy);
                LinkRegistry.associate((GraphID)graphID, (LinkRegistry)linkRegistry);
                IconRegistry.associate((GraphID)graphID, (IconRegistry)graphIconRegistry);
                GraphStoreSerializer.getDefault().read(reader, graphID);
            }
            GraphMetadata metadata = (GraphMetadata)reader.read((Entry)new GraphMetadataEntry(graphName));
            if (metadata != null) {
                GraphMetadataManager.getDefault().set(graphID, metadata);
            }
        }
        finally {
            AttachmentsPathRegistry.setPaths((Map)oldPaths);
            AttachmentsPathRegistry.unlock();
            LOG.log(Level.INFO, "Done opening graph ({0}s)", (double)(System.currentTimeMillis() - time) / 1000.0);
            StatusDisplayer.getDefault().setStatusText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGraph(GraphID graphID, FileObject fileObject, String password, GraphFileType fileType) throws IOException {
        File tempFile = null;
        try {
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file == null) {
                file = tempFile = this.createTempFile(fileObject);
            }
            this.loadGraph(graphID, file, password, fileType);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    public void readGraph(GraphID graphID, MaltegoArchiveReader reader, String graphName, EntityFactory factory, EntityRegistry entityRegistry, LinkRegistry linkRegistry, IconRegistry iconRegistry) throws IOException {
        String path = "Graphs/" + graphName + "." + "graphml";
        MaltegoGraphEntry entry = new MaltegoGraphEntry(path, graphID);
        entry.setEntityFactory(factory);
        entry.setEntityRegistry(entityRegistry);
        entry.setLinkRegistry(linkRegistry);
        entry.setIconRegistry(iconRegistry);
        reader.read((Entry)entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFile(FileObject fileObject) throws IOException {
        File tempFile = null;
        FileOutputStream tempOS = null;
        InputStream is = null;
        try {
            tempFile = File.createTempFile(GraphFileType.GRAPHML.getExtension(), null);
            tempOS = new FileOutputStream(tempFile);
            is = fileObject.getInputStream();
            FileUtil.copy((InputStream)is, (OutputStream)tempOS);
        }
        finally {
            if (tempOS != null) {
                tempOS.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return tempFile;
    }

    private void updateImageCache(List<ImageCacheIndex> indexes, List<CachedImage> images) {
        ImageCache cache = ImageCache.getDefault();
        for (ImageCacheIndex index : indexes) {
            for (CachedImage image : images) {
                FastURL fastURL;
                if (index == null || image == null || !index.getName().equals(image.getCacheName()) || (fastURL = (FastURL)index.get((Object)image.getId())) == null) continue;
                cache.addImage((Object)fastURL, image.getImage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(GraphID graphID, MaltegoArchiveWriter writer, ProgressHandle handle, AtomicBoolean cancelled, GraphFileType fileType) throws IOException {
        long time = System.currentTimeMillis();
        LOG.fine("Save graph - start");
        AttachmentsPathRegistry.lock();
        Map oldPaths = AttachmentsPathRegistry.getPaths();
        try {
            String GRAPH_NAME = "Graph1";
            Graph2D graph = GraphViewManager.getDefault().getViewGraph(graphID);
            int progress = 0;
            Set<Attachments> attss = this.getAttachments(graphID);
            ImageCacheIndex index = null;
            if (ImageCacheSerializer.isEnabled()) {
                index = this.getImageCacheIndex("Graph1", (Graph)graph);
            }
            if (handle != null) {
                handle.progress("Preparing to save...");
                int attCount = 0;
                for (Attachments atts : attss) {
                    attCount += atts.size() * 2;
                }
                int graphCount = 1;
                int entitiesCount = 1;
                int cacheCount = index != null ? index.size() : 0;
                handle.switchToDeterminate(attCount + graphCount + entitiesCount + cacheCount);
            }
            HashMap<Integer, String> paths = new HashMap<Integer, String>();
            ArrayList filenames = new ArrayList();
            for (Attachments atts : attss) {
                for (Attachment att : atts) {
                    int id = att.getId();
                    String string = att.getFileName();
                    int subFolderNum = -1;
                    do {
                        if (filenames.size() > ++subFolderNum) continue;
                        filenames.add(new HashSet());
                    } while (((Set)filenames.get(subFolderNum)).contains(string));
                    ((Set)filenames.get(subFolderNum)).add(string);
                    String attSubfolder = "";
                    String entrySubfolder = "/Graph1";
                    if (subFolderNum > 0) {
                        String numStr = Integer.toString(subFolderNum);
                        entrySubfolder = entrySubfolder + "/" + numStr;
                        attSubfolder = numStr + "/";
                    }
                    String path = attSubfolder + string;
                    LOG.log(Level.FINE, "Attachment: {0} -> {1}", new Object[]{id, path});
                    paths.put(id, path);
                    FileStoreID data = new FileStoreID(id, entrySubfolder, string);
                    this.updateProgress(handle, "Saving attachments - " + string, progress, cancelled);
                    progress += 2;
                    writer.write((Entry)new FileStoreFileEntry(data));
                }
            }
            AttachmentsPathRegistry.setPaths(paths);
            this.updateProgress(handle, "Saving graph", progress++, cancelled);
            if (GraphFileType.GRAPHML.equals((Object)fileType)) {
                writer.write((Entry)new MaltegoGraphEntry(graphID, "Graph1"));
            } else {
                GraphStoreSerializer.getDefault().write(writer, graphID);
            }
            GraphMetadata metadata = DefaultGraphMetadataManager.getDefault().get(graphID);
            metadata.setModified(new Date());
            writer.write((Entry)new GraphMetadataEntry(metadata, "Graph1"));
            this.updateProgress(handle, "Saving entities", progress++, cancelled);
            EntityRegistry registry = EntityRegistry.forGraph((Graph)graph);
            Set<String> uniqueEntityTypes = this.getUniqueEntityTypes(graphID);
            uniqueEntityTypes = this.appendInheritedEntityTypes(registry, uniqueEntityTypes);
            HashSet<MaltegoEntitySpec> specs = new HashSet<MaltegoEntitySpec>();
            for (String string : uniqueEntityTypes) {
                MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(string);
                if (spec == null) continue;
                specs.add(spec);
            }
            for (MaltegoEntitySpec maltegoEntitySpec : specs) {
                writer.write((Entry)new MaltegoEntityEntry(maltegoEntitySpec));
            }
            HashSet<String> uniqueIconNames = new HashSet<String>();
            for (MaltegoEntitySpec spec : specs) {
                String largeIconResource;
                String smallIconResource = spec.getSmallIconResource();
                if (smallIconResource != null) {
                    uniqueIconNames.add(smallIconResource);
                }
                if ((largeIconResource = spec.getLargeIconResource()) == null) continue;
                uniqueIconNames.add(largeIconResource);
            }
            IconRegistry iconRegistry = IconRegistry.forGraphID((GraphID)graphID);
            for (String iconResourceName : uniqueIconNames) {
                RegistryIcon registryIcon = VirtualIcon.parse((String)iconResourceName).flatMap(arg_0 -> ((IconRegistry)iconRegistry).findRegistryIcon(arg_0)).orElse(null);
                if (registryIcon == null) continue;
                String category = registryIcon.getCategory();
                String name = registryIcon.getName();
                Map images = iconRegistry.loadImages(registryIcon);
                for (Map.Entry entry : images.entrySet()) {
                    IconRegistryIcon icon = new IconRegistryIcon(category, name, (IconSize)entry.getKey(), (Image)entry.getValue());
                    writer.write((Entry)new IconRegistryIconEntry(icon));
                }
                IconMetadata iconMetadata = new IconMetadata(registryIcon);
                IconMetadataEntry iconMetadataEntry = new IconMetadataEntry(iconMetadata);
                writer.write((Entry)iconMetadataEntry);
            }
            if (index != null && !index.isEmpty()) {
                writer.write((Entry)new ImageCacheIndexEntry(index));
                ImageCache cache = ImageCache.getDefault();
                for (Map.Entry entry : index.entrySet()) {
                    String cacheName = index.getName();
                    int id = (Integer)entry.getKey();
                    Image img = cache.getImage(graphID, entry.getValue(), null);
                    CachedImage cachedImage = new CachedImage(cacheName, id, img);
                    this.updateProgress(handle, "Saving entity images - " + entry.getValue(), progress++, cancelled);
                    writer.write((Entry)new ImageCacheFileEntry(cachedImage));
                }
            }
            this.updateProgress(handle, "Done", progress, cancelled);
        }
        finally {
            AttachmentsPathRegistry.setPaths((Map)oldPaths);
            AttachmentsPathRegistry.unlock();
            writer.close();
        }
        LOG.log(Level.FINE, "Save graph - end ({0}s)", (double)(System.currentTimeMillis() - time) / 1000.0);
    }

    private void updateProgress(ProgressHandle handle, String progressStr, int progress, AtomicBoolean cancelled) throws UserCancelException {
        if (handle != null) {
            handle.progress(progressStr, progress);
            if (cancelled.get()) {
                throw new UserCancelException("Cancelled");
            }
        }
    }

    private Set<String> getUniqueEntityTypes(GraphID graphID) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
        return dataReader.getEntityTypes();
    }

    private Set<String> appendInheritedEntityTypes(EntityRegistry registry, Set<String> types) {
        HashSet<String> newTypes = new HashSet<String>();
        for (String type : types) {
            List inheritancedTypes = InheritanceHelper.getInheritanceList((SpecRegistry)registry, (String)type);
            newTypes.addAll(inheritancedTypes);
        }
        newTypes.addAll(types);
        newTypes.remove("maltego.Unknown");
        return newTypes;
    }

    private ImageCacheIndex getImageCacheIndex(String name, Graph graph) {
        ImageCacheIndex index = new ImageCacheIndex(name);
        Integer count = 0;
        for (FastURL fastURL : this.getCachedImageUrls(graph)) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            index.put((Object)n, (Object)fastURL);
        }
        return index;
    }

    private Set<FastURL> getCachedImageUrls(Graph graph) {
        ImageCache cache = ImageCache.getDefault();
        EntityRegistry registry = EntityRegistry.forGraph((Graph)graph);
        HashSet<FastURL> urls = new HashSet<FastURL>();
        Set entities = GraphStoreHelper.getMaltegoEntities((Graph)graph);
        for (MaltegoEntity entity : entities) {
            Object image = InheritanceHelper.getImageKey((EntityRegistry)registry, (MaltegoEntity)entity).orElse(null);
            if (!(image instanceof FastURL) || !cache.contains(image)) continue;
            urls.add(image);
        }
        return urls;
    }

    private Set<Attachments> getAttachments(GraphID graphID) {
        HashSet<Attachments> atts = new HashSet<Attachments>();
        Collection entities = GraphStoreHelper.getMaltegoEntitiesWithAttachments((GraphID)graphID);
        for (MaltegoEntity entity : entities) {
            this.addAttachments((MaltegoPart)entity, atts);
        }
        Collection links = GraphStoreHelper.getMaltegoLinksWithAttachments((GraphID)graphID);
        for (MaltegoLink link : links) {
            this.addAttachments((MaltegoPart)link, atts);
        }
        return atts;
    }

    private void addAttachments(MaltegoPart part, Set<Attachments> atts) {
        PropertyDescriptorCollection properties = part.getProperties();
        for (PropertyDescriptor pd : properties) {
            Object value;
            if (!Attachments.class.equals((Object)pd.getType()) || !((value = part.getValue(pd)) instanceof Attachments)) continue;
            atts.add((Attachments)value);
        }
    }
}

