/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.oauth;

import com.github.scribejava.core.model.OAuth1Token;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import com.paterva.maltego.pws.api.OAuthAuthenticator;
import com.paterva.maltego.pws.api.OAuthVersion;
import com.paterva.maltego.pws.api.PublicWebService;
import com.paterva.maltego.pws.api.SignInFailedCallback;
import com.paterva.maltego.pws.oauth.OAuthAuthenticatorService;
import com.paterva.maltego.pws.oauth.OAuthModel;
import com.paterva.maltego.pws.oauth.OAuthSignInCallback;
import com.paterva.maltego.pws.oauth.TokenEncrypter;
import com.paterva.maltego.pws.serialization.OAuthAccount;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.runner.TransformMessageWindow;
import com.paterva.maltego.util.Base64;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;

public class OAuthWebService
extends PublicWebService {
    public static final String ALGORITHM = "RSA";
    public static final String TRANSFORMATION = "RSA/ECB/PKCS1Padding";
    private static final Random RAND = new Random();
    private final HashMap<String, RefreshData> _accounts = new HashMap();
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport((Object)this);
    private boolean _signingIn = false;
    private OAuthAuthenticatorService _authenticatorService;
    private OAuthService _service;
    private final OAuthAuthenticator _authenticator;
    private PublicKey _publicKey;

    public OAuthWebService(OAuthAuthenticator authenticator) {
        this(authenticator, null);
    }

    public OAuthWebService(OAuthAuthenticator authenticator, String iconName) {
        super(iconName);
        this._authenticator = authenticator;
    }

    public boolean isCopyOf(PublicWebService pws) {
        if (!(pws instanceof OAuthWebService)) {
            return false;
        }
        OAuthWebService pwsOther = (OAuthWebService)pws;
        return this._authenticator.isCopyOf(pwsOther.getAuthenticator());
    }

    public String getName() {
        return this._authenticator.getName();
    }

    public String getDisplayName() {
        return this._authenticator.getDisplayName();
    }

    public String getDescription() {
        return this._authenticator.getDescription();
    }

    public OAuthWebService setUseSSLHost(boolean useSSLHost) {
        OAuthAuthenticator authenticator = this._authenticator.setUserModifiedUseSSLHost(useSSLHost);
        return new OAuthWebService(authenticator, this.getIconName());
    }

    public OAuthWebService setCallbackPort(Integer port) {
        OAuthAuthenticator authenticator = this._authenticator.setUserModifiedCallbackPort(port);
        return new OAuthWebService(authenticator, this.getIconName());
    }

    public String getTransformInputPropertyName() {
        return this._authenticator.getAccessTokenInput();
    }

    public OAuthAuthenticator getAuthenticator() {
        return this._authenticator;
    }

    protected synchronized void setSigningIn(boolean SigningIn) {
        if (this._signingIn != SigningIn) {
            this._signingIn = SigningIn;
            this.firePropertyChange("signingIn", !this._signingIn, this._signingIn);
        }
    }

    public void addAccount(String account, Long expireAtTime, String refreshToken) {
        this._accounts.put(account, new RefreshData(expireAtTime, refreshToken));
    }

    public List<OAuthAccount> getAccounts() {
        List list = this._accounts.entrySet().stream().map(entry -> {
            String encodedAccessToken = (String)entry.getKey();
            RefreshData refreshData = (RefreshData)entry.getValue();
            return new OAuthAccount(this.getName(), encodedAccessToken, refreshData.expireAtTime, refreshData.refreshToken);
        }).collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }

    protected synchronized void signedIn(Token accessToken) {
        try {
            this.setSigningIn(false);
            String secret = "";
            String encodedAccessToken = null;
            Long expiryTime = null;
            String refreshToken = null;
            if (accessToken instanceof OAuth1Token) {
                OAuth1Token oa1Token = (OAuth1Token)accessToken;
                String token = oa1Token.getToken();
                secret = oa1Token.getTokenSecret();
                encodedAccessToken = this.encodeToken(token, secret);
            } else if (accessToken instanceof OAuth2AccessToken) {
                OAuth2AccessToken oa2Token = (OAuth2AccessToken)accessToken;
                String token = oa2Token.getAccessToken();
                expiryTime = this._authenticatorService.getExpiresAtTime();
                refreshToken = oa2Token.getRefreshToken();
                encodedAccessToken = expiryTime == null || refreshToken == null || !this.usesRefreshTokens() ? this.encodeToken(token, secret) : this.encodeToken(token, secret, expiryTime, refreshToken);
            }
            this._accounts.put(encodedAccessToken, new RefreshData(expiryTime, refreshToken));
            this.firePropertyChange("accountAdded", null, encodedAccessToken);
        }
        catch (IOException | GeneralSecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private synchronized PublicKey getPublicKey() throws GeneralSecurityException, IOException {
        if (this._publicKey == null) {
            String accessTokenPublicKey = this._authenticator.getAccessTokenPublicKey();
            this._publicKey = this.getPublicKey(accessTokenPublicKey);
        }
        return this._publicKey;
    }

    public String encodeToken(String token, String secret) throws GeneralSecurityException, IOException {
        TokenEncrypter encrypter = new TokenEncrypter(this.getPublicKey(), TRANSFORMATION);
        return encrypter.encodeToken(token, secret);
    }

    public String encodeToken(String token, String secret, Long expiresIn, String refreshToken) throws GeneralSecurityException, IOException {
        TokenEncrypter encrypter = new TokenEncrypter(this.getPublicKey(), TRANSFORMATION);
        return encrypter.encodeToken(token, secret, expiresIn.toString(), refreshToken);
    }

    private PublicKey getPublicKey(String x509Base64Pem) throws IOException, GeneralSecurityException {
        byte[] decoded = Base64.decode((String)this.stripPEMHeaderFooter(x509Base64Pem));
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(decoded);
        KeyFactory factory = KeyFactory.getInstance(ALGORITHM);
        return factory.generatePublic(x509EncodedKeySpec);
    }

    private String stripPEMHeaderFooter(String pem) {
        pem = pem.replaceAll("[-]+\\s*BEGIN[^-]+[-]+", "");
        pem = pem.replaceAll("[-]+\\s*END[^-]+[-]+", "");
        pem = pem.replaceAll("\\s", "");
        return pem;
    }

    private OAuthModel createModel() {
        Integer port = this._authenticator.getCallbackPort();
        if (port == null) {
            port = this._authenticator.getOAuthVersion() == OAuthVersion.V2 ? 54275 : this.getRandomPort();
        }
        return new OAuthModel(this._authenticator, port);
    }

    public synchronized void signIn(final SignInFailedCallback cb) {
        this.setSigningIn(true);
        this._service = null;
        final OAuthModel model = this.createModel();
        this._authenticatorService = new OAuthAuthenticatorService(model);
        this._authenticatorService.signIn(new OAuthSignInCallback(){

            @Override
            public void success(Token accessToken) {
                OAuthWebService.this._service = model.getService();
                OAuthWebService.this.signedIn(accessToken);
            }

            @Override
            public void failed(Exception ex) {
                OAuthWebService.this.setSigningIn(false);
                NormalException.logStackTrace((Throwable)ex);
                cb.failed(ex);
            }
        });
    }

    public synchronized boolean isSigningIn() {
        return this._signingIn;
    }

    public synchronized void cancelSigningIn() {
        try {
            this._authenticatorService.cancel();
        }
        finally {
            this.setSigningIn(false);
        }
    }

    public synchronized void signOut(String account) {
        this._accounts.remove(account);
        this.firePropertyChange("accountRemoved", account, null);
    }

    public synchronized Set<String> getSignedIn() {
        return new HashSet<String>(this._accounts.keySet());
    }

    public synchronized boolean isSignedIn(String account) {
        return this._accounts.containsKey(account);
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this._changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private int getRandomPort() {
        return RAND.nextInt(40000) + 15000;
    }

    protected OAuthService getService() {
        return this._service;
    }

    public int compareTo(PublicWebService o) {
        String displayNameOther;
        String displayName = this.getDisplayName();
        if (StringUtilities.areEqual((String)displayName, (String)(displayNameOther = o.getDisplayName()))) {
            return this.getName().compareToIgnoreCase(o.getName());
        }
        return displayName.compareToIgnoreCase(displayNameOther);
    }

    public void refreshAccessTokenIfNeeded() {
        if (!this._accounts.isEmpty() && this.usesRefreshTokens() && this.hasAccessTokenExpired()) {
            TransformMessage tm = new TransformMessage(TransformMessage.Severity.Warning, "Attempting to refresh access token for " + this.getDisplayName());
            TransformMessageWindow.getDefault().write(tm);
            String key = this._accounts.keySet().iterator().next();
            OAuthService service = this.getService();
            if (service == null) {
                service = this.createModel().getService();
            }
            if (service instanceof OAuth20Service) {
                try {
                    OAuth20Service authService = (OAuth20Service)service;
                    long requestTime = this.getSystemTime();
                    RefreshData rd = this._accounts.get(key);
                    OAuth2AccessToken refreshAccessToken = authService.refreshAccessToken(rd.refreshToken);
                    String token = refreshAccessToken.getAccessToken();
                    Long expiryTime = requestTime + (long)(refreshAccessToken.getExpiresIn() * 1000);
                    String refreshToken = refreshAccessToken.getRefreshToken();
                    String encodedAccessToken = this.encodeToken(token, "", expiryTime, refreshToken);
                    this._accounts.remove(key);
                    key = encodedAccessToken;
                    this._accounts.put(key, new RefreshData(expiryTime, refreshToken));
                    this.firePropertyChange("accountAdded", null, encodedAccessToken);
                }
                catch (IOException | InterruptedException | RuntimeException | GeneralSecurityException | ExecutionException ex) {
                    tm = new TransformMessage(TransformMessage.Severity.Warning, "Failed to refresh access token. Signing out " + this.getDisplayName());
                    TransformMessageWindow.getDefault().write(tm);
                    this.signOut(key);
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private long getSystemTime() {
        return System.currentTimeMillis();
    }

    private boolean usesRefreshTokens() {
        return !StringUtilities.isNullOrEmpty((String)this._authenticator.getRefreshTokenEndpoint());
    }

    private boolean hasAccessTokenExpired() {
        String key = this._accounts.keySet().iterator().next();
        RefreshData rd = this._accounts.get(key);
        Long time = rd.expireAtTime;
        long systemTime = this.getSystemTime() + 60000L;
        return time != null ? time <= systemTime : false;
    }

    public String toString() {
        return "OAuthWebService{\n   accessTokens=" + this._accounts + ",\n   service=" + this._service + ",\n   publicKey=" + this._publicKey + ",\n   icon=" + this.getIconName() + ",\n   authenticator=" + this._authenticator + "\n}";
    }

    private static class RefreshData {
        public final Long expireAtTime;
        public final String refreshToken;

        public RefreshData(Long expireAtTime, String refreshToken) {
            this.expireAtTime = expireAtTime;
            this.refreshToken = refreshToken;
        }
    }
}

