/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.lucene.serialize.AbstractTypeConverter;
import java.lang.reflect.Array;

public abstract class PrimitiveTypeConverter<T>
extends AbstractTypeConverter<T> {
    private final Class _primitiveClass;

    public PrimitiveTypeConverter(String typeName, Class<? extends T> clazz, Class primitiveClass) {
        super(typeName, clazz);
        this._primitiveClass = primitiveClass;
    }

    @Override
    public boolean isApplicable(Object input) {
        if (input == null) {
            return false;
        }
        return super.isApplicable(input) || super.isApplicable(input, this._primitiveClass);
    }

    @Override
    protected Object createArray(int size) {
        return Array.newInstance(this._primitiveClass, size);
    }

    @Override
    public String toString() {
        return "TypeConverter{type=" + this.getType() + ", class=" + super.getClassType() + ", primitiveClass=" + this._primitiveClass + '}';
    }
}

