/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.startup;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineException;
import com.paterva.maltego.automation.runtime.MachineValidationException;
import com.paterva.maltego.automation.view.startup.MachineErrorHandler;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class DialgoMachineErrorHandler
extends MachineErrorHandler {
    @Override
    public void error(MachineDescriptor machine, MachineException ex) {
        JPanel panel = new JPanel(new GridLayout(ex.getErrors().length + 1, 1));
        panel.add(new JLabel("The following errors are preventing the machine from starting:"));
        for (String s : ex.getErrors()) {
            JLabel error = new JLabel(String.format("   - %s", s));
            error.setForeground(UIManager.getLookAndFeelDefaults().getColor("7-red"));
            panel.add(error);
        }
        NotifyDescriptor nd = new NotifyDescriptor((Object)panel, "Unable to start machine", -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(nd);
    }

    @Override
    public boolean warn(MachineDescriptor machine, MachineValidationException ex) {
        JPanel panel = new JPanel(new GridLayout(ex.getErrors().length + 4, 1));
        panel.add(new JLabel("The following potential problems exist in the machine:"));
        for (String s : ex.getErrors()) {
            JLabel error = new JLabel(String.format("   - %s", s));
            error.setForeground(UIManager.getLookAndFeelDefaults().getColor("7-red"));
            panel.add(error);
        }
        panel.add(new JLabel(" "));
        panel.add(new JLabel("The machine might still run and retrieve some results."));
        panel.add(new JLabel("Would you like to try and run the machine in any case?"));
        NotifyDescriptor nd = new NotifyDescriptor((Object)panel, "Potential errors in machine", 1, 2, null, NotifyDescriptor.YES_OPTION);
        return DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.YES_OPTION;
    }
}

