/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.editor;

import com.paterva.maltego.automation.view.editor.InsertTextAction;
import com.paterva.maltego.transform.descriptor.StatusItem;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.manager.nodes.StatusItemNode;
import com.paterva.maltego.transform.manager.nodes.TransformProperties;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.InstanceContent;

class TransformNode
extends StatusItemNode {
    private final Action _insertText = new MyInsertTextAction();

    public TransformNode(TransformDefinition transform) {
        this(transform, false);
    }

    public TransformNode(TransformDefinition transform, boolean checkable) {
        this(transform, new InstanceContent(), checkable);
    }

    protected TransformNode(TransformDefinition transform, InstanceContent content, boolean checkable) {
        super(Children.LEAF, (StatusItem)transform, content, checkable);
        this.setIconBaseWithExtension("com/paterva/maltego/transform/manager/resources/Transform.png");
    }

    public Transferable drag() throws IOException {
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.isFlavorTextType();
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (flavor.isFlavorTextType()) {
                    return TransformNode.this.resolveInsertedText();
                }
                return null;
            }
        };
    }

    public Action[] getActions(boolean context) {
        return new Action[]{this._insertText};
    }

    public Action getPreferredAction() {
        return this._insertText;
    }

    private String resolveInsertedText() {
        return String.format("run(\"%s\")", this.getDefinition().getName());
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("properties");
        set.put((Node.Property)new TransformProperties.InputConstraint((Node)this));
        sheet.put(set);
        TransformProperties.addTransformInputs((Sheet)sheet, (TransformDefinition)this.getDefinition());
        return sheet;
    }

    private TransformDefinition getDefinition() {
        return (TransformDefinition)this.getLookup().lookup(TransformDefinition.class);
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        final Node[] nodes = NodeTransfer.nodes((Transferable)t, (int)1);
        s.add(new PasteType(){

            public Transferable paste() throws IOException {
                TransformNode.this.pasteNode(nodes);
                return null;
            }
        });
    }

    private void pasteNode(Node[] nodes) {
        for (Node node : nodes) {
            TransformDefinition transform = (TransformDefinition)node.getLookup().lookup(TransformDefinition.class);
            System.out.println("PASTE " + transform);
        }
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    private class MyInsertTextAction
    extends InsertTextAction {
        private MyInsertTextAction() {
        }

        @Override
        protected String getText() {
            return TransformNode.this.resolveInsertedText();
        }
    }
}

