/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.editor;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.DialogBinding;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

class EditorHelper {
    EditorHelper() {
    }

    static JEditorPane createEditingComponent() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setContentType("text/x-groovy; charset=UTF-8");
        try {
            FileObject fob = FileUtil.createMemoryFileSystem().getRoot().createData("tmp", "groovy");
            DataObject dob = DataObject.find((FileObject)fob);
            editorPane.getDocument().putProperty("stream", dob);
            DialogBinding.bindComponentToFile((FileObject)fob, (int)0, (int)0, (JTextComponent)editorPane);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return editorPane;
    }

    static void showActions(JEditorPane editor) {
        System.out.println("INPUTS");
        for (KeyStroke k : editor.getInputMap().allKeys()) {
            Object o = editor.getInputMap().get(k);
            System.out.println(o + "->" + k);
            EditorHelper.showAction(editor.getActionMap().get(o));
        }
    }

    private static void showAction(Action action) {
        System.out.println(String.format("%s:%s->%s", action.getValue("Name"), action.getValue("ShortDescription"), action.getValue("AcceleratorKey")));
    }

    static Action getToggleCommentAction(JEditorPane editor) {
        return new EditorAction(EditorHelper.getAction(editor, "toggle-comment"), "Toggle Comment", "Toggle Comment (Ctrl /)", "comment.gif");
    }

    static Action getCommentAction(JEditorPane editor) {
        return new EditorAction(EditorHelper.getAction(editor, "comment"), "Comment", "Comment", "comment.gif");
    }

    static Action getUncommentAction(JEditorPane editor) {
        return new EditorAction(EditorHelper.getAction(editor, "uncomment"), "Toggle Comment", "Uncomment", "uncomment.gif");
    }

    static Action getFormatAction(JEditorPane editor) {
        return new EditorAction(EditorHelper.getAction(editor, "format"), "Format", "Format (Alt Shift F)", "format.gif");
    }

    static Action getAction(JEditorPane editor, String name) {
        for (Action action : editor.getActions()) {
            if (!action.getValue("Name").equals(name)) continue;
            return action;
        }
        return null;
    }

    private static class EditorAction
    extends AbstractAction {
        private Action _delegate;

        public EditorAction(Action delegate, String name, String tooltip, String imageFile) {
            this._delegate = delegate;
            this.putValue("Name", name);
            this.putValue("ShortDescription", tooltip);
            this.putValue("SmallIcon", new ImageIcon(ImageUtilities.loadImage((String)("com/paterva/maltego/automation/view/editor/" + imageFile))));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._delegate.actionPerformed(e);
        }
    }
}

