/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.runtime;

import com.paterva.maltego.automation.CompilationException;
import com.paterva.maltego.automation.InitializationContext;
import com.paterva.maltego.automation.MachineCompilation;
import com.paterva.maltego.automation.MachineCompiler;
import com.paterva.maltego.automation.MachineCompilerOptions;
import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineException;
import com.paterva.maltego.automation.MachineManager;
import com.paterva.maltego.automation.MachineRuntimeEvent;
import com.paterva.maltego.automation.MachineRuntimeListener;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.RuntimeState;
import com.paterva.maltego.automation.runtime.MachineProgressEvent;
import com.paterva.maltego.automation.runtime.MachineProgressListener;
import com.paterva.maltego.automation.runtime.MachineRunner;
import com.paterva.maltego.automation.runtime.MachineRuntime;
import com.paterva.maltego.automation.runtime.MachineRuntimeException;
import com.paterva.maltego.automation.runtime.MachineValidationException;
import com.paterva.maltego.automation.runtime.State;
import com.paterva.maltego.automation.runtime.WarnLimitPanel;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.GraphLogger;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.sound.SoundPlayer;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.prefs.Preferences;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.loaders.DataObject;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;

public class DefaultMachineManager
extends MachineManager {
    private final Map<DataObject, Map<MachineDescriptor, MachineRuntimeDescriptor>> _machines = new HashMap<DataObject, Map<MachineDescriptor, MachineRuntimeDescriptor>>();
    private LinkedList<MachineRuntimeListener> _listeners;

    public DefaultMachineManager() {
        this.attachGraphEditorListener();
    }

    @Override
    public void start(DataObject target, MachineDescriptor machine, Payload payload, boolean validate, int iterationCount, boolean shutdownWhenComplete) throws MachineException {
        MachineRuntimeDescriptor runtimeDescriptor;
        Map<MachineDescriptor, MachineRuntimeDescriptor> machines = this._machines.get(target);
        if (machines != null && !machines.isEmpty()) {
            for (Map.Entry<MachineDescriptor, MachineRuntimeDescriptor> entry : machines.entrySet()) {
                MachineRuntime runtime = entry.getValue().getRuntime();
                if (runtime == null || !runtime.isBusy() && !runtime.isSuspended()) continue;
                throw new MachineRuntimeException("A machine is already running on this graph");
            }
        }
        if (machines == null) {
            machines = new HashMap<MachineDescriptor, MachineRuntimeDescriptor>();
            this._machines.put(target, machines);
        }
        if ((runtimeDescriptor = machines.get(machine)) == null || !runtimeDescriptor.getRuntime().isBusy()) {
            runtimeDescriptor = new MachineRuntimeDescriptor(this.create(machine, iterationCount, shutdownWhenComplete, this.getOptions(target, payload)));
            if (validate) {
                this.validate(target, runtimeDescriptor);
            }
            runtimeDescriptor.getRuntime().addMachineProgressListener(this.progressListener());
            machines.put(machine, runtimeDescriptor);
        }
        if (!runtimeDescriptor.getRuntime().isBusy()) {
            A licenseMode = LicenseManager.A().A(false);
            if (licenseMode.N()) {
                this.showLimitDialog();
            }
            SoundPlayer.instance().play("machinestart");
            if (target instanceof GraphDataObject) {
                GraphID graphID = ((GraphDataObject)target).getGraphID();
                GraphLogger.getDefault().log(graphID, "Running machine " + machine.getDisplayName());
            }
        } else {
            throw new MachineRuntimeException("Machine already running");
        }
        MachineRunner.getDefault().start(runtimeDescriptor.getRuntime(), target, payload);
    }

    private MachineCompilerOptions getOptions(DataObject target, Payload payload) {
        String s;
        MaltegoEntity entity;
        EntityRegistry registry;
        Object value;
        GraphID graphID;
        GraphCookie cookie;
        Collection<MaltegoEntity> entities = payload.getEntities();
        if (entities.size() == 1 && (cookie = (GraphCookie)target.getLookup().lookup(GraphCookie.class)) != null && (graphID = cookie.getGraphID()) != null && (value = InheritanceHelper.getValue((SpecRegistry)(registry = EntityRegistry.forGraphID((GraphID)graphID)), (TypedPropertyBag)(entity = entities.iterator().next()))) != null && (s = value.toString().trim().toLowerCase()).startsWith("drawme(") && s.endsWith(")")) {
            return new MachineCompilerOptions.Drawing(s);
        }
        return MachineCompilerOptions.DEFAULT;
    }

    @Override
    public void start(DataObject target, MachineDescriptor machine, Payload payload, boolean validate) throws MachineException {
        this.start(target, machine, payload, validate, Integer.MAX_VALUE, false);
    }

    @Override
    public void start(DataObject target, MachineDescriptor machine, boolean validate) throws MachineException {
        this.start(target, machine, Payloads.getEmpty(), validate);
    }

    private MachineProgressListener progressListener() {
        return new MachineProgressListener(){

            @Override
            public void machineProgress(MachineProgressEvent event) {
                MachineRuntime runtime = (MachineRuntime)event.getSource();
                Object[] result = DefaultMachineManager.this.findDescriptorAndTarget(runtime);
                if (result != null) {
                    DataObject target = (DataObject)result[0];
                    MachineDescriptor machine = (MachineDescriptor)result[1];
                    MachineRuntimeDescriptor runtimeDescriptor = (MachineRuntimeDescriptor)result[2];
                    runtimeDescriptor.incrementProgress(event.getProgressTick());
                    if (event.getNewState() == State.Failed || event.getNewState() == State.Completed || event.getNewState() == State.Cancelled) {
                        if (target != null || machine != null) {
                            DefaultMachineManager.this.remove(target, machine);
                        }
                        SoundPlayer.instance().play("machinedone");
                    }
                    if (event.getNewState() == State.Waiting) {
                        runtimeDescriptor.resetCurrentProgress();
                    }
                    DefaultMachineManager.this.fireMachineProgress(DefaultMachineManager.this.translate(event, target, machine, runtimeDescriptor));
                }
            }
        };
    }

    private MachineRuntimeEvent translate(MachineProgressEvent event, DataObject target, MachineDescriptor machine, MachineRuntimeDescriptor runtimeDescriptor) {
        RuntimeState state;
        switch (event.getNewState()) {
            case Busy: {
                state = RuntimeState.Running;
                break;
            }
            case Completed: {
                state = RuntimeState.Completed;
                break;
            }
            case Failed: {
                state = RuntimeState.Failed;
                break;
            }
            case Suspended: {
                state = RuntimeState.Paused;
                break;
            }
            case Cancelled: {
                state = RuntimeState.Cancelled;
                break;
            }
            case Waiting: {
                state = RuntimeState.Waiting;
                break;
            }
            case Cancelling: {
                state = RuntimeState.Paused;
                break;
            }
            default: {
                state = RuntimeState.Running;
            }
        }
        MachineRuntime runtime = (MachineRuntime)event.getSource();
        MachineRuntimeEvent evt = new MachineRuntimeEvent(this, target, machine, runtime.getContext().getInitialPayload(), state);
        evt.setMessage(event.getMessage());
        evt.setPercent(runtimeDescriptor.getCurrentProgressPercent());
        evt.setTick(event.getTimerTick());
        return evt;
    }

    private MachineRuntime create(MachineDescriptor machine, int iterationCount, boolean shutdownWhenComplete, MachineCompilerOptions options) throws CompilationException {
        MachineCompilation m = MachineCompiler.getDefault().compile(this.getCode(machine), options);
        MachineRuntime runtime = new MachineRuntime(m, iterationCount, shutdownWhenComplete);
        return runtime;
    }

    @Override
    public void suspend(DataObject target, MachineDescriptor machine) {
        MachineRuntimeDescriptor m = this.getMachine(target, machine);
        if (m != null) {
            MachineRunner.getDefault().suspend(m.getRuntime());
        }
    }

    @Override
    public void resume(DataObject target, MachineDescriptor machine) {
        MachineRuntimeDescriptor m = this.getMachine(target, machine);
        if (m != null) {
            MachineRunner.getDefault().resume(m.getRuntime());
        }
    }

    @Override
    public void handleEvent(DataObject target, Object eventName, GraphID graphID, Collection<? extends MaltegoEntity> entities) {
    }

    @Override
    public void handleEvent(DataObject target, Object eventName) {
    }

    @Override
    public void stop(DataObject target, MachineDescriptor machine) {
        MachineRuntimeDescriptor m = this.getMachine(target, machine);
        if (m != null) {
            MachineRunner.getDefault().stop(m.getRuntime());
            this.remove(target, machine);
        }
    }

    @Override
    public void stopAll(DataObject target) {
        Map<MachineDescriptor, MachineRuntimeDescriptor> machines = this._machines.get(target);
        if (machines != null) {
            machines = new HashMap<MachineDescriptor, MachineRuntimeDescriptor>(machines);
            for (Map.Entry<MachineDescriptor, MachineRuntimeDescriptor> entry : machines.entrySet()) {
                MachineRunner.getDefault().stop(entry.getValue().getRuntime());
            }
            this._machines.remove(target);
        }
    }

    private void stopAll(TopComponent tc) {
        DataObject target;
        if (tc != null && (target = (DataObject)tc.getLookup().lookup(DataObject.class)) != null) {
            this.stopAll(target);
        }
    }

    @Override
    public void stopAll() {
        while (!this._machines.isEmpty()) {
            DataObject target = this._machines.keySet().iterator().next();
            this.stopAll(target);
        }
    }

    private Object[] findDescriptorAndTarget(MachineRuntime runtime) {
        for (Map.Entry<DataObject, Map<MachineDescriptor, MachineRuntimeDescriptor>> entry1 : this._machines.entrySet()) {
            for (Map.Entry<MachineDescriptor, MachineRuntimeDescriptor> entry2 : entry1.getValue().entrySet()) {
                if (runtime != entry2.getValue().getRuntime()) continue;
                return new Object[]{entry1.getKey(), entry2.getKey(), entry2.getValue()};
            }
        }
        return null;
    }

    private void remove(DataObject target, MachineDescriptor machine) {
        Map<MachineDescriptor, MachineRuntimeDescriptor> machines = this._machines.get(target);
        if (machines != null) {
            machines.remove(machine);
            if (machines.isEmpty()) {
                this._machines.remove(target);
            }
        }
    }

    @Override
    public synchronized void addMachineListener(MachineRuntimeListener listener) {
        if (this._listeners == null) {
            this._listeners = new LinkedList();
        }
        this._listeners.add(listener);
    }

    @Override
    public synchronized void removeMachineListener(MachineRuntimeListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    private MachineRuntimeDescriptor getMachine(DataObject target, MachineDescriptor machine) {
        Map<MachineDescriptor, MachineRuntimeDescriptor> machines = this._machines.get(target);
        if (machines != null) {
            return machines.get(machine);
        }
        return null;
    }

    private String getCode(MachineDescriptor machine) {
        return (String)machine.getData();
    }

    private void fireMachineProgress(MachineRuntimeEvent evt) {
        if (this._listeners != null) {
            for (MachineRuntimeListener l : this._listeners) {
                l.machineProgress(evt);
            }
        }
    }

    private void validate(DataObject target, MachineRuntimeDescriptor runtimeDescriptor) throws MachineException {
        InitializationContext ctx = runtimeDescriptor.getRuntime().initialize();
        if (ctx.getErrors() != null && ctx.getErrors().length > 0) {
            throw new MachineValidationException(ctx.getErrors());
        }
        runtimeDescriptor.setTotalProgressTicks(ctx.getProgressSteps());
    }

    private void attachGraphEditorListener() {
        GraphEditorRegistry.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("ge_closed".equals(evt.getPropertyName())) {
                    TopComponent tc = (TopComponent)evt.getNewValue();
                    DefaultMachineManager.this.stopAll(tc);
                }
            }
        });
    }

    private void showLimitDialog() {
        String PREF_DONT_SHOW_LIMIT_WARNING = "dontShowMachineLimitWarning";
        Preferences prefs = NbPreferences.forModule(DefaultMachineManager.class);
        boolean dontShow = prefs.getBoolean("dontShowMachineLimitWarning", false);
        if (!dontShow) {
            WarnLimitPanel warnPanel = new WarnLimitPanel();
            DialogDescriptor nd = new DialogDescriptor((Object)warnPanel, "Results Limited");
            nd.setMessageType(2);
            nd.setOptions(new Object[]{NotifyDescriptor.OK_OPTION});
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            dontShow = warnPanel.getDontShowAgain();
            if (dontShow) {
                prefs.putBoolean("dontShowMachineLimitWarning", dontShow);
            }
        }
    }

    private class MachineRuntimeDescriptor {
        private MachineRuntime _runtime;
        private int _totalProgressTicks;
        private int _currentProgress;

        public MachineRuntimeDescriptor(MachineRuntime runtime) {
            this._runtime = runtime;
        }

        public MachineRuntime getRuntime() {
            return this._runtime;
        }

        public int getTotalProgressTicks() {
            return this._totalProgressTicks;
        }

        public void setTotalProgressTicks(int totalProgressTicks) {
            this._totalProgressTicks = totalProgressTicks;
        }

        public int getCurrentProgress() {
            return this._currentProgress;
        }

        public void incrementProgress(int ticks) {
            if (ticks > 0) {
                this._currentProgress += ticks;
            }
        }

        public int getCurrentProgressPercent() {
            int percent = (int)((double)this.getCurrentProgress() / (double)this.getTotalProgressTicks() * 100.0);
            if (percent > 100) {
                percent = 100;
            }
            if (percent < 0) {
                percent = 0;
            }
            return percent;
        }

        public void resetCurrentProgress() {
            this._currentProgress = 0;
        }
    }
}

