/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.option;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.option.MachineOptions;
import com.paterva.maltego.automation.view.MachineInputProvider;
import com.paterva.maltego.automation.view.startup.RunActions;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.ui.graph.actions.FullScreenTCAction;
import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class MachineOptionProcessor
extends OptionProcessor {
    private static final Option RUN_MACHINE = Option.requiredArgument((char)'m', (String)"machine");
    private static final boolean DEBUG = false;

    protected Set<Option> getOptions() {
        return Collections.singleton(RUN_MACHINE);
    }

    protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
        block8: {
            String[] values = optionValues.get(RUN_MACHINE);
            if (values.length <= 0) {
                return;
            }
            String optionText = values[0];
            MachineOptions options = new MachineOptions(optionText);
            MachineDescriptor machine = this.getMachine(options.getMachineText());
            if (machine != null) {
                try {
                    List<String[]> entityPairs = options.getEntityPairs();
                    String[] requiredEntities = this.getRequiredEntities(machine);
                    String[] providedEntities = MachineOptions.getEntityTypes(entityPairs);
                    if (!this.verifyEntities(requiredEntities, providedEntities)) {
                        this.showTypeError(requiredEntities, providedEntities);
                        break block8;
                    }
                    try {
                        List<MaltegoEntity> entities = this.createEntities(entityPairs);
                        this.runMachine(machine, entities, options);
                    }
                    catch (TypeInstantiationException ex) {
                        this.showError(ex.getMessage());
                    }
                }
                catch (ParseException ex) {
                    this.showError(ex.getMessage());
                }
            } else {
                this.showError("Machine not found: " + options.getMachineText());
            }
        }
    }

    private MachineDescriptor getMachine(String machineName) {
        MachineDescriptor machine = null;
        try {
            machine = MachineRepository.getDefault().get(machineName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return machine;
    }

    private String[] getRequiredEntities(MachineDescriptor machine) {
        MachineInput input = MachineInputProvider.getDefault().getInputDescriptor(machine);
        return input.getSupportedEntityTypes();
    }

    private boolean verifyEntities(String[] required, String[] provided) {
        Arrays.sort(required);
        Arrays.sort(provided);
        return Arrays.equals(required, provided);
    }

    private List<MaltegoEntity> createEntities(List<String[]> optionEntities) throws TypeInstantiationException {
        ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>();
        EntityRegistry registry = EntityRegistry.getDefault();
        for (String[] pair : optionEntities) {
            String entityType = pair[0];
            String entityValue = pair[1];
            MaltegoEntity entity = (MaltegoEntity)EntityFactory.getDefault().createInstance(entityType, false, true);
            InheritanceHelper.setValue((SpecRegistry)registry, (TypedPropertyBag)entity, (Object)entityValue);
            entities.add(entity);
        }
        return entities;
    }

    private void runMachine(MachineDescriptor machine, List<MaltegoEntity> entities, MachineOptions options) {
        MaltegoEntity[] targets = entities.toArray(new MaltegoEntity[entities.size()]);
        Runnable runMachine = () -> {
            RunActions.runOnTargets(machine, targets, options.getIterations(), options.shutdownWhenComplete());
            if (options.isFullscreen()) {
                SwingUtilities.invokeLater(() -> {
                    FullScreenTCAction fullScreenAction = new FullScreenTCAction();
                    fullScreenAction.actionPerformed(null);
                });
            }
        };
        UIRunQueue.instance().queue(10000, runMachine);
    }

    private void showError(String msg) {
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
        nd.setMessageType(0);
        nd.setTitle("Error starting machine");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }

    private void showTypeError(String[] requiredEntities, String[] providedEntities) {
        String tab = "    ";
        StringBuilder sb = new StringBuilder("Input entities types does not match required types.\n");
        sb.append(tab).append("Required:\n");
        for (String type : requiredEntities) {
            sb.append(tab).append(tab).append(type).append("\n");
        }
        sb.append(tab).append("Provided:\n");
        for (String type : providedEntities) {
            sb.append(tab).append(tab).append(type).append("\n");
        }
        this.showError(sb.toString());
    }
}

