/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.imex;

import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.archive.mtz.discover.DiscoveryContext;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryItems;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryProvider;
import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.imex.MachineImporter;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openide.util.Exceptions;

public class MachineDiscoveryProvider
extends MtzDiscoveryProvider<MtzMachines> {
    public MtzMachines read(DiscoveryContext ctx, MaltegoArchiveReader reader) throws IOException {
        MachineImporter importer = new MachineImporter();
        return new MtzMachines(importer.read(reader), ctx);
    }

    public void apply(MtzMachines machines) {
        for (MachineDescriptor machine : machines.getMachines()) {
            machine.setReadOnly(true);
        }
        DiscoveryContext ctx = machines.getContext();
        String seedUrl = ctx.getSeedUrl();
        HubSeedDescriptor hubSeed = HubSeedRegistry.getDefault().getHubSeed(seedUrl);
        String hubItem = hubSeed == null ? null : hubSeed.getName();
        MachineImporter importer = new MachineImporter();
        importer.apply(machines.getMachines(), hubItem);
    }

    public MtzMachines getNewAndMerged(MtzMachines items) {
        List<MachineDescriptor> machines = items.getMachines();
        ArrayList<MachineDescriptor> newMachines = new ArrayList<MachineDescriptor>();
        MachineRepository repository = MachineRepository.getDefault();
        for (MachineDescriptor newMachine : machines) {
            try {
                MachineDescriptor oldMachine = repository.get(newMachine.getName());
                if (oldMachine != null && oldMachine.isCopy(newMachine)) continue;
                newMachines.add(newMachine);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return new MtzMachines(newMachines, items.getContext());
    }

    public class MtzMachines
    extends MtzDiscoveryItems {
        private final List<MachineDescriptor> _machines;

        private MtzMachines(List<MachineDescriptor> machines, DiscoveryContext context) {
            super((MtzDiscoveryProvider)MachineDiscoveryProvider.this, context);
            this._machines = machines;
        }

        public String getDescription() {
            return "Machines";
        }

        public List<MachineDescriptor> getMachines() {
            return this._machines;
        }

        public int size() {
            return this._machines.size();
        }
    }
}

