/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions.userfilter;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.InitializationContext;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.MachineInputs;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.PropertySupport;
import com.paterva.maltego.automation.actions.userfilter.UserFilterDescriptor;
import com.paterva.maltego.automation.actions.userfilter.UserFilterManager;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.sound.SoundPlayer;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.SimilarStrings;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.util.ImageUtilities;

public class UserFilterAction
extends PropertySupport
implements Action {
    private Object _handle;

    @Override
    public void start(final AutomationContext ctx, Payload payload, final Action.Callback cb) {
        if (payload.isEmpty()) {
            cb.completed(Payloads.getEmpty());
        } else {
            String title = (String)this.getValueOrProperty("title", "User Filter");
            String description = (String)this.getProperty("description", "Please select the entities to continue with from the list below");
            String heading = (String)this.getProperty("heading", "The following results were returned");
            String buttonText = (String)this.getProperty("proceedButtonText", "Proceed >");
            String iconName = (String)this.getProperty("icon");
            String removePrompt = (String)this.getProperty("removePromptText", "Remove unselected entities from graph");
            Boolean removeChecked = (Boolean)this.getProperty("removePromptChecked", true);
            Boolean entitiesSelected = (Boolean)this.getProperty("selectEntities", true);
            Boolean showIncoming = (Boolean)this.getProperty("showIncomingLinks", false);
            Boolean showOutgoing = (Boolean)this.getProperty("showOutgoingLinks", false);
            Boolean showGeneratedBy = (Boolean)this.getProperty("showGeneratedBy", false);
            UserFilterDescriptor descriptor = new UserFilterDescriptor(ctx, payload, title, heading);
            descriptor.setDescription(description);
            descriptor.setButtonText(buttonText);
            descriptor.setIcon(this.getIcon(ctx.getTargetGraphID(), iconName));
            descriptor.setRemovePromptChecked(removeChecked);
            descriptor.setRemovePromptText(removePrompt);
            descriptor.setDefaultSelectionState(entitiesSelected);
            descriptor.setShowIncomingLinks(showIncoming);
            descriptor.setShowOutgoingLinks(showOutgoing);
            descriptor.setShowGeneratedBy(showGeneratedBy);
            ctx.getLogger().info(this.toString(), new Object[0]);
            SoundPlayer.instance().play("userfilter");
            this._handle = UserFilterManager.getDefault().show(descriptor, new UserFilterManager.UserFilterCallback(){

                @Override
                public void onResume(Collection<MaltegoEntity> selected, Collection<MaltegoEntity> toDelete) {
                    UserFilterAction.deleteEntities(ctx, GraphStoreHelper.getIds(toDelete));
                    UserFilterAction.this._handle = null;
                    ctx.progress(1);
                    cb.completed(Payloads.fromEntities(selected));
                }
            });
        }
    }

    @Override
    public void cancel() {
        if (this._handle != null) {
            UserFilterManager.getDefault().close(this._handle);
        }
    }

    private static void deleteEntities(AutomationContext ctx, Set<EntityID> entityIDs) {
        if (!entityIDs.isEmpty()) {
            GraphID graphID = ctx.getTargetGraphID();
            String description = "%s " + GraphTransactionHelper.getDescriptionForEntityIDs((GraphID)graphID, entityIDs, (boolean)true);
            SimilarStrings descriptions = new SimilarStrings(description, "Delete", "Add");
            GraphTransactionHelper.doDeleteEntities((SimilarStrings)descriptions, (GraphID)graphID, entityIDs);
        }
    }

    @Override
    public String getSimpleName() {
        return "userFilter";
    }

    @Override
    public String getName() {
        return String.format("%s(%s)", this.getSimpleName(), this.getValueOrProperty("title", ""));
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public MachineInput getInputDescriptor() {
        return MachineInputs.passThrough();
    }

    private Icon getIcon(GraphID graphID, String iconName) {
        ImageIcon icon = null;
        if (iconName != null) {
            int iconSize = IconSize.MEDIUM.getSize();
            icon = ImageFactory.getDefault().getImageIcon(graphID, (Object)iconName, iconSize, iconSize);
        }
        if (icon == null) {
            icon = new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/RobotFilter32.png"));
        }
        return icon;
    }

    @Override
    public InitializationContext initialize() {
        return InitializationContext.progress(1);
    }
}

