/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions.userfilter;

import com.paterva.maltego.automation.actions.userfilter.EntityNode;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import java.util.HashSet;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import y.base.Graph;
import y.view.Graph2D;

class EntityNodeHelper {
    private EntityNodeHelper() {
    }

    public static y.base.Node getYNode(Graph view, MaltegoEntity entity) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)view);
        return wrapper.node((EntityID)entity.getID());
    }

    public static void navigateTo(EntityID entityID) {
        Graph2D viewGraph;
        GraphWrapper wrapper;
        y.base.Node node;
        GraphView view = EntityNodeHelper.findCurrentGraphView();
        if (view != null && (node = (wrapper = MaltegoGraphManager.getWrapper((Graph)(viewGraph = view.getViewGraph()))).node(entityID)) != null) {
            view.center(node);
            view.setZoom(0.75);
        }
    }

    public static void selectOnView(Node[] nodes) {
        Graph2D viewGraph;
        GraphID graphID;
        GraphView view = EntityNodeHelper.findCurrentGraphView();
        if (view != null && (graphID = GraphIDProvider.forGraph((Graph2D)(viewGraph = view.getViewGraph()))) != null) {
            GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
            HashSet<EntityID> modelEntityIDs = new HashSet<EntityID>();
            for (Node node : nodes) {
                EntityNode entityNode;
                if (!(node instanceof EntityNode) || !graphID.equals((Object)(entityNode = (EntityNode)node).getGraphID())) continue;
                modelEntityIDs.add(entityNode.getEntityID());
            }
            if (!modelEntityIDs.isEmpty()) {
                selection.setSelectedModelEntities(modelEntityIDs);
            }
        }
    }

    public static void selectOnView(List<EntityID> entityIDs) {
        Graph2D viewGraph;
        GraphID graphID;
        GraphView view = EntityNodeHelper.findCurrentGraphView();
        if (view != null && (graphID = GraphIDProvider.forGraph((Graph2D)(viewGraph = view.getViewGraph()))) != null) {
            GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
            selection.setSelectedModelEntities(entityIDs);
        }
    }

    private static GraphView findCurrentGraphView() {
        GraphViewCookie cookie;
        TopComponent tc = GraphEditorRegistry.getDefault().getTopmost();
        if (tc != null && (cookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class)) != null) {
            return cookie.getGraphView();
        }
        return null;
    }
}

