/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.ball.customization;

import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.view.customization.api.Customizable;
import y.base.Edge;
import y.base.Graph;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.LineType;

public class LinkThicknessCustomizable
extends Customizable.Edges {
    public static final int MIN = 1;
    public static final int MAX = 5;
    public static final int DEFAULT = 1;

    public String getName() {
        return "maltego.view.customizable.link.thickness";
    }

    public String getDisplayName() {
        return "Link Thickness";
    }

    public String getDescription() {
        return "The thickness of a link. Value is clamped to [1 - 5]. Default/fallback is 1.";
    }

    public boolean isViewSupported(String viewID) {
        return "BallView".equals(viewID);
    }

    public Class getValueType() {
        return Integer.class;
    }

    public void setDefault(Edge target) {
        this.setValue(target, (Object)null);
    }

    public Object getValue(Edge target) {
        MaltegoLink link = this.getLink(target);
        return link != null ? link.getThickness() : null;
    }

    public void setValue(Edge target, Object value) {
        Graph2D graph2D;
        EdgeRealizer realizer;
        Graph graph;
        int thickness = 1;
        if (value instanceof Number) {
            thickness = ((Number)value).intValue();
            thickness = Math.max(thickness, 1);
            thickness = Math.min(thickness, 5);
        }
        if ((graph = target.getGraph()) instanceof Graph2D && (realizer = (graph2D = (Graph2D)graph).getRealizer(target)) != null) {
            realizer.setLineType(LineType.getLineType((int)thickness, (byte)realizer.getLineType().getLineStyle()));
        }
    }

    private MaltegoLink getLink(Edge edge) {
        Graph graph = edge.getGraph();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)graph);
        if (wrapper != null) {
            return wrapper.link(edge);
        }
        return null;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

