/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.ball;

import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.ui.graph.view2d.RoundRectHotSpotPainter;
import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.view.ball.BallProperties;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import y.base.Node;
import y.view.GenericNodeRealizer;
import y.view.NodeRealizer;

class RoundHotSpotPainter
implements GenericNodeRealizer.HotSpotPainter {
    private static final Logger LOG = Logger.getLogger(RoundHotSpotPainter.class.getName());
    public static final int OVERHANG = 20;

    RoundHotSpotPainter() {
    }

    public void paintHotSpots(NodeRealizer nr, Graphics2D g2D) {
        Node node = nr.getNode();
        double ballSize = BallProperties.getBallSize(node);
        g2D.setColor(ColorUtilities.makeTranslucent((Color)NodeRealizerSettings.getDefault().getSelectionBackgroundColor1(), (int)200));
        double x = nr.getX() + (nr.getWidth() - ballSize) / 2.0;
        LOG.log(Level.FINE, "ballSize={0} x={1}", new Object[]{ballSize, x});
        if (CollectionNodeUtils.isCollectionNode((NodeRealizer)nr)) {
            g2D.fill(new Rectangle2D.Double(x, nr.getY(), ballSize, ballSize));
        } else {
            g2D.fill(new Ellipse2D.Double(x, nr.getY(), ballSize, ballSize));
        }
        RoundHotSpotPainter.paintBorder(nr, g2D, ballSize);
    }

    public static void paintBorder(NodeRealizer nr, Graphics2D g2D, double ballSize) {
        RoundRectHotSpotPainter.paintBorder((NodeRealizer)nr, (Graphics2D)g2D, (Insets)new Insets(0, 0, 0, 0), (boolean)false, (Double)ballSize);
    }
}

