/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.ball;

import java.awt.Color;
import y.base.DataProvider;
import y.base.Graph;
import y.base.Node;
import y.base.NodeMap;

public class BallProperties {
    public static final String BALL_NODE_SIZE = "maltego.ball.size";
    public static final String BALL_NODE_COLOR = "maltego.node.color";

    public static void setBallSize(Node node, double ballSize) {
        Graph graph;
        if (node != null && (graph = node.getGraph()) != null) {
            NodeMap ballSizes = BallProperties.getBallSizeProvider(graph);
            ballSizes.setDouble((Object)node, ballSize);
        }
    }

    public static double getBallSize(Node node) {
        Graph graph;
        double size = 0.0;
        if (node != null && (graph = node.getGraph()) != null) {
            NodeMap ballSizes = BallProperties.getBallSizeProvider(graph);
            size = ballSizes.getDouble((Object)node);
            size = Math.max(size, 50.0);
            size = Math.min(size, 500.0);
        }
        return size;
    }

    public static void setBallColor(Node node, Color ballColor) {
        Graph graph;
        if (node != null && (graph = node.getGraph()) != null) {
            NodeMap ballColors = BallProperties.getBallColorProvider(graph);
            ballColors.set((Object)node, (Object)ballColor);
        }
    }

    public static Color getBallColor(Node node) {
        Graph graph;
        Color color = null;
        if (node != null && (graph = node.getGraph()) != null) {
            NodeMap ballColors = BallProperties.getBallColorProvider(graph);
            color = (Color)ballColors.get((Object)node);
        }
        return color;
    }

    private static NodeMap getBallSizeProvider(Graph graph) {
        DataProvider dataProvider = graph.getDataProvider((Object)BALL_NODE_SIZE);
        if (dataProvider == null) {
            dataProvider = graph.createNodeMap();
            graph.addDataProvider((Object)BALL_NODE_SIZE, dataProvider);
        }
        return (NodeMap)dataProvider;
    }

    private static NodeMap getBallColorProvider(Graph graph) {
        DataProvider dataProvider = graph.getDataProvider((Object)BALL_NODE_COLOR);
        if (dataProvider == null) {
            dataProvider = graph.createNodeMap();
            graph.addDataProvider((Object)BALL_NODE_COLOR, dataProvider);
        }
        return (NodeMap)dataProvider;
    }
}

