/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.ball;

import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.NodeLabelUtils;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.ui.graph.view2d.RoundRectHotSpotPainter;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import y.view.NodeRealizer;

class BallPaintUtils {
    private static final int HOTSPOT_SIZE = 10;

    BallPaintUtils() {
    }

    public static void paintBall(NodeRealizer nr, Graphics2D g2D, Color baseColor, double ballSize) {
        double width = ballSize - 20.0;
        double x = nr.getX() + 10.0 + (nr.getWidth() - ballSize) / 2.0;
        double y = nr.getY() + 10.0;
        Color unselectedBorder = Color.white;
        g2D.setColor(baseColor);
        float ballStrokeWidth = NodeRealizerSettings.getDefault().getBallBorderStrokeWidth();
        g2D.setStroke(new BasicStroke(ballStrokeWidth));
        if (CollectionNodeUtils.isCollectionNode((NodeRealizer)nr)) {
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, width);
            double arc = 12.0 / (100.0 / ballSize);
            RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(x, y, width, width, arc, arc);
            g2D.fill(roundRect);
            if (!nr.isSelected()) {
                g2D.setColor(unselectedBorder);
                g2D.draw(roundRect);
            }
            if (nr.isSelected()) {
                double zoom = GraphicsUtils.getZoom((Graphics2D)g2D);
                float strokeWidth = RoundRectHotSpotPainter.getStrokeWidth();
                if (zoom < 1.0) {
                    strokeWidth = (float)((double)strokeWidth / zoom);
                }
                x = nr.getX() + (nr.getWidth() - ballSize) / 2.0 - (double)(strokeWidth / 2.0f);
                y = nr.getY() - (double)(strokeWidth / 2.0f);
                rect = new Rectangle2D.Double(x, y, ballSize += (double)strokeWidth, ballSize);
                NodeLabelUtils.paintCollectionNodeBallLabelBackground((NodeRealizer)nr, (Graphics2D)g2D, (Rectangle2D)rect, (double)strokeWidth, (double)ballSize);
            } else {
                NodeLabelUtils.paintCollectionNodeBallLabelBackground((NodeRealizer)nr, (Graphics2D)g2D, (Rectangle2D)rect, (double)(0.0f + ballStrokeWidth), (double)ballSize);
            }
        } else {
            Ellipse2D.Double ellipse2D = new Ellipse2D.Double(x, y, width, width);
            g2D.fill(ellipse2D);
            Rectangle2D rect = new Rectangle2D.Double(x, y, width, width);
            if (nr.isSelected()) {
                double zoom = GraphicsUtils.getZoom((Graphics2D)g2D);
                float strokeWidth = RoundRectHotSpotPainter.getStrokeWidth();
                if (zoom < 1.0) {
                    strokeWidth = (float)((double)strokeWidth / zoom);
                }
                rect = NodeLabelUtils.getRectangle2D((NodeRealizer)nr, (float)strokeWidth);
                NodeLabelUtils.paintLabelBackground((NodeRealizer)nr, (Graphics2D)g2D, (Rectangle2D)rect, (double)strokeWidth);
            } else {
                g2D.setColor(unselectedBorder);
                g2D.draw(ellipse2D);
                NodeLabelUtils.paintLabelBackground((NodeRealizer)nr, (Graphics2D)g2D, (Rectangle2D)rect, (double)(0.0f + ballStrokeWidth));
            }
        }
    }
}

