/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.IHttpSession;
import org.xlightweb.client.HttpClientConnection;

final class SessionManager
implements Cloneable {
    public static final Logger LOG = Logger.getLogger(SessionManager.class.getName());
    private static final long CLEANING_PERIOD_MILLIS = 5000L;
    private Cleaner cleaner;
    private final HashMap<DomainPathPair, HttpSession> sessions = new HashMap();

    public SessionManager() {
        this.cleaner = new Cleaner(this);
        HttpClientConnection.schedule(this.cleaner, 5000L, 5000L);
    }

    public void close() {
        if (this.cleaner != null) {
            this.cleaner.close();
        }
        this.cleaner = null;
        this.sessions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHttpSession getSession(String domain, String path, boolean create) {
        HashMap<DomainPathPair, HttpSession> hashMap = this.sessions;
        synchronized (hashMap) {
            for (DomainPathPair pair : this.sessions.keySet()) {
                if (!domain.equals(pair.getDomain()) && !domain.endsWith(pair.getDomain())) continue;
                HttpSession session = this.sessions.get(pair);
                if (session != null) {
                    session.setLastAccessTime(System.currentTimeMillis());
                }
                return session;
            }
        }
        if (create) {
            DomainPathPair pair = new DomainPathPair(domain, path);
            HttpSession session = new HttpSession(UUID.randomUUID().toString());
            this.put(pair, session);
            return session;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(DomainPathPair pair, HttpSession session) {
        HashMap<DomainPathPair, HttpSession> hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.put(pair, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean() {
        block7: {
            try {
                HashMap sessionsCopy = null;
                HashMap<DomainPathPair, HttpSession> hashMap = this.sessions;
                synchronized (hashMap) {
                    sessionsCopy = (HashMap)this.sessions.clone();
                }
                long currentMillis = System.currentTimeMillis();
                for (Map.Entry entry : sessionsCopy.entrySet()) {
                    if (!((HttpSession)entry.getValue()).checkMaxIntervalExceeded(currentMillis)) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("session " + entry.getValue() + " has been expired. Deleting it");
                    }
                    this.close();
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine("error occured by cleaning sessions " + e.toString());
            }
        }
    }

    private static final class DomainPathPair {
        private String domain = "";
        private String path = "";

        DomainPathPair(String domain, String path) {
            this.domain = domain;
            if (path != null) {
                this.path = path;
            }
        }

        String getDomain() {
            return this.domain;
        }

        public int hashCode() {
            return (this.domain + this.path).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof DomainPathPair) {
                DomainPathPair other = (DomainPathPair)obj;
                if (other.domain.equals(this.domain) && other.path.equals(this.path)) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HttpSession
    implements IHttpSession {
        private static final long serialVersionUID = -5876183451306149950L;
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private boolean isValid = true;
        private String id = null;
        private long creationTime;
        private long lastAccesTime = this.creationTime = System.currentTimeMillis();
        private int maxInactiveIntervalSec = -1;

        public HttpSession(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public long getLastAccessedTime() {
            if (!this.isValid()) {
                throw new IllegalStateException("Session " + this.getId() + " is invalid");
            }
            return this.lastAccesTime;
        }

        void setLastAccessTime(long lastAccesTime) {
            this.lastAccesTime = lastAccesTime;
        }

        @Override
        public Object getAttribute(String name) {
            if (!this.isValid()) {
                throw new IllegalStateException("Session " + this.getId() + " is invalid");
            }
            return this.attributes.get(name);
        }

        @Override
        public void setAttribute(String name, Object value) {
            if (!this.isValid()) {
                throw new IllegalStateException("Session " + this.getId() + " is invalid");
            }
            this.attributes.put(name, value);
        }

        @Override
        public void removeAttribute(String name) {
            if (!this.isValid()) {
                throw new IllegalStateException("Session " + this.getId() + " is invalid");
            }
            this.attributes.remove(name);
        }

        @Override
        public Enumeration<String> getAttributeNames() {
            if (!this.isValid()) {
                throw new IllegalStateException("Session " + this.getId() + " is invalid");
            }
            return Collections.enumeration(this.getAttributeNameSet());
        }

        @Override
        public Set<String> getAttributeNameSet() {
            if (!this.isValid()) {
                throw new IllegalStateException("Session " + this.getId() + " is invalid");
            }
            return Collections.unmodifiableSet(this.attributes.keySet());
        }

        @Override
        public void setMaxInactiveInterval(int maxInactiveIntervalSec) {
            this.maxInactiveIntervalSec = maxInactiveIntervalSec;
        }

        @Override
        public int getMaxInactiveInterval() {
            return this.maxInactiveIntervalSec;
        }

        @Override
        public void invalidate() {
            this.isValid = false;
        }

        @Override
        public boolean isValid() {
            return this.isValid;
        }

        boolean checkMaxIntervalExceeded(long currentMillis) {
            if (System.currentTimeMillis() > this.lastAccesTime + (long)this.maxInactiveIntervalSec * 1000L) {
                this.invalidate();
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                sb.append(entry.getKey() + "=" + entry.getValue() + "&");
            }
            return sb.toString();
        }
    }

    private static final class Cleaner
    extends TimerTask
    implements Closeable {
        private WeakReference<SessionManager> sessionManagerRef;

        public Cleaner(SessionManager sessionManager) {
            this.sessionManagerRef = new WeakReference<SessionManager>(sessionManager);
        }

        public void run() {
            WeakReference<SessionManager> ref = this.sessionManagerRef;
            if (ref != null) {
                SessionManager sessionManager = (SessionManager)ref.get();
                if (sessionManager == null) {
                    this.close();
                } else {
                    sessionManager.clean();
                }
            }
        }

        public void close() {
            this.cancel();
            this.sessionManagerRef = null;
        }
    }
}

