/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BodyDataSink;
import org.xlightweb.HttpRequest;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.ProtocolException;
import org.xlightweb.Supports100Continue;
import org.xlightweb.client.DuplicatingBodyForwarder;
import org.xlightweb.client.HttpClient;
import org.xlightweb.client.HttpClientConnection;
import org.xsocket.Execution;
import org.xsocket.connection.IConnection;

@Supports100Continue
final class RedirectHandler
implements IHttpRequestHandler {
    private static final Logger LOG = Logger.getLogger(RedirectHandler.class.getName());
    private static final String COUNT_REDIRECTS_KEY = "org.xlightweb.client.RedirectHandler.countRedirects";
    private final HttpClient httpClient;

    public RedirectHandler(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void onRequest(IHttpExchange exchange) throws IOException {
        IHttpRequest request = exchange.getRequest();
        if (request.hasBody()) {
            BodyRedirectResponseHandler redirectHandler = new BodyRedirectResponseHandler(request.getRequestHeader().copy(), exchange);
            BodyDataSink dataSink = exchange.forward(request.getRequestHeader(), (IHttpResponseHandler)redirectHandler);
            dataSink.setFlushmode(IConnection.FlushMode.ASYNC);
            DuplicatingBodyForwarder forwarder = new DuplicatingBodyForwarder(request.getNonBlockingBody(), new DuplicatingBodyForwarder.BodyDataSinkAdapter(dataSink), redirectHandler);
            HttpClientConnection.setDataHandlerSilence(request.getNonBlockingBody(), forwarder);
        } else {
            exchange.forward(request, (IHttpResponseHandler)new BodylessRedirectResponseHandler(request.getRequestHeader().copy(), exchange));
        }
    }

    @Supports100Continue
    private final class BodylessRedirectResponseHandler
    extends AbstractRedirectResponseHandler {
        BodylessRedirectResponseHandler(IHttpRequestHeader requestHeader, IHttpExchange exchange) throws IOException {
            super(requestHeader, exchange);
        }

        protected void sendRedirectedRequest() {
            Runnable task = new Runnable(){

                public void run() {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("send redirected request: " + BodylessRedirectResponseHandler.this.getRequestHeader());
                    }
                    try {
                        BodylessRedirectResponseHandler.this.getRequestHeader().setAttribute(RedirectHandler.COUNT_REDIRECTS_KEY, BodylessRedirectResponseHandler.this.incCountRedirect());
                        BodylessRedirectResponseHandler.this.getRequestHeader().setAttribute("org.xlightweb.client.cookieHandler.cookieWarning", false);
                        IHttpResponseHandler respHdl = new IHttpResponseHandler(){

                            @Execution(value=0)
                            public void onResponse(IHttpResponse response) throws IOException {
                                BodylessRedirectResponseHandler.this.getExchange().send(response);
                            }

                            @Execution(value=0)
                            public void onException(IOException ioe) throws IOException {
                                BodylessRedirectResponseHandler.this.getExchange().sendError(ioe);
                            }
                        };
                        RedirectHandler.this.httpClient.send(new HttpRequest(BodylessRedirectResponseHandler.this.getRequestHeader()), respHdl);
                    }
                    catch (IOException ioe) {
                        BodylessRedirectResponseHandler.this.getExchange().sendError(new IOException("can execute redirect request " + BodylessRedirectResponseHandler.this.getRequestHeader() + " reason: " + ioe.toString()));
                    }
                }
            };
            RedirectHandler.this.httpClient.getWorkerpool().execute(task);
        }
    }

    @Supports100Continue
    private final class BodyRedirectResponseHandler
    extends AbstractRedirectResponseHandler
    implements DuplicatingBodyForwarder.ISink {
        private final DuplicatingBodyForwarder.InMemorySink inMemorySink;
        private boolean is100ContinueReceived;
        private boolean isBufferIsActivated;

        BodyRedirectResponseHandler(IHttpRequestHeader requestHeader, IHttpExchange exchange) throws IOException {
            super(requestHeader, exchange);
            this.inMemorySink = new DuplicatingBodyForwarder.InMemorySink();
            this.is100ContinueReceived = false;
            this.isBufferIsActivated = true;
        }

        public void onResponse(IHttpResponse response) throws IOException {
            if (response.getStatus() == 100) {
                this.is100ContinueReceived = true;
                if (response.getAttribute("org.xlightweb.HttpClientConnection.100-continueTimeout") != null && ((Boolean)response.getAttribute("org.xlightweb.HttpClientConnection.100-continueTimeout")).booleanValue()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Got auto-generated 100-continue response " + response.getReason());
                    }
                } else {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Got 100-continue response. destroying buffer body data sink");
                    }
                    this.isBufferIsActivated = false;
                    this.inMemorySink.destroy();
                }
            } else if (this.is100ContinueReceived && this.isRedirectResponse(this.getRequestHeader(), response.getResponseHeader())) {
                this.onException(new ProtocolException("Response order error. Got a redirect response after a 100-continue response", response.getResponseHeader()));
            }
            super.onResponse(response);
        }

        public void onData(ByteBuffer data) throws IOException {
            if (this.isBufferIsActivated) {
                this.inMemorySink.onData(data);
            }
        }

        public void close() throws IOException {
            this.inMemorySink.close();
        }

        public void destroy() {
            this.inMemorySink.destroy();
        }

        public void setDestroyListener(IBodyDestroyListener destroyListener) {
            this.inMemorySink.setDestroyListener(destroyListener);
        }

        public String getId() {
            return this.inMemorySink.getId();
        }

        protected void sendRedirectedRequest() {
            Runnable task = new Runnable(){

                public void run() {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("send redirected request (body size " + BodyRedirectResponseHandler.this.inMemorySink.getSize() + "): " + BodyRedirectResponseHandler.this.getRequestHeader());
                    }
                    try {
                        BodyRedirectResponseHandler.this.getRequestHeader().setAttribute(RedirectHandler.COUNT_REDIRECTS_KEY, BodyRedirectResponseHandler.this.incCountRedirect());
                        BodyRedirectResponseHandler.this.getRequestHeader().setAttribute("org.xlightweb.client.cookieHandler.cookieWarning", false);
                        IHttpResponseHandler respHdl = new IHttpResponseHandler(){

                            @Execution(value=0)
                            public void onResponse(IHttpResponse response) throws IOException {
                                BodyRedirectResponseHandler.this.getExchange().send(response);
                            }

                            @Execution(value=0)
                            public void onException(IOException ioe) throws IOException {
                                BodyRedirectResponseHandler.this.getExchange().sendError(ioe);
                            }
                        };
                        if (BodyRedirectResponseHandler.this.getRequestHeader().getMethod().equals("GET")) {
                            RedirectHandler.this.httpClient.send(new HttpRequest(BodyRedirectResponseHandler.this.getRequestHeader()), respHdl);
                        } else {
                            BodyDataSink ds = RedirectHandler.this.httpClient.send(BodyRedirectResponseHandler.this.getRequestHeader(), respHdl);
                            ds.setFlushmode(IConnection.FlushMode.ASYNC);
                            BodyRedirectResponseHandler.this.inMemorySink.forwardTo(new DuplicatingBodyForwarder.BodyDataSinkAdapter(ds));
                        }
                    }
                    catch (IOException ioe) {
                        BodyRedirectResponseHandler.this.getExchange().sendError(new IOException("can execute redirect request " + BodyRedirectResponseHandler.this.getRequestHeader() + " reason: " + ioe.toString()));
                    }
                }
            };
            RedirectHandler.this.httpClient.getWorkerpool().execute(task);
        }
    }

    abstract class AbstractRedirectResponseHandler
    implements IHttpResponseHandler {
        private IHttpRequestHeader requestHeader = null;
        private IHttpExchange exchange = null;
        private Integer countRedirects = 0;

        AbstractRedirectResponseHandler(IHttpRequestHeader requestHeader, IHttpExchange exchange) throws IOException {
            this.requestHeader = requestHeader;
            this.exchange = exchange;
            this.countRedirects = (Integer)requestHeader.getAttribute(RedirectHandler.COUNT_REDIRECTS_KEY);
            if (this.countRedirects == null) {
                this.countRedirects = 0;
            }
        }

        protected final int incCountRedirect() {
            this.countRedirects = this.countRedirects + 1;
            return this.countRedirects;
        }

        protected final IHttpRequestHeader getRequestHeader() {
            return this.requestHeader;
        }

        protected final IHttpExchange getExchange() {
            return this.exchange;
        }

        @Execution(value=0)
        public void onResponse(IHttpResponse response) throws IOException {
            if (this.isRedirectResponse(this.requestHeader, response.getResponseHeader())) {
                URL newLocation;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("got redirect response: " + response.getResponseHeader());
                }
                if ((newLocation = this.getRedirectURI(response, this.requestHeader.isSecure(), this.requestHeader.getServerName(), this.requestHeader.getServerPort())) == null) {
                    this.exchange.send(response);
                } else {
                    if (response.getStatus() == 303 || response.getStatus() == 302 && RedirectHandler.this.httpClient.isTreat302RedirectAs303()) {
                        this.requestHeader.setMethod("GET");
                        this.requestHeader.removeHeader("Content-Type");
                        this.requestHeader.removeHeader("Content-Length");
                        this.requestHeader.removeHeader("Transfer-Encoding");
                        this.requestHeader.removeHeader("Trailers");
                        this.requestHeader.removeHeader("Upgrade");
                    }
                    this.requestHeader.setRequestUrl(newLocation);
                    if (this.countRedirects < RedirectHandler.this.httpClient.getMaxRedirects()) {
                        if (this.requestHeader.isSecure()) {
                            Runnable task = new Runnable(){

                                public void run() {
                                    AbstractRedirectResponseHandler.this.sendRedirectedRequest();
                                }
                            };
                            RedirectHandler.this.httpClient.getWorkerpool().execute(task);
                        } else {
                            this.sendRedirectedRequest();
                        }
                    } else {
                        this.exchange.sendError(new IOException("max redirects " + RedirectHandler.this.httpClient.getMaxRedirects() + " reached. request will not be executed: " + this.requestHeader));
                    }
                }
            } else {
                this.exchange.send(response);
            }
        }

        abstract void sendRedirectedRequest();

        @Execution(value=0)
        public final void onException(IOException ioe) {
            this.exchange.sendError(ioe);
        }

        final boolean isRedirectResponse(IHttpRequestHeader requestHeader, IHttpResponseHeader responseHeader) {
            switch (responseHeader.getStatus()) {
                case 301: {
                    return this.isRedirectModeAllOrIsGetOrHeadRequest();
                }
                case 302: {
                    if (RedirectHandler.this.httpClient.isTreat302RedirectAs303() && (requestHeader.getMethod().equalsIgnoreCase("POST") || requestHeader.getMethod().equalsIgnoreCase("PUT"))) {
                        return true;
                    }
                    return this.isRedirectModeAllOrIsGetOrHeadRequest();
                }
                case 303: {
                    return requestHeader.getMethod().equalsIgnoreCase("POST") || requestHeader.getMethod().equalsIgnoreCase("PUT");
                }
                case 307: {
                    return this.isRedirectModeAllOrIsGetOrHeadRequest();
                }
            }
            return false;
        }

        private boolean isRedirectModeAllOrIsGetOrHeadRequest() {
            return RedirectHandler.this.httpClient.getFollowsRedirectMode() == HttpClient.FollowsRedirectMode.ALL || RedirectHandler.this.httpClient.getFollowsRedirectMode() == HttpClient.FollowsRedirectMode.RFC && this.isGetOrHeadMethod();
        }

        private boolean isGetOrHeadMethod() {
            return this.requestHeader.getMethod().equalsIgnoreCase("GET") || this.requestHeader.getMethod().equalsIgnoreCase("HEAD");
        }

        private URL getRedirectURI(IHttpResponse response, boolean isSSL, String originalHost, int originalPort) {
            block7: {
                String location = response.getHeader("Location");
                if (location != null) {
                    try {
                        if (this.isRelativeUrl(location)) {
                            if (isSSL) {
                                if (originalPort == -1) {
                                    return new URL("https://" + originalHost + location);
                                }
                                return new URL("https://" + originalHost + ":" + originalPort + location);
                            }
                            if (originalPort == -1) {
                                return new URL("http://" + originalHost + location);
                            }
                            return new URL("http://" + originalHost + ":" + originalPort + location);
                        }
                        return new URL(location);
                    }
                    catch (MalformedURLException e) {
                        if (!LOG.isLoggable(Level.FINE)) break block7;
                        LOG.fine("could not create relocation url . reason " + e.toString());
                    }
                }
            }
            return null;
        }

        private boolean isRelativeUrl(String url) {
            return !(url = url.toUpperCase()).startsWith("HTTP") && !url.startsWith("HTTPS");
        }
    }
}

